/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.crypto.sm;

import com.peersafe.base.crypto.ecdsa.IKeyPair;
import com.peersafe.base.crypto.sm.BCECUtil;
import com.peersafe.base.crypto.sm.SM2Util;
import com.peersafe.base.utils.HashUtils;
import com.peersafe.chainsql.util.Util;
import java.math.BigInteger;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;

public class SMKeyPair
implements IKeyPair {
    BigInteger priv_;
    BigInteger pub_;
    byte[] pubBytes_;
    byte[] seedBytes_;

    public SMKeyPair(byte[] seedBytes, BigInteger priv, BigInteger pub) {
        this.priv_ = priv;
        this.pub_ = pub;
        this.pubBytes_ = pub.toByteArray();
        this.seedBytes_ = seedBytes;
    }

    @Override
    public String type() {
        return "softGMAlg";
    }

    public static SMKeyPair generateKeyPair() {
        try {
            AsymmetricCipherKeyPair keyPair = SM2Util.generateKeyPairParameter();
            ECPrivateKeyParameters priKeyParams = (ECPrivateKeyParameters)keyPair.getPrivate();
            ECPublicKeyParameters pubKeyParams = (ECPublicKeyParameters)keyPair.getPublic();
            String pubX = ByteUtils.toHexString((byte[])pubKeyParams.getQ().getAffineXCoord().getEncoded()).toUpperCase();
            String pubY = ByteUtils.toHexString((byte[])pubKeyParams.getQ().getAffineYCoord().getEncoded()).toUpperCase();
            String publicKeyHex = "47" + pubX + pubY;
            assert (publicKeyHex.length() == 130);
            return new SMKeyPair(null, priKeyParams.getD(), new BigInteger(publicKeyHex, 16));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static SMKeyPair from256Seed(byte[] seedBytes) {
        assert (seedBytes.length == 32);
        BigInteger privateBig = new BigInteger(Util.bytesToHex(seedBytes), 16);
        ECPrivateKeyParameters priKey = new ECPrivateKeyParameters(privateBig, SM2Util.DOMAIN_PARAMS);
        ECPublicKeyParameters pubKey = BCECUtil.buildECPublicKeyByPrivateKey(priKey);
        String pubX = ByteUtils.toHexString((byte[])pubKey.getQ().getAffineXCoord().getEncoded()).toUpperCase();
        String pubY = ByteUtils.toHexString((byte[])pubKey.getQ().getAffineYCoord().getEncoded()).toUpperCase();
        String publicKeyHex = "47" + pubX + pubY;
        assert (publicKeyHex.length() == 130);
        return new SMKeyPair(seedBytes, priKey.getD(), new BigInteger(publicKeyHex, 16));
    }

    @Override
    public String canonicalPubHex() {
        return Util.bytesToHex(this.canonicalPubBytes());
    }

    @Override
    public BigInteger pub() {
        return this.pub_;
    }

    private byte[] pubBytes_() {
        return this.pubBytes_;
    }

    @Override
    public String privHex() {
        String privHex = this.priv_.toString(16).toUpperCase();
        assert (privHex.length() <= 64);
        return String.format("%64s", privHex).replace(" ", "0");
    }

    @Override
    public BigInteger priv() {
        return this.priv_;
    }

    @Override
    public boolean verifySignature(byte[] message, byte[] signedBytes) {
        try {
            assert (this.pubBytes_.length == 65 && this.pubBytes_[0] == 71);
            byte[] pubX = new byte[32];
            System.arraycopy(this.pubBytes_, 1, pubX, 0, 32);
            byte[] pubY = new byte[32];
            System.arraycopy(this.pubBytes_, 33, pubY, 0, 32);
            ECPublicKeyParameters pubKey = BCECUtil.createECPublicKeyParameters(pubX, pubY, (ECCurve)SM2Util.CURVE, SM2Util.DOMAIN_PARAMS);
            byte[] derSigned = SM2Util.encodeSM2SignToDER(signedBytes);
            boolean flag = SM2Util.verify(pubKey, message, derSigned);
            return flag;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] signMessage(byte[] message) {
        try {
            ECPrivateKeyParameters smPrivateKey = new ECPrivateKeyParameters(this.priv_, SM2Util.DOMAIN_PARAMS);
            byte[] sign = SM2Util.sign(smPrivateKey, message);
            byte[] rawSign = SM2Util.decodeDERSM2Sign(sign);
            return rawSign;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] canonicalPubBytes() {
        return this.pubBytes_;
    }

    @Override
    public byte[] pub160Hash() {
        return HashUtils.SHA256_RIPEMD160(this.canonicalPubBytes());
    }
}

