/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.encodings;

import com.peersafe.base.encodings.base58.B58;

public class B58IdentiferCodecs {
    public static final int VER_ACCOUNT_ID = 0;
    public static final int VER_FAMILY_SEED = 33;
    public static final int VER_NONE = 1;
    public static final int VER_NODE_PUBLIC = 28;
    public static final int VER_NODE_PRIVATE = 32;
    public static final int VER_ACCOUNT_PUBLIC = 35;
    public static final int VER_ACCOUNT_PRIVATE = 34;
    public static final int VER_FAMILY_GENERATOR = 41;
    public B58 b58;

    public B58IdentiferCodecs(B58 base58encoder) {
        this.b58 = base58encoder;
    }

    public byte[] decode(String d, int version) {
        return this.b58.decodeChecked(d, version);
    }

    public String encode(byte[] d, int version) {
        return this.b58.encodeToStringChecked(d, version);
    }

    public byte[] decodeFamilySeed(String master_seed) {
        return this.b58.decodeChecked(master_seed, 33);
    }

    public String encodeFamilySeed(byte[] bytes) {
        return this.encode(bytes, 33);
    }

    public String encodeAddress(byte[] bytes) {
        return this.encode(bytes, 0);
    }

    public String encodeNodePublic(byte[] bytes) {
        return this.encode(bytes, 28);
    }

    public String encodeNodePrivate(byte[] bytes) {
        return this.encode(bytes, 32);
    }

    public String encodeAccountPrivate(byte[] bytes) {
        return this.encode(bytes, 34);
    }

    public String encodeAccountPublic(byte[] bytes) {
        return this.encode(bytes, 35);
    }

    public byte[] decodeAddress(String address) {
        return this.decode(address, 0);
    }

    public byte[] decodeAccountPrivate(String secret) {
        return this.decode(secret, 34);
    }

    public byte[] decodeNodePrivate(String secret) {
        return this.decode(secret, 32);
    }
}

