/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.chainsql.core;

import com.peersafe.base.client.Client;
import com.peersafe.base.client.pubsub.Publisher;
import com.peersafe.base.config.Config;
import com.peersafe.base.core.coretypes.AccountID;
import com.peersafe.base.core.coretypes.Amount;
import com.peersafe.base.core.fields.Field;
import com.peersafe.base.core.serialized.enums.TransactionType;
import com.peersafe.base.core.types.known.tx.Transaction;
import com.peersafe.base.core.types.known.tx.signed.SignedTransaction;
import com.peersafe.base.crypto.ecdsa.IKeyPair;
import com.peersafe.base.crypto.ecdsa.Seed;
import com.peersafe.base.utils.Utils;
import com.peersafe.chainsql.core.Ripple;
import com.peersafe.chainsql.core.Submit;
import com.peersafe.chainsql.core.Table;
import com.peersafe.chainsql.crypto.Ecies;
import com.peersafe.chainsql.crypto.EncryptCommon;
import com.peersafe.chainsql.manager.EventManager;
import com.peersafe.chainsql.net.Connection;
import com.peersafe.chainsql.pool.ChainsqlPool;
import com.peersafe.chainsql.resources.Constant;
import com.peersafe.chainsql.util.GenericPair;
import com.peersafe.chainsql.util.Util;
import com.peersafe.chainsql.util.Validate;
import java.math.BigInteger;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class Chainsql
extends Submit {
    private JSONObject mTxJson;
    private static final int PASSWORD_LENGTH = 32;
    private static final int DEFAULT_TX_LIMIT = 20;
    public static final Logger logger = Logger.getLogger(Chainsql.class.getName());
    private JSONObject mRetJson;
    private Publisher.Callback<JSONObject> reconnectCb = null;
    private Publisher.Callback<JSONObject> reconnectedCB = null;
    public static String MAIN_SCHEMA = "";
    public final EventManager event = this.eventManager;

    public void as(String address, String secret) {
        JSONObject retAddress = this.generateAddress(secret);
        if (retAddress.has("address") && !address.equals(retAddress.getString("address"))) {
            System.err.println("Exception: address and secret not match !");
        }
        this.connection.address = address;
        this.connection.secret = secret;
        if (this.connection.scope == null) {
            this.connection.scope = address;
        }
    }

    public void useCert(String userCert) {
        this.connection.userCert = userCert;
    }

    public void setSchema(String schemaID) {
        if (!this.connection.client.schemaID.equals(schemaID)) {
            this.connection.client.unsubscribeStreams();
            this.connection.client.schemaID = schemaID;
            this.connection.client.resubscribeStreams();
        }
    }

    public void use(String address) {
        this.connection.scope = address;
    }

    public Connection connect(String url) {
        this.connection = new Connection().connect(url);
        this.doWhenConnect();
        return this.connection;
    }

    public Connection connect(String url, String serverCertPath, String storePass) {
        this.connection = new Connection().connect(url, serverCertPath, storePass);
        this.doWhenConnect();
        return this.connection;
    }

    public Connection connect(String url, Publisher.Callback<Client> connectCb) {
        return this.connect(url, connectCb, null);
    }

    public Connection connect(String url, Publisher.Callback<Client> connectCb, Publisher.Callback<Client> disconnectCb) {
        this.connection = new Connection().connect(url);
        this.eventManager.init(this.connection);
        this.connection.client.onConnected(connectCb::called);
        if (disconnectCb != null) {
            this.connection.client.onDisconnected(disconnectCb::called);
        }
        return this.connection;
    }

    public Connection connect(String url, String serverCertPath, String storePass, Publisher.Callback<Client> connectCb) {
        return this.connect(url, serverCertPath, storePass, connectCb, null);
    }

    public Connection connect(String url, String serverCertPath, String storePass, Publisher.Callback<Client> connectCb, Publisher.Callback<Client> disconnectCb) {
        this.connection = new Connection().connect(url, serverCertPath, storePass);
        this.eventManager.init(this.connection);
        this.connection.client.onConnected(connectCb::called);
        if (disconnectCb != null) {
            this.connection.client.onDisconnected(disconnectCb::called);
        }
        return this.connection;
    }

    private void doWhenConnect() {
        while (!this.connection.client.connected) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        System.out.println("connect success");
        this.eventManager.init(this.connection);
        this.connection.client.onReconnecting(this::onReconnecting);
        this.connection.client.onReconnected(this::onReconnected);
    }

    public static void shutdown() {
        ChainsqlPool.instance().shutdown();
        Client.shutdown();
    }

    public static List<String> array(String val0, String ... vals) {
        ArrayList<String> res = new ArrayList<String>();
        res.add(val0);
        res.addAll(Arrays.asList(vals));
        return res;
    }

    public void onReconnected(Publisher.Callback<JSONObject> cb) {
        this.reconnectedCB = cb;
    }

    public void onReconnecting(Publisher.Callback<JSONObject> cb) {
        this.reconnectCb = cb;
    }

    private void onReconnecting(JSONObject cb) {
        if (this.reconnectCb != null) {
            this.reconnectCb.called(cb);
        }
    }

    private void onReconnected(JSONObject cb) {
        if (this.reconnectedCB != null) {
            this.reconnectedCB.called(cb);
        }
        this.eventManager.reSubscribe();
    }

    public void disconnect() {
        this.connection.disconnect();
    }

    public Table table(String name) {
        Table tab = new Table(name);
        if (this.transaction) {
            tab.transaction = this.transaction;
            tab.cache = this.cache;
            tab.mapToken = this.mapToken;
        }
        tab.strictMode = this.strictMode;
        tab.connection = this.connection;
        tab.setCrossChainArgs(this.crossChainArgs);
        tab.eventManager = this.eventManager;
        tab.extraDrop = this.extraDrop;
        return tab;
    }

    public void setUseGM(boolean useGM, boolean bNewKeyPair, String pin) throws Exception {
        boolean isSuccess = Config.setUseGM(useGM, bNewKeyPair, pin);
        if (!isSuccess) {
            throw new Exception("\u8bbe\u7f6e\u4f7f\u7528\u56fd\u5bc6\u5931\u8d25!");
        }
    }

    public boolean isUseGM() {
        return Config.isUseGM();
    }

    public JSONObject sign(JSONObject tx, String secret) {
        JSONObject tx_json = tx.getJSONObject("tx_json");
        TransactionType type = TransactionType.valueOf(tx_json.getString("TransactionType"));
        Transaction transaction = new Transaction(type);
        try {
            transaction.parseFromJson(tx_json);
            this.checkFee(transaction, tx_json);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SignedTransaction signed = transaction.sign(secret);
        JSONObject obj = new JSONObject();
        obj.put("tx_blob", (Object)signed.tx_blob);
        obj.put("hash", (Object)signed.hash.toString());
        return obj;
    }

    public JSONObject signFor(JSONObject tx, String secret) {
        if (!tx.has("secret")) {
            return Util.errorObject("no secret supplied");
        }
        if (!tx.has("account")) {
            return Util.errorObject("no account supplied");
        }
        JSONObject tx_json = tx.getJSONObject("tx_json");
        TransactionType type = TransactionType.valueOf(tx_json.getString("TransactionType"));
        Transaction transaction = new Transaction(type);
        try {
            transaction.parseFromJson(tx_json);
            this.checkFee(transaction, tx_json);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SignedTransaction signed = transaction.multiSign(secret);
        String sJson = signed.txn.prettyJSON();
        IKeyPair keyPair = Seed.fromBase58(secret).keyPair();
        String publicKey = Util.bytesToHex(keyPair.canonicalPubBytes());
        JSONObject json = new JSONObject(sJson);
        JSONObject signer = new JSONObject();
        signer.put("Account", (Object)tx.getString("account"));
        signer.put("SigningPubKey", (Object)publicKey);
        signer.put("TxnSignature", (Object)json.getString("TxnSignature"));
        JSONObject ret = new JSONObject();
        ret.put("Signer", (Object)signer);
        ret.put("hash", (Object)signed.hash.toString());
        return ret;
    }

    private void checkFee(Transaction transaction, JSONObject tx_json) {
        if (!tx_json.has("Fee")) {
            if (this.connection != null && this.connection.client != null && this.connection.client.serverInfo != null) {
                Amount fee = this.connection.client.serverInfo.transactionFee(transaction);
                transaction.as(Amount.Fee, fee);
            } else {
                transaction.as(Amount.Fee, "50");
            }
        }
    }

    @Override
    protected JSONObject prepareSigned() {
        try {
            Transaction payment;
            JSONObject tx_json;
            Transaction payment2;
            if (this.connection.userCert != null) {
                String sCert = Util.toHexString(this.connection.userCert);
                this.mTxJson.put("Certificate", (Object)sCert);
            }
            if (this.schemaCreateTx) {
                payment2 = this.toTransaction(this.mTxJson, TransactionType.SchemaCreate);
                this.signed = payment2.sign(this.connection.secret);
                this.schemaCreateTx = false;
                return Util.successObject();
            }
            if (this.schemaModifyTx) {
                payment2 = this.toTransaction(this.mTxJson, TransactionType.SchemaModify);
                this.signed = payment2.sign(this.connection.secret);
                this.schemaModifyTx = false;
                return Util.successObject();
            }
            if (this.mTxJson.toString().equals("{}")) {
                return Util.errorObject("Exception occured");
            }
            this.mTxJson.put("Account", (Object)this.connection.address);
            if (this.crossChainArgs != null) {
                this.mTxJson.put("TxnLgrSeq", this.crossChainArgs.txnLedgerSeq);
                this.mTxJson.put("OriginalAddress", (Object)this.crossChainArgs.originalAddress);
                this.mTxJson.put("CurTxHash", (Object)this.crossChainArgs.curTxHash);
                this.mTxJson.put("FutureTxHash", (Object)this.crossChainArgs.futureHash);
                this.crossChainArgs = null;
            }
            if ((tx_json = this.connection.client.tablePrepare(this.mTxJson)).has("error")) {
                return tx_json;
            }
            tx_json = tx_json.getJSONObject("tx_json");
            if (this.transaction) {
                tx_json.put("Statements", (Object)Util.toHexString(tx_json.getJSONArray("Statements").toString()));
                payment = this.toTransaction(tx_json, TransactionType.SQLTransaction);
            } else {
                payment = this.toTransaction(tx_json, TransactionType.TableListSet);
            }
            this.signed = payment.sign(this.connection.secret);
            return Util.successObject();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Util.errorObject(e.getMessage());
        }
    }

    public void setExtraFee(int extraDrop) throws Exception {
        if (extraDrop > 1000000 || extraDrop <= 0) {
            throw new Exception("\u8bbe\u7f6e\u7684\u989d\u5916\u8d39\u7528\u8d85\u8fc71ZXC\u6216\u4f4e\u4e8e0drop");
        }
        this.extraDrop = extraDrop;
    }

    public Chainsql createTable(String name, List<String> raw) {
        return this.createTable(name, raw, false);
    }

    public Chainsql createTable(String name, List<String> raw, JSONObject operationRule) {
        return this.createTable(name, raw, operationRule, false);
    }

    public Chainsql createTable(String name, List<String> rawList, boolean confidential) {
        return this.createTable(name, rawList, null, confidential);
    }

    public Chainsql createSchema(JSONObject schemaInfo) throws Exception {
        boolean bValid;
        boolean bl = bValid = schemaInfo.has("SchemaName") && schemaInfo.has("WithState") && schemaInfo.has("Validators") && schemaInfo.has("PeerList");
        if (!bValid) {
            throw new Exception("Invalid schemaInfo parameter");
        }
        JSONObject params = new JSONObject();
        params.put("Account", (Object)this.connection.address);
        params.put("SchemaName", (Object)Util.toHexString(schemaInfo.getString("SchemaName")));
        if (schemaInfo.has("SchemaAdmin")) {
            params.put("SchemaAdmin", (Object)schemaInfo.getString("SchemaAdmin"));
        }
        if (schemaInfo.getBoolean("WithState")) {
            if (!schemaInfo.has("AnchorLedgerHash")) {
                throw new Exception("Missing field AnchorLedgerHash");
            }
            params.put("AnchorLedgerHash", (Object)schemaInfo.getString("AnchorLedgerHash"));
            params.put("SchemaStrategy", 2);
        } else {
            params.put("SchemaStrategy", 1);
            if (schemaInfo.has("AnchorLedgerHash")) {
                throw new Exception("Field 'AnchorLedgerHash' is unnecessary");
            }
        }
        this.schemaCreateTx = true;
        JSONArray validatorsArr = schemaInfo.getJSONArray("Validators");
        JSONArray peerListArr = schemaInfo.getJSONArray("PeerList");
        JSONArray jsonValidators = new JSONArray();
        for (int i = 0; i < validatorsArr.length(); ++i) {
            String validator = (String)validatorsArr.get(i);
            JSONObject subItem = new JSONObject();
            subItem.put("PublicKey", validatorsArr.get(i));
            JSONObject item = new JSONObject();
            item.put("Validator", (Object)subItem);
            jsonValidators.put((Object)item);
        }
        JSONArray jsonPeerList = new JSONArray();
        for (int i = 0; i < peerListArr.length(); ++i) {
            String Endpoint = (String)peerListArr.get(i);
            JSONObject subItem = new JSONObject();
            subItem.put("Endpoint", (Object)Util.toHexString(Endpoint));
            JSONObject item = new JSONObject();
            item.put("Peer", (Object)subItem);
            jsonPeerList.put((Object)item);
        }
        params.put("Validators", (Object)jsonValidators);
        params.put("PeerList", (Object)jsonPeerList);
        this.mTxJson = params;
        return this;
    }

    public Chainsql modifySchema(Submit.SchemaOpType type, JSONObject schemaInfo) throws Exception {
        boolean bValid;
        boolean bl = bValid = schemaInfo.has("SchemaID") && schemaInfo.has("Validators") && schemaInfo.has("PeerList");
        if (!bValid) {
            throw new Exception("Invalid schemaInfo parameter");
        }
        this.schemaModifyTx = true;
        JSONObject params = new JSONObject();
        if (type == Submit.SchemaOpType.schema_del) {
            params.put("OpType", (Object)"2");
        } else {
            params.put("OpType", (Object)"1");
        }
        JSONArray validatorsArr = schemaInfo.getJSONArray("Validators");
        JSONArray peerListArr = schemaInfo.getJSONArray("PeerList");
        JSONArray jsonValidators = new JSONArray();
        for (int i = 0; i < validatorsArr.length(); ++i) {
            String validator = (String)validatorsArr.get(i);
            JSONObject subItem = new JSONObject();
            subItem.put("PublicKey", validatorsArr.get(i));
            JSONObject item = new JSONObject();
            item.put("Validator", (Object)subItem);
            jsonValidators.put((Object)item);
        }
        JSONArray jsonPeerList = new JSONArray();
        for (int i = 0; i < peerListArr.length(); ++i) {
            String Endpoint = (String)peerListArr.get(i);
            JSONObject subItem = new JSONObject();
            subItem.put("Endpoint", (Object)Util.toHexString(Endpoint));
            JSONObject item = new JSONObject();
            item.put("Peer", (Object)subItem);
            jsonPeerList.put((Object)item);
        }
        params.put("Account", (Object)this.connection.address);
        params.put("SchemaID", (Object)schemaInfo.getString("SchemaID"));
        params.put("Validators", (Object)jsonValidators);
        params.put("PeerList", (Object)jsonPeerList);
        this.mTxJson = params;
        return this;
    }

    private Chainsql createTable(String name, List<String> rawList, JSONObject operationRule, boolean confidential) {
        List<JSONObject> listRaw = Util.ListToJsonList(rawList);
        try {
            Validate.checkCreate(listRaw, name);
        }
        catch (Exception e) {
            this.mTxJson = new JSONObject();
            System.out.println("Exception:" + e.getLocalizedMessage());
            return this;
        }
        JSONObject json = new JSONObject();
        json.put("OpType", (Object)Constant.opType.get("t_create"));
        json.put("Tables", (Object)this.getTableArray(name));
        json.put("StrictMode", this.strictMode);
        String strRaw = listRaw.toString();
        String token = "";
        if (confidential) {
            boolean bSM = Utils.getAlgType(this.connection.secret).equals("softGMAlg");
            int randomSize = bSM ? 16 : 32;
            byte[] password = Util.getRandomBytes(randomSize);
            token = this.generateUserToken(this.connection.secret, password);
            if (token.length() == 0) {
                System.out.println("generateUserToken failed");
                return null;
            }
            json.put("Token", (Object)token);
            byte[] rawBytes = EncryptCommon.symEncrypt(strRaw.getBytes(), password, bSM);
            strRaw = Util.bytesToHex(rawBytes);
        } else {
            strRaw = Util.toHexString(strRaw);
        }
        json.put(Field.Raw.toString(), (Object)strRaw);
        if (operationRule != null) {
            json.put(Field.OperationRule.toString(), (Object)Util.toHexString(operationRule.toString()));
        }
        if (this.transaction) {
            if (confidential) {
                this.mapToken.put(new GenericPair<String, String>(this.connection.address, name), token);
                this.needVerify = 0;
            } else {
                this.mapToken.put(new GenericPair<String, String>(this.connection.address, name), "");
            }
            this.cache.add(json);
            return null;
        }
        this.mTxJson = json;
        return this;
    }

    private String generateUserToken(String seed, byte[] password) {
        byte[] tokenBytes;
        IKeyPair keyPair = Seed.getKeyPair(seed);
        if (Config.isUseGM()) {
            tokenBytes = EncryptCommon.asymEncrypt(password, null);
        } else {
            assert (keyPair != null);
            tokenBytes = EncryptCommon.asymEncrypt(password, keyPair.canonicalPubBytes());
        }
        return tokenBytes == null ? "" : Util.bytesToHex(tokenBytes);
    }

    public Chainsql recreateTable(String name) {
        JSONObject json = new JSONObject();
        json.put("OpType", (Object)Constant.opType.get("t_recreate"));
        json.put("Tables", (Object)this.getTableArray(name));
        if (this.transaction) {
            this.cache.add(json);
            return null;
        }
        this.mTxJson = json;
        return this;
    }

    public Chainsql dropTable(String name) {
        JSONObject json = new JSONObject();
        json.put("OpType", (Object)Constant.opType.get("t_drop"));
        json.put("Tables", (Object)this.getTableArray(name));
        if (this.transaction) {
            this.cache.add(json);
            return null;
        }
        this.mTxJson = json;
        return this;
    }

    public Chainsql renameTable(String oldName, String newName) {
        if (newName == null || newName.isEmpty()) {
            System.out.println("new table name can not be empty");
            this.mTxJson = new JSONObject();
            return this;
        }
        String tablestr = "{\"Table\":{\"TableName\":\"" + Util.toHexString(oldName) + "\",\"TableNewName\":\"" + Util.toHexString(newName) + "\"}}";
        JSONArray table = new JSONArray();
        table.put((Object)new JSONObject(tablestr));
        JSONObject json = new JSONObject();
        json.put("OpType", (Object)Constant.opType.get("t_rename"));
        json.put("Tables", (Object)table);
        if (this.transaction) {
            this.cache.add(json);
            return null;
        }
        this.mTxJson = json;
        return this;
    }

    public Chainsql addTableFields(String name, List<String> rawList) throws Exception {
        return this.modifyTable(Constant.opType.get("t_add_fields"), name, rawList);
    }

    public Chainsql deleteTableFields(String name, List<String> rawList) throws Exception {
        return this.modifyTable(Constant.opType.get("t_delete_fields"), name, rawList);
    }

    public Chainsql modifyTableFields(String name, List<String> rawList) throws Exception {
        return this.modifyTable(Constant.opType.get("t_modify_fields"), name, rawList);
    }

    public Chainsql createIndex(String name, List<String> rawList) throws Exception {
        return this.modifyTable(Constant.opType.get("t_create_index"), name, rawList);
    }

    public Chainsql deleteIndex(String name, List<String> rawList) throws Exception {
        return this.modifyTable(Constant.opType.get("t_delete_index"), name, rawList);
    }

    private Chainsql modifyTable(int opType, String name, List<String> rawList) throws Exception {
        List<JSONObject> listRaw = Util.ListToJsonList(rawList);
        String strRaw = listRaw.toString();
        String token = Util.getUserToken(this.connection, this.connection.address, name);
        strRaw = Util.encryptRaw(this.connection, token, strRaw);
        JSONObject json = new JSONObject();
        json.put("OpType", opType);
        json.put("Tables", (Object)this.getTableArray(name));
        json.put("Raw", (Object)strRaw);
        this.mTxJson = json;
        return this;
    }

    private boolean checkUserMatchPublic(String user, String userPublicKey) {
        if (user.isEmpty() || userPublicKey.isEmpty()) {
            return false;
        }
        byte[] pubBytes = Config.getB58IdentiferCodecs().decode(userPublicKey, 35);
        SHA256Digest sha = new SHA256Digest();
        sha.update(pubBytes, 0, pubBytes.length);
        byte[] result = new byte[sha.getDigestSize()];
        sha.doFinal(result, 0);
        RIPEMD160Digest d = new RIPEMD160Digest();
        d.update(result, 0, result.length);
        byte[] o = new byte[d.getDigestSize()];
        d.doFinal(o, 0);
        String address = Config.getB58IdentiferCodecs().encodeAddress(o);
        return user.equals(address);
    }

    public Chainsql grant(String name, String user, String userPublicKey, String flag) {
        String token = "";
        if (!this.checkUserMatchPublic(user, userPublicKey)) {
            logger.log(Level.SEVERE, "PublicKey does not match User");
            return null;
        }
        GenericPair<String, String> pair = new GenericPair<String, String>(this.connection.address, name);
        if (this.mapToken.containsKey(pair)) {
            token = (String)this.mapToken.get(pair);
        } else {
            JSONObject res = this.connection.client.getUserToken(this.connection.address, this.connection.address, name);
            if (res.has("error")) {
                System.err.println(res.getString("error_message"));
                return this;
            }
            if (res.has("token")) {
                token = res.getString("token");
            }
        }
        String newToken = "";
        if (token.length() != 0) {
            try {
                byte[] password;
                byte[] seedBytes = null;
                boolean bSoftGM = Utils.getAlgType(this.connection.secret).equals("softGMAlg");
                if (!this.connection.secret.isEmpty()) {
                    seedBytes = bSoftGM ? Config.getB58IdentiferCodecs().decodeAccountPrivate(this.connection.secret) : Config.getB58IdentiferCodecs().decodeFamilySeed(this.connection.secret);
                }
                if ((password = EncryptCommon.asymDecrypt(Util.hexToBytes(token), seedBytes, bSoftGM)) == null) {
                    return null;
                }
                byte[] pubBytes = Config.getB58IdentiferCodecs().decode(userPublicKey, 35);
                byte[] newBytes = EncryptCommon.asymEncrypt(password, pubBytes);
                newToken = Util.bytesToHex(newBytes);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.grant_inner(name, user, flag, newToken);
    }

    public Chainsql grant(String name, String user, String flag) {
        return this.grant_inner(name, user, flag, "");
    }

    private Chainsql grant_inner(String name, String user, String flag, String token) {
        ArrayList<JSONObject> flags = new ArrayList<JSONObject>();
        flags.add(Util.StrToJson(flag));
        JSONObject json = new JSONObject();
        json.put("Tables", (Object)this.getTableArray(name));
        json.put("OpType", (Object)Constant.opType.get("t_grant"));
        json.put("User", (Object)user);
        json.put("Raw", (Object)Util.toHexString(((Object)flags).toString()));
        if (token.length() > 0) {
            json.put("Token", (Object)token);
        }
        if (this.transaction) {
            this.cache.add(json);
            return null;
        }
        this.mTxJson = json;
        return this;
    }

    public Ripple createRippleTransaction(JSONObject tx_json) {
        Ripple ripple = new Ripple(this);
        ripple.setTxJson(tx_json);
        return ripple;
    }

    public Ripple pay(String accountId, String value) {
        Ripple ripple = new Ripple(this);
        return ripple.pay(accountId, value);
    }

    public Ripple pay(String accountId, String value, String sCurrency, String sIssuer) {
        Ripple ripple = new Ripple(this);
        return ripple.pay(accountId, value, sCurrency, sIssuer);
    }

    public Ripple payToContract(String contract_address, String value, int gasLimit) {
        Ripple ripple = new Ripple(this);
        return ripple.payToContract(contract_address, value, gasLimit);
    }

    public Ripple escrowCreate(String sDestAddr, String value, String dateFormatTMFinish, String dateFormatTMCancel) throws Exception {
        Ripple ripple = new Ripple(this);
        return ripple.escrowCreate(sDestAddr, value, dateFormatTMFinish, dateFormatTMCancel);
    }

    public Ripple escrowCreate(String sDestAddr, String value, String sCurrency, String sIssuer, String dateFormatTMFinish, String dateFormatTMCancel) throws Exception {
        Ripple ripple = new Ripple(this);
        return ripple.escrowCreate(sDestAddr, value, sCurrency, sIssuer, dateFormatTMFinish, dateFormatTMCancel);
    }

    public Ripple escrowExecute(String sOwner, int nCreateEscrowSeq) {
        Ripple ripple = new Ripple(this);
        return ripple.escrowExecute(sOwner, nCreateEscrowSeq);
    }

    public Ripple escrowCancel(String sOwner, int nCreateEscrowSeq) {
        Ripple ripple = new Ripple(this);
        return ripple.escrowCancel(sOwner, nCreateEscrowSeq);
    }

    public Ripple accountSet(int nFlag, boolean bSet) {
        Ripple ripple = new Ripple(this);
        return ripple.accountSet(nFlag, bSet);
    }

    public Ripple accountSet(String transferRate, String transferFeeMin, String transferFeeMax) throws Exception {
        Ripple ripple = new Ripple(this);
        return ripple.accountSet(transferRate, transferFeeMin, transferFeeMax);
    }

    public Ripple whitelistSet(JSONArray whitelists, int setFlag) throws Exception {
        Ripple ripple = new Ripple(this);
        return ripple.whitelistSet(whitelists, setFlag);
    }

    public Ripple trustSet(String value, String sCurrency, String sIssuer) {
        Ripple ripple = new Ripple(this);
        return ripple.trustSet(value, sCurrency, sIssuer);
    }

    public void beginTran() {
        this.transaction = true;
    }

    private void endTran() {
        this.transaction = false;
        this.mapToken.clear();
        this.cache.clear();
    }

    public JSONObject commit() {
        JSONObject obj = this.doCommit("");
        this.endTran();
        return obj;
    }

    public Chainsql report() {
        this.mTxJson = new JSONObject();
        this.mTxJson.put("OpType", (Object)Constant.opType.get("t_report"));
        this.mTxJson.put("Tables", (Object)this.getTableArray("t_report_tablename_xxx_xxx"));
        return this;
    }

    public JSONObject getServerInfo() {
        return this.connection.client.getServerInfo();
    }

    public JSONObject getPeers() {
        return this.connection.client.getPeers();
    }

    public JSONObject getChainInfo() {
        JSONObject obj = new JSONObject();
        try {
            JSONObject serverInfo = this.getServerInfo();
            String ledger_range = serverInfo.getJSONObject("info").getString("complete_ledgers");
            if (ledger_range.equals("empty")) {
                return obj;
            }
            int startIndex = ledger_range.indexOf(44) == -1 ? 0 : ledger_range.lastIndexOf(44) + 1;
            int endIndex = ledger_range.lastIndexOf(45);
            int startLedger = Integer.parseInt(ledger_range.substring(startIndex, endIndex));
            int skipedTime = (startLedger - 1) * 3;
            startLedger = Math.max(startLedger, 2);
            JSONObject firstLedger = this.getLedger(startLedger);
            JSONObject lastLedger = this.getLedger();
            if (firstLedger == null) {
                System.out.println("error_message:get first ledger failed ,please ensure connecting to a full-history server");
            } else {
                obj.put("tx_count", (Object)this.getTransactionCount());
                int seconds1 = firstLedger.getJSONObject("ledger").getInt("close_time");
                int seconds2 = lastLedger.getJSONObject("ledger").getInt("close_time");
                obj.put("chain_time", seconds2 - seconds1 + skipedTime);
            }
            return obj;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private JSONObject getTransactionCount() {
        return this.connection.client.getTransactionCount();
    }

    public JSONObject getLedger() {
        return this.getLedger(-1);
    }

    public JSONObject getLedger(Integer ledger_index) {
        JSONObject option = new JSONObject();
        if (ledger_index == -1) {
            option.put("ledger_index", (Object)"validated");
        } else {
            option.put("ledger_index", (Object)ledger_index);
        }
        return this.connection.client.getLedger(option);
    }

    public void getLedger(Publisher.Callback<JSONObject> cb) {
        JSONObject option = new JSONObject();
        option.put("ledger_index", (Object)"validated");
        this.connection.client.getLedger(option, cb);
    }

    public void getLedger(Integer ledger_index, Publisher.Callback<JSONObject> cb) {
        JSONObject option = new JSONObject();
        option.put("ledger_index", (Object)ledger_index);
        this.connection.client.getLedger(option, cb);
    }

    public JSONObject getLedgerVersion() {
        return this.connection.client.getLedgerVersion();
    }

    public void getLedgerVersion(Publisher.Callback<JSONObject> cb) {
        this.connection.client.getLedgerVersion(cb);
    }

    public JSONObject getAccountTransactions(String address, int limit) {
        return this.connection.client.getTransactions(address, limit);
    }

    public JSONObject getCrossChainTxs(String hash, int limit, boolean include) {
        if (hash == null) {
            return Util.errorObject("hash cannot be null");
        }
        this.mRetJson = null;
        this.connection.client.getCrossChainTxs(hash, limit, include, data -> {
            this.mRetJson = data == null ? new JSONObject() : data;
        });
        while (this.mRetJson == null) {
            Util.waiting();
        }
        if (this.mRetJson.has("transactions")) {
            return this.mRetJson;
        }
        return null;
    }

    public JSONObject getAccountTransactions(String address) {
        return this.getAccountTransactions(address, 20);
    }

    public void getAccountTransactions(String address, Publisher.Callback<JSONObject> cb) {
        this.connection.client.getTransactions(address, 20, cb);
    }

    public void getAccountTransactions(String address, int limit, Publisher.Callback<JSONObject> cb) {
        this.connection.client.getTransactions(address, limit, cb);
    }

    public JSONObject getTransaction(String hash) {
        return this.connection.client.getTransaction(hash);
    }

    public JSONObject getTransaction(JSONObject txInfo) throws Exception {
        if (txInfo == null || !txInfo.has("hash")) {
            throw new Exception("txInfo has no field of hash");
        }
        return this.connection.client.getTransaction(txInfo);
    }

    public void getTransaction(String hash, Publisher.Callback<JSONObject> cb) {
        this.connection.client.getTransaction(hash, cb);
    }

    public JSONObject generateAddress() {
        Security.addProvider((Provider)new BouncyCastleProvider());
        Seed seed = Seed.randomSeed();
        return this.generateAddress(seed);
    }

    public JSONObject generateAddress(String secret) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        Seed seed = Seed.fromBase58(secret);
        return this.generateAddress(seed);
    }

    public JSONObject generateAddress(JSONObject options) {
        Seed seed;
        Security.addProvider((Provider)new BouncyCastleProvider());
        byte[] version = Seed.VER_K256;
        if (options.has("algorithm")) {
            String sVersion;
            switch (sVersion = options.getString("algorithm")) {
                case "ed25519": {
                    version = Seed.VER_ED25519;
                    break;
                }
                case "secp256k1": {
                    version = Seed.VER_K256;
                    break;
                }
                case "softGMAlg": {
                    version = Seed.VER_SOFT_SM;
                    break;
                }
                default: {
                    version = Seed.VER_ED25519;
                }
            }
        }
        if (options.has("secret")) {
            String sSecret = options.getString("secret");
            seed = Seed.fromBase58(sSecret);
        } else {
            seed = Seed.randomSeed(version);
        }
        return this.generateAddress(seed);
    }

    private JSONObject generateAddress(Seed seed) {
        IKeyPair keyPair;
        if (Config.isUseGM()) {
            seed.setGM();
        }
        if ((keyPair = seed.keyPair()).type().equals("softGMAlg")) {
            JSONObject softGMAddress = new JSONObject();
            String privHex = keyPair.privHex();
            String secretKey = Config.getB58IdentiferCodecs().encodeAccountPrivate(ByteUtils.fromHexString((String)privHex));
            String publicKey = Config.getB58IdentiferCodecs().encodeAccountPublic(keyPair.canonicalPubBytes());
            String address = Utils.deriveAddressFromBytes(keyPair.canonicalPubBytes());
            softGMAddress.put("secret", (Object)secretKey);
            softGMAddress.put("publicKey", (Object)publicKey);
            softGMAddress.put("address", (Object)address);
            return softGMAddress;
        }
        byte[] pubBytes = keyPair.canonicalPubBytes();
        SHA256Digest sha = new SHA256Digest();
        sha.update(pubBytes, 0, pubBytes.length);
        byte[] result = new byte[sha.getDigestSize()];
        sha.doFinal(result, 0);
        RIPEMD160Digest d = new RIPEMD160Digest();
        d.update(result, 0, result.length);
        byte[] o = new byte[d.getDigestSize()];
        d.doFinal(o, 0);
        String secretKey = Config.getB58IdentiferCodecs().encodeFamilySeed(seed.bytes());
        String publicKey = Config.getB58IdentiferCodecs().encode(pubBytes, 35);
        String address = Config.getB58IdentiferCodecs().encodeAddress(o);
        JSONObject obj = new JSONObject();
        if (!Config.isUseGM()) {
            obj.put("secret", (Object)secretKey);
        }
        obj.put("address", (Object)address);
        obj.put("publicKey", (Object)publicKey);
        return obj;
    }

    public JSONArray validationCreate(int count) {
        JSONArray ret = new JSONArray();
        for (int i = 0; i < count; ++i) {
            JSONObject obj = this.validationCreate();
            ret.put((Object)obj);
        }
        return ret;
    }

    public JSONObject validationCreate() {
        Security.addProvider((Provider)new BouncyCastleProvider());
        JSONObject ret = new JSONObject();
        Seed seed = Seed.randomSeed();
        IKeyPair keyPair = seed.keyPair(-1);
        byte[] pubBytes = keyPair.canonicalPubBytes();
        String secretKey = Config.getB58IdentiferCodecs().encodeFamilySeed(seed.bytes());
        String validation_publickey = Config.getB58IdentiferCodecs().encodeNodePublic(pubBytes);
        ret.put("seed", (Object)secretKey);
        ret.put("publickey", (Object)validation_publickey);
        return ret;
    }

    public JSONObject validationCreate(JSONObject options) {
        Seed seed;
        Security.addProvider((Provider)new BouncyCastleProvider());
        boolean bSoftGMAlg = options.has("algorithm") && options.get("algorithm") == "softGMAlg";
        boolean hasSecret = options.has("secret");
        if (!bSoftGMAlg) {
            return this.validationCreate();
        }
        byte[] version = Seed.VER_SOFT_SM;
        if (hasSecret) {
            String sSecret = options.getString("secret");
            byte[] secretBytes = Config.getB58IdentiferCodecs().decodeNodePrivate(sSecret);
            seed = new Seed(version, secretBytes);
        } else {
            seed = Seed.randomSeed(version);
        }
        IKeyPair keyPair = seed.keyPair();
        String sPrivHex = keyPair.privHex();
        String secretKey = Config.getB58IdentiferCodecs().encodeNodePrivate(ByteUtils.fromHexString((String)sPrivHex));
        assert (secretKey.charAt(0) == 'p');
        String validationPub = Config.getB58IdentiferCodecs().encodeNodePublic(keyPair.canonicalPubBytes());
        JSONObject ret = new JSONObject();
        ret.put("seed", (Object)secretKey);
        ret.put("publickey", (Object)validationPub);
        ret.put("validation_public_key_hex", (Object)Util.bytesToHex(keyPair.canonicalPubBytes()));
        return ret;
    }

    public JSONObject getUnlList() {
        return this.connection.client.getUnlList();
    }

    public Connection getConnection() {
        return this.connection;
    }

    public JSONObject getAccountInfo(String address) {
        AccountID account = AccountID.fromAddress(address);
        return this.connection.client.accountInfo(account);
    }

    public String getAccountBalance(String address) {
        try {
            AccountID account = AccountID.fromAddress(address);
            JSONObject result = this.connection.client.accountInfo(account);
            if (!result.has("error")) {
                String balance = result.optJSONObject("account_data").getString("Balance");
                BigInteger bal = new BigInteger(balance);
                BigInteger zxc = bal.divide(BigInteger.valueOf(1000000L));
                BigInteger mod = bal.mod(BigInteger.valueOf(1000000L));
                String sMod = mod.toString();
                for (int addNum = 6 - sMod.length(); addNum > 0; --addNum) {
                    sMod = "0" + sMod;
                }
                String finalZxc = zxc.toString();
                finalZxc = finalZxc + ".";
                finalZxc = finalZxc + sMod;
                return finalZxc;
            }
            System.err.println(result.get("error_message"));
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public JSONObject doCommit(Object commitType) {
        List cache = this.cache;
        JSONArray statements = new JSONArray();
        for (JSONObject jsonObject : cache) {
            statements.put((Object)jsonObject);
        }
        JSONObject json = new JSONObject();
        json.put("TransactionType", (Object)TransactionType.SQLTransaction);
        json.put("Account", (Object)this.connection.address);
        json.put("Statements", (Object)statements);
        json.put("NeedVerify", (Object)this.needVerify);
        this.mTxJson = json;
        try {
            if (commitType instanceof Submit.SyncCond) {
                return this.submit((Submit.SyncCond)((Object)commitType));
            }
            if (commitType instanceof Publisher.Callback) {
                return this.submit((Publisher.Callback)commitType);
            }
            return this.submit();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public JSONObject commit(Submit.SyncCond cond) {
        JSONObject obj = this.doCommit((Object)cond);
        this.endTran();
        return obj;
    }

    public JSONObject commit(Publisher.Callback<?> cb) {
        JSONObject obj = this.doCommit(cb);
        this.endTran();
        return obj;
    }

    public String encrypt(String plainText, List<String> listPublicKey) {
        if (listPublicKey.size() == 0) {
            logger.log(Level.SEVERE, "PublicKey list is empty");
            return "";
        }
        byte[] cipher = Ecies.encryptText(plainText, listPublicKey);
        if (cipher == null) {
            return "";
        }
        return Util.bytesToHex(cipher);
    }

    public String decrypt(String cipher, String secret) {
        byte[] cipherBytes = Util.hexToBytes(cipher);
        return Ecies.decryptText(cipherBytes, secret);
    }

    public JSONObject getAccountTables(String address, boolean bGetDetail) {
        return this.connection.client.getAccountTables(address, bGetDetail);
    }

    public void getAccountTables(String address, boolean bGetDetail, Publisher.Callback<JSONObject> cb) {
        this.connection.client.getAccountTables(address, bGetDetail, cb);
    }

    public JSONObject getTableAuth(String owner, String tableName) {
        return this.connection.client.getTableAuth(owner, tableName, null);
    }

    public JSONObject getTableAuth(String owner, String tableName, List<String> accounts) {
        return this.connection.client.getTableAuth(owner, tableName, accounts);
    }

    public void getTableAuth(String owner, String tableName, Publisher.Callback<JSONObject> cb) {
        this.connection.client.getTableAuth(owner, tableName, null, cb);
    }

    public void getTableAuth(String owner, String tableName, List<String> accounts, Publisher.Callback<JSONObject> cb) {
        this.connection.client.getTableAuth(owner, tableName, accounts, cb);
    }

    public byte[] sign(byte[] message, String secret) {
        return Util.sign(message, secret);
    }

    public boolean verify(byte[] message, byte[] signature, String publicKey) {
        return Util.verify(message, signature, publicKey);
    }

    public JSONObject getBySqlAdmin(String sql) {
        return this.connection.client.getBySqlAdmin(sql);
    }

    public void getBySqlAdmin(String sql, Publisher.Callback<JSONObject> cb) {
        this.connection.client.getBySqlAdmin(sql, cb);
    }

    public JSONObject getBySqlUser(String sql) {
        return this.connection.client.getBySqlUser(this.connection.secret, this.connection.address, sql);
    }

    public void getBySqlUser(String sql, Publisher.Callback<JSONObject> cb) {
        this.connection.client.getBySqlUser(this.connection.secret, this.connection.address, sql, cb);
    }

    public JSONObject getTableNameInDB(String owner, String tableName) {
        return this.connection.client.getNameInDB(owner, tableName);
    }

    public void getTableNameInDB(String owner, String tableName, Publisher.Callback<JSONObject> cb) {
        this.connection.client.getNameInDB(owner, tableName, cb);
    }

    public JSONObject getLedgerTxs(Integer ledgerSeq, boolean bIncludeSuccess, boolean bIncludefailure) {
        return this.connection.client.getLedgerTxs(ledgerSeq, bIncludeSuccess, bIncludefailure);
    }

    public void getLedgerTxs(Integer ledgerSeq, boolean bIncludeSuccess, boolean bIncludefailure, Publisher.Callback<JSONObject> cb) {
        this.connection.client.getLedgerTxs(ledgerSeq, bIncludeSuccess, bIncludefailure, cb);
    }

    public JSONObject getSchemaList(JSONObject params) {
        return this.connection.client.getSchemaList(params);
    }

    public JSONObject getSchemaInfo(String schemaID) {
        return this.connection.client.getSchemaInfo(schemaID);
    }
}

