/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.chainsql.core;

import com.peersafe.base.core.coretypes.AccountID;
import com.peersafe.base.core.serialized.enums.TransactionType;
import com.peersafe.base.core.types.known.tx.Transaction;
import com.peersafe.chainsql.core.Submit;
import com.peersafe.chainsql.util.GenericPair;
import com.peersafe.chainsql.util.Util;
import com.peersafe.chainsql.util.Validate;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class Table
extends Submit {
    private String name;
    private List<String> query = new ArrayList<String>();
    private String exec;
    private String autoFillField;
    private String txsHashFillField;
    private String nameInDB;
    private boolean confidential = true;

    public Table(String name) {
        this.name = name;
    }

    public Table insert(List<String> orgs) {
        for (String s : orgs) {
            if ("".equals(s) || s == null) continue;
            String json = Util.StrToJsonStr(s);
            this.query.add(json);
        }
        this.exec = "r_insert";
        return this.dealWithTransaction();
    }

    public Table insert(JSONArray jsonArray) {
        for (Object json : jsonArray) {
            if ("".equals(json) || json == null) continue;
            String jsonStr = json.toString();
            this.query.add(jsonStr);
        }
        this.exec = "r_insert";
        return this.dealWithTransaction();
    }

    public Table insert(List<String> orgs, String autoFillField) {
        for (String s : orgs) {
            if ("".equals(s) || s == null) continue;
            String json = Util.StrToJsonStr(s);
            this.query.add(json);
        }
        this.autoFillField = autoFillField;
        this.exec = "r_insert";
        return this.dealWithTransaction();
    }

    public Table insert(List<String> orgs, String autoFillField, String txsHashFillField) {
        for (String s : orgs) {
            if ("".equals(s) || s == null) continue;
            String json = Util.StrToJsonStr(s);
            this.query.add(json);
        }
        if (!autoFillField.isEmpty()) {
            this.autoFillField = autoFillField;
        }
        if (!txsHashFillField.isEmpty()) {
            this.txsHashFillField = txsHashFillField;
        }
        this.exec = "r_insert";
        return this.dealWithTransaction();
    }

    public Table update(String orgs) {
        String json = Util.StrToJsonStr(orgs);
        this.query.add(0, json);
        this.exec = "r_update";
        return this.dealWithTransaction();
    }

    public Table update(String orgs, String autoFillField) {
        String json = Util.StrToJsonStr(orgs);
        this.query.add(0, json);
        this.autoFillField = autoFillField;
        this.exec = "r_update";
        return this.dealWithTransaction();
    }

    public Table update(String orgs, String autoFillField, String txsHashFillField) {
        String json = Util.StrToJsonStr(orgs);
        this.query.add(0, json);
        if (!autoFillField.isEmpty()) {
            this.autoFillField = autoFillField;
        }
        if (!txsHashFillField.isEmpty()) {
            this.txsHashFillField = txsHashFillField;
        }
        this.exec = "r_update";
        return this.dealWithTransaction();
    }

    public Table delete() {
        this.exec = "r_delete";
        return this.dealWithTransaction();
    }

    private Table dealWithTransaction() {
        if (this.transaction) {
            try {
                JSONObject json = this.txJson();
                this.cache.add(json);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this;
    }

    public Table get(List<String> args) {
        if (args != null) {
            for (String s : args) {
                if ("".equals(s) || s == null) continue;
                String json = Util.StrToJsonStr(s);
                this.query.add(json);
            }
        }
        this.exec = "r_get";
        return this;
    }

    public Table get(String arg) {
        if (!"".equals(arg) && arg != null) {
            String json = Util.StrToJsonStr(arg);
            this.query.add(json);
        }
        this.exec = "r_get";
        return this;
    }

    public Table get() {
        this.exec = "r_get";
        return this;
    }

    public Table withFields(String orgs) {
        if (!"".equals(orgs) && orgs != null) {
            String ss = orgs.replace("'", "\"");
            this.query.add(0, ss);
        }
        return this;
    }

    public Table sqlAssert(List<String> orgs) {
        for (String s : orgs) {
            if ("".equals(s) || s == null) continue;
            String json = Util.StrToJsonStr(s);
            this.query.add(json);
        }
        this.exec = "t_assert";
        if (!this.transaction) {
            System.out.println("Exception: you must begin the transaction first");
        }
        if (this.name == null) {
            System.out.println("Exception: you must appoint the table name");
        }
        return this.dealWithTransaction();
    }

    public Table limit(String orgs) {
        JSONObject json = new JSONObject();
        json.put("$limit", (Object)Util.StrToJson(orgs));
        this.query.add(json.toString());
        return this;
    }

    public Table order(List<String> orgs) {
        JSONArray orderarr = new JSONArray();
        for (String s : orgs) {
            if ("".equals(s) || s == null) continue;
            JSONObject json = Util.StrToJson(s);
            orderarr.put((Object)json);
        }
        JSONObject json = new JSONObject();
        json.put("$order", (Object)orderarr);
        this.query.add(json.toString());
        return this;
    }

    private JSONObject txJson() throws Exception {
        JSONObject json = new JSONObject();
        json.put("Tables", (Object)this.getTableArray(this.name));
        json.put("Owner", (Object)this.connection.scope);
        json.put("Raw", (Object)this.tryEncryptRaw(this.query.toString()));
        json.put("OpType", (Object)Validate.toOpType(this.exec));
        json.put("StrictMode", this.strictMode);
        return json;
    }

    private String tryEncryptRaw(String strRaw) throws Exception {
        GenericPair<String, String> pair;
        if (!this.confidential) {
            strRaw = Util.toHexString(strRaw);
            return strRaw;
        }
        String token = "";
        boolean bFound = false;
        if (this.transaction && this.mapToken.containsKey(pair = new GenericPair<String, String>(this.connection.address, this.name))) {
            token = (String)this.mapToken.get(pair);
            bFound = true;
        }
        if (token.equals("") && !bFound) {
            JSONObject res = this.connection.client.getUserToken(this.connection.scope, this.connection.address, this.name);
            if (res.has("error")) {
                if (!this.transaction) {
                    throw new Exception(res.getString("error_message"));
                }
            } else if (res.has("token")) {
                token = res.getString("token");
            }
        }
        if (this.transaction) {
            this.needVerify = 0;
        }
        return Util.encryptRaw(this.connection, token, strRaw);
    }

    private JSONObject prepareSQLStatement() {
        JSONObject txjson;
        try {
            txjson = this.txJson();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Util.errorObject(e.getMessage());
        }
        txjson.put("Account", (Object)this.connection.address);
        if (this.connection.userCert != null) {
            String sCert = Util.toHexString(this.connection.userCert);
            txjson.put("Certificate", (Object)sCert);
        }
        if (this.autoFillField != null) {
            txjson.put("AutoFillField", (Object)Util.toHexString(this.autoFillField));
        }
        if (this.txsHashFillField != null) {
            txjson.put("TxsHashFillField", (Object)Util.toHexString(this.txsHashFillField));
        }
        if (this.crossChainArgs != null) {
            txjson.put("TxnLgrSeq", this.crossChainArgs.txnLedgerSeq);
            txjson.put("OriginalAddress", (Object)this.crossChainArgs.originalAddress);
            txjson.put("CurTxHash", (Object)this.crossChainArgs.curTxHash);
            txjson.put("FutureTxHash", (Object)this.crossChainArgs.futureHash);
            this.crossChainArgs = null;
        }
        JSONObject tx_json = txjson;
        if (this.nameInDB != null) {
            tx_json.put("NameInDB", (Object)this.nameInDB);
        } else {
            JSONObject result = this.connection.client.tablePrepare(txjson);
            if (result.has("error")) {
                return result;
            }
            tx_json = result.getJSONObject("tx_json");
        }
        try {
            Transaction payment = this.toTransaction(tx_json, TransactionType.SQLStatement);
            this.signed = payment.sign(this.connection.secret);
            return Util.successObject();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Util.errorObject(e.getMessage());
        }
    }

    @Override
    protected JSONObject prepareSigned() {
        if (this.exec.equals("r_get")) {
            return this.select();
        }
        try {
            return this.prepareSQLStatement();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new JSONObject(e.getLocalizedMessage());
        }
    }

    private JSONObject select() {
        if (this.query.size() == 0 || !this.query.get(0).substring(0, 1).contains("[")) {
            this.query.add(0, "[]");
        }
        AccountID account = AccountID.fromAddress(this.connection.address);
        AccountID owner = AccountID.fromAddress(this.connection.scope);
        return this.connection.client.select(this.connection.secret, account, owner, this.name, this.query.toString(), this.cb);
    }

    public Table tableSet(JSONObject tableProperties) {
        if (tableProperties.has("nameInDB")) {
            this.nameInDB = tableProperties.getString("nameInDB");
        }
        if (tableProperties.has("confidential")) {
            this.confidential = tableProperties.getBoolean("confidential");
        }
        return this;
    }

    @Override
    public JSONArray getTableArray(String tableName) {
        String tableStr = this.nameInDB != null ? "{\"Table\":{\"TableName\":\"" + Util.toHexString(tableName) + "\",\"NameInDB\":\"" + this.nameInDB + "\"}}" : "{\"Table\":{\"TableName\":\"" + Util.toHexString(tableName) + "\"}}";
        return Util.strToJSONArray(tableStr);
    }
}

