/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.chainsql.crypto;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.peersafe.base.config.Config;
import com.peersafe.base.crypto.ecdsa.IKeyPair;
import com.peersafe.base.crypto.ecdsa.Seed;
import com.peersafe.base.utils.HashUtils;
import com.peersafe.base.utils.Sha512;
import com.peersafe.chainsql.crypto.Aes256;
import com.peersafe.chainsql.crypto.EncryptCommon;
import com.peersafe.chainsql.crypto.EncryptMsg;
import com.peersafe.chainsql.util.Util;
import com.peersafe.chainsql.util.ZLibUtils;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.KeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.crypto.KeyAgreement;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;

public class Ecies {
    public static final int AESKeyLength = 32;
    public static final int AESBlockLength = 16;
    public static final int HMACKeyLength = 32;
    public static final int IVLength = 16;
    public static final int MACBYTELENGTH = 32;
    static final String ALGORITHM = "secp256k1";

    public static byte[] encryptText(String plainText, List<String> listPublicKey) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        if (listPublicKey.size() == 0) {
            return null;
        }
        byte[] password = Util.getRandomBytes(32);
        byte[] aesEnc = Aes256.encrypt(plainText.getBytes(), password);
        try {
            ArrayList<byte[]> listPubHash = new ArrayList<byte[]>();
            ArrayList<byte[]> listPassCipher = new ArrayList<byte[]>();
            byte[] dataPubA = new byte[]{0};
            if (Config.isUseGM()) {
                for (String sPub : listPublicKey) {
                    Object pubBytes = Config.getB58IdentiferCodecs().decode(sPub, 35);
                    byte[] pubHash = HashUtils.quarterSha512((byte[])pubBytes);
                    byte[] passCipher = EncryptCommon.asymEncrypt(password, (byte[])pubBytes);
                    listPubHash.add(pubHash);
                    listPassCipher.add(passCipher);
                }
            } else {
                IKeyPair pair = Seed.randomKeyPair();
                byte[] dataPrvA = pair.priv().toByteArray();
                dataPubA = pair.pub().toByteArray();
                for (String sPub : listPublicKey) {
                    byte[] pubBytes = Config.getB58IdentiferCodecs().decode(sPub, 35);
                    byte[] pubHash = HashUtils.quarterSha512(pubBytes);
                    byte[] passCipher = Ecies.simpleEncrypt(password, pubBytes, dataPrvA);
                    listPubHash.add(pubHash);
                    listPassCipher.add(passCipher);
                }
            }
            EncryptMsg.MultiEncrypt.Builder builder = EncryptMsg.MultiEncrypt.newBuilder();
            builder.setPublicOther(ByteString.copyFrom((byte[])dataPubA));
            for (int i = 0; i < listPubHash.size(); ++i) {
                EncryptMsg.MultiEncrypt.HashToken.Builder bd = EncryptMsg.MultiEncrypt.HashToken.newBuilder();
                bd.setPublicHash(ByteString.copyFrom((byte[])((byte[])listPubHash.get(i))));
                bd.setToken(ByteString.copyFrom((byte[])((byte[])listPassCipher.get(i))));
                builder.addHashTokenPair(bd);
            }
            builder.setCipher(ByteString.copyFrom((byte[])aesEnc));
            byte[] finalByte = builder.build().toByteArray();
            return ZLibUtils.compress(finalByte);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String decryptText(byte[] cipher, String secret) {
        byte[] cipherBytes = ZLibUtils.decompress(cipher);
        try {
            EncryptMsg.MultiEncrypt msg = EncryptMsg.MultiEncrypt.parseFrom(cipherBytes);
            byte[] password = null;
            if (Config.isUseGM()) {
                Seed seed = Seed.randomSeed();
                seed.setGM();
                IKeyPair keyPair = seed.keyPair();
                byte[] pubBytes = keyPair.canonicalPubBytes();
                byte[] pubHash = HashUtils.quarterSha512(pubBytes);
                String sPubHash = Arrays.toString(pubHash);
                List<EncryptMsg.MultiEncrypt.HashToken> listHashToken = msg.getHashTokenPairList();
                for (EncryptMsg.MultiEncrypt.HashToken hashPair : listHashToken) {
                    if (!sPubHash.equals(Arrays.toString(hashPair.getPublicHash().toByteArray()))) continue;
                    password = EncryptCommon.asymDecrypt(hashPair.getToken().toByteArray(), null);
                    break;
                }
                if (password != null) {
                    byte[] plain = Aes256.decrypt(msg.getCipher().toByteArray(), password);
                    return new String(plain);
                }
            } else {
                IKeyPair pair = Seed.fromBase58(secret).keyPair();
                byte[] dataPrvA = pair.priv().toByteArray();
                byte[] dataPubA = pair.pub().toByteArray();
                byte[] pubHashSelf = HashUtils.quarterSha512(dataPubA);
                String sPubHash = Arrays.toString(pubHashSelf);
                byte[] pubOther = msg.getPublicOther().toByteArray();
                List<EncryptMsg.MultiEncrypt.HashToken> listHashToken = msg.getHashTokenPairList();
                for (EncryptMsg.MultiEncrypt.HashToken hashPair : listHashToken) {
                    if (!sPubHash.equals(Arrays.toString(hashPair.getPublicHash().toByteArray()))) continue;
                    password = Ecies.simpleDecrypt(hashPair.getToken().toByteArray(), dataPrvA, pubOther);
                    break;
                }
                if (password != null) {
                    byte[] plain = Aes256.decrypt(msg.getCipher().toByteArray(), password);
                    return new String(plain);
                }
            }
        }
        catch (InvalidProtocolBufferException e) {
            e.printStackTrace();
        }
        return "";
    }

    private static byte[] simpleEncrypt(byte[] plainBytes, byte[] publicKey, byte[] dataPrvA) {
        try {
            byte[] secret = Ecies.doECDH(dataPrvA, publicKey);
            Sha512 hash = new Sha512(secret);
            byte[] kdOutput = hash.finish();
            byte[] aesKey = new byte[32];
            System.arraycopy(kdOutput, 0, aesKey, 0, 32);
            byte[] iv = new byte[16];
            Random r = new Random();
            r.nextBytes(iv);
            ParametersWithIV keyWithIv = new ParametersWithIV((CipherParameters)new KeyParameter(aesKey), iv);
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new AESEngine()));
            cipher.init(true, (CipherParameters)keyWithIv);
            byte[] encryptedBytes = new byte[cipher.getOutputSize(plainBytes.length)];
            int length1 = cipher.processBytes(plainBytes, 0, plainBytes.length, encryptedBytes, 0);
            cipher.doFinal(encryptedBytes, length1);
            byte[] finalBytes = new byte[iv.length + encryptedBytes.length];
            System.arraycopy(iv, 0, finalBytes, 0, iv.length);
            System.arraycopy(encryptedBytes, 0, finalBytes, iv.length, encryptedBytes.length);
            return finalBytes;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] simpleDecrypt(byte[] cipherText, byte[] priv, byte[] dataPubA) {
        try {
            byte[] secret = Ecies.doECDH(priv, dataPubA);
            Sha512 hash = new Sha512(secret);
            byte[] kdOutput = hash.finish();
            byte[] aesKey = new byte[32];
            System.arraycopy(kdOutput, 0, aesKey, 0, 32);
            byte[] iv = new byte[16];
            byte[] cipherBytes = new byte[cipherText.length - 16];
            System.arraycopy(cipherText, 0, iv, 0, 16);
            System.arraycopy(cipherText, 16, cipherBytes, 0, cipherBytes.length);
            ParametersWithIV keyWithIv = new ParametersWithIV((CipherParameters)new KeyParameter(aesKey), iv);
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new AESEngine()));
            cipher.init(false, (CipherParameters)keyWithIv);
            byte[] decryptedBytes = new byte[cipher.getOutputSize(cipherBytes.length)];
            int length1 = cipher.processBytes(cipherBytes, 0, cipherBytes.length, decryptedBytes, 0);
            int length2 = cipher.doFinal(decryptedBytes, length1);
            byte[] finalBytes = new byte[length1 + length2];
            System.arraycopy(decryptedBytes, 0, finalBytes, 0, finalBytes.length);
            return finalBytes;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] eciesEncrypt(byte[] plainBytes, byte[] publicKey) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        IKeyPair pair = Seed.randomKeyPair();
        byte[] dataPrvA = pair.priv().toByteArray();
        byte[] dataPubA = pair.pub().toByteArray();
        String finalHex = "";
        try {
            byte[] secret = Ecies.doECDH(dataPrvA, publicKey);
            Sha512 hash = new Sha512(secret);
            byte[] kdOutput = hash.finish();
            byte[] aesKey = new byte[32];
            System.arraycopy(kdOutput, 0, aesKey, 0, 32);
            byte[] hmacKey = new byte[32];
            System.arraycopy(kdOutput, 32, hmacKey, 0, 32);
            byte[] macBytes = Ecies.hMac(hmacKey, plainBytes);
            byte[] plainBuf = new byte[macBytes.length + plainBytes.length];
            System.arraycopy(macBytes, 0, plainBuf, 0, macBytes.length);
            System.arraycopy(plainBytes, 0, plainBuf, macBytes.length, plainBytes.length);
            byte[] iv = new byte[16];
            Random r = new Random();
            r.nextBytes(iv);
            ParametersWithIV keyWithIv = new ParametersWithIV((CipherParameters)new KeyParameter(aesKey), iv);
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new AESEngine()));
            cipher.init(true, (CipherParameters)keyWithIv);
            byte[] encryptedBytes = new byte[cipher.getOutputSize(plainBuf.length)];
            int length1 = cipher.processBytes(plainBuf, 0, plainBuf.length, encryptedBytes, 0);
            cipher.doFinal(encryptedBytes, length1);
            finalHex = Util.bytesToHex(dataPubA) + Util.bytesToHex(iv) + Util.bytesToHex(encryptedBytes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Util.hexToBytes(finalHex);
    }

    public static byte[] eciesDecrypt(String cipherHex, String privateKey) throws Exception {
        return Ecies.eciesDecrypt(Util.hexToBytes(cipherHex), Config.getB58IdentiferCodecs().decodeFamilySeed(privateKey));
    }

    public static byte[] eciesDecrypt(byte[] cipherText, byte[] privateKey) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        byte[] ciphertext = cipherText;
        int level = 256;
        int Rb_len = 33;
        int D_len = level >> 3;
        int ct_len = ciphertext.length;
        if (ct_len < Rb_len + 16 + D_len + 16) {
            throw new Exception("Illegal cipherText length: " + ct_len + " must be >= " + (Rb_len + 16 + D_len + 16));
        }
        byte[] publicOther = new byte[Rb_len];
        byte[] iv = new byte[16];
        byte[] cipherBytes = new byte[ciphertext.length - Rb_len - 16];
        System.arraycopy(ciphertext, 0, publicOther, 0, Rb_len);
        System.arraycopy(ciphertext, Rb_len, iv, 0, 16);
        System.arraycopy(ciphertext, Rb_len + 16, cipherBytes, 0, ciphertext.length - Rb_len - 16);
        byte[] seedSelf = privateKey;
        IKeyPair pair = Seed.getKeyPair(seedSelf);
        try {
            byte[] secret = Ecies.doECDH(pair.priv().toByteArray(), publicOther);
            Sha512 hash = new Sha512(secret);
            byte[] kdOutput = hash.finish();
            byte[] aesKey = new byte[32];
            System.arraycopy(kdOutput, 0, aesKey, 0, 32);
            byte[] hmacKey = new byte[32];
            System.arraycopy(kdOutput, 32, hmacKey, 0, 32);
            ParametersWithIV keyWithIv = new ParametersWithIV((CipherParameters)new KeyParameter(aesKey), iv);
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new AESEngine()));
            cipher.init(false, (CipherParameters)keyWithIv);
            byte[] decryptedBytes = new byte[cipher.getOutputSize(cipherBytes.length)];
            int length1 = cipher.processBytes(cipherBytes, 0, cipherBytes.length, decryptedBytes, 0);
            int length2 = cipher.doFinal(decryptedBytes, length1);
            byte[] finalBytes = new byte[length1 + length2];
            System.arraycopy(decryptedBytes, 0, finalBytes, 0, finalBytes.length);
            byte[] macBytes = new byte[32];
            byte[] plainText = new byte[finalBytes.length - 32];
            System.arraycopy(finalBytes, 0, macBytes, 0, 32);
            System.arraycopy(finalBytes, macBytes.length, plainText, 0, plainText.length);
            byte[] recoveredD = Ecies.hMac(hmacKey, plainText);
            if (!Arrays.toString(recoveredD).equals(Arrays.toString(macBytes))) {
                return null;
            }
            return plainText;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static byte[] hMac(byte[] hmacKey, byte[] plainText) {
        HMac hmac = new HMac((Digest)new SHA256Digest());
        hmac.init((CipherParameters)new KeyParameter(hmacKey));
        hmac.update(plainText, 0, plainText.length);
        byte[] macBytes = new byte[32];
        hmac.doFinal(macBytes, 0);
        return macBytes;
    }

    private static PublicKey loadPublicKey(byte[] data) throws Exception {
        ECNamedCurveParameterSpec params = ECNamedCurveTable.getParameterSpec((String)ALGORITHM);
        ECPublicKeySpec pubKey = new ECPublicKeySpec(params.getCurve().decodePoint(data), (ECParameterSpec)params);
        KeyFactory kf = KeyFactory.getInstance("ECDH", "BC");
        return kf.generatePublic((KeySpec)pubKey);
    }

    private static PrivateKey loadPrivateKey(byte[] data) throws Exception {
        ECNamedCurveParameterSpec params = ECNamedCurveTable.getParameterSpec((String)ALGORITHM);
        ECPrivateKeySpec prvkey = new ECPrivateKeySpec(new BigInteger(data), (ECParameterSpec)params);
        KeyFactory kf = KeyFactory.getInstance("ECDH", "BC");
        return kf.generatePrivate((KeySpec)prvkey);
    }

    private static byte[] doECDH(byte[] dataPrv, byte[] dataPub) throws Exception {
        KeyAgreement ka = KeyAgreement.getInstance("ECDH", "BC");
        ka.init(Ecies.loadPrivateKey(dataPrv));
        ka.doPhase(Ecies.loadPublicKey(dataPub), true);
        byte[] secret = ka.generateSecret();
        return secret;
    }
}

