/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.chainsql.crypto;

import com.peersafe.base.config.Config;
import com.peersafe.base.crypto.sm.SM2Util;
import com.peersafe.base.crypto.sm.SM4Util;
import com.peersafe.chainsql.crypto.Aes256;
import com.peersafe.chainsql.crypto.Ecies;
import com.peersafe.chainsql.util.Util;

public class EncryptCommon {
    public static byte[] asymEncrypt(byte[] plainBytes, byte[] publicKey) {
        if (Config.isUseGM()) {
            return null;
        }
        if (publicKey.length == 65 && publicKey[0] == 71) {
            try {
                byte[] ret = SM2Util.encrypt(publicKey, plainBytes);
                return ret;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
        return Ecies.eciesEncrypt(plainBytes, publicKey);
    }

    public static byte[] asymDecrypt(byte[] cipher, byte[] privateKey, boolean bSM) {
        try {
            if (bSM) {
                return SM2Util.decrypt(privateKey, cipher);
            }
            return Ecies.eciesDecrypt(cipher, privateKey);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static byte[] asymDecrypt(byte[] cipher, byte[] privateKey) {
        if (Config.isUseGM()) {
            return null;
        }
        if (privateKey.length == 50) {
            try {
                return SM2Util.decrypt(privateKey, cipher);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
        try {
            return Ecies.eciesDecrypt(cipher, privateKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] sm4Encrypt(byte[] plainBytes, byte[] password) {
        try {
            return SM4Util.encrypt_ECB_Padding(password, plainBytes);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static byte[] sm4Decrypt(byte[] cipherText, byte[] password) {
        try {
            return SM4Util.decrypt_ECB_Padding(password, cipherText);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static byte[] symEncrypt(byte[] plainBytes, byte[] password, boolean bSM) {
        if (Config.isUseGM()) {
            return null;
        }
        if (bSM) {
            return EncryptCommon.sm4Encrypt(plainBytes, password);
        }
        return Aes256.encrypt(plainBytes, password);
    }

    public static byte[] symEncrypt(byte[] plainBytes, byte[] password) {
        if (Config.isUseGM()) {
            return null;
        }
        return Aes256.encrypt(plainBytes, password);
    }

    public static byte[] symDecrypt(byte[] cipherText, byte[] password) {
        if (Config.isUseGM()) {
            return null;
        }
        return Aes256.decrypt(cipherText, password);
    }

    public static String symEncrypt(String plainBytes, String password) {
        if (Config.isUseGM()) {
            return null;
        }
        return Util.bytesToHex(Aes256.encrypt(plainBytes.getBytes(), password.getBytes()));
    }

    public static String symDecrypt(String cipherText, String password) {
        if (Config.isUseGM()) {
            return null;
        }
        return new String(Aes256.decrypt(Util.hexToBytes(cipherText), password.getBytes()));
    }
}

