/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.chainsql.pool;

import com.peersafe.base.client.Client;
import com.peersafe.chainsql.core.Chainsql;
import com.peersafe.chainsql.pool.ChainsqlUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class ChainsqlPool {
    private int mMaxCount = 10;
    private String mWs = "";
    private List<ChainsqlUnit> mListChainsql = new ArrayList<ChainsqlUnit>();
    private static ChainsqlPool singleton = new ChainsqlPool();

    public static ChainsqlPool instance() {
        return singleton;
    }

    public void init(String url, int count) {
        this.mWs = url;
        this.mMaxCount = count;
        for (int i = 0; i < this.mMaxCount; ++i) {
            ChainsqlUnit unit = this.createNewChainsqlUnit();
            this.mListChainsql.add(unit);
        }
    }

    public synchronized ChainsqlUnit getChainsqlUnit() {
        ChainsqlUnit unitTmp = this.getFromList();
        if (unitTmp == null) {
            unitTmp = this.createNewChainsqlUnit();
            unitTmp.setExtra();
        }
        unitTmp.lock();
        return unitTmp;
    }

    public ChainsqlUnit createNewChainsqlUnit() {
        Chainsql chainsql = new Chainsql();
        chainsql.connect(this.mWs);
        Client cfr_ignored_0 = chainsql.connection.client;
        Client.logger.setLevel(Level.SEVERE);
        ChainsqlUnit unit = new ChainsqlUnit(chainsql, false);
        return unit;
    }

    public synchronized ChainsqlUnit getFromList() {
        for (int i = 0; i < this.mListChainsql.size(); ++i) {
            ChainsqlUnit unit = this.mListChainsql.get(i);
            if (!unit.available()) continue;
            return unit;
        }
        return null;
    }

    public void shutdown() {
        for (int i = 0; i < this.mListChainsql.size(); ++i) {
            this.mListChainsql.get(i).unlock();
        }
    }
}

