/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

class HtmlTag {
    private static final int MAX_TEXT_LEN = 60;
    private final String id;
    private final int lineNo;
    private final int position;
    private final String text;
    private final boolean closedTag;
    private final boolean incomplete;

    HtmlTag(String id, int lineNo, int position, boolean closedTag, boolean incomplete, String text) {
        this.id = !"".equals(id) && id.charAt(0) == '/' ? id.substring(1) : id;
        this.lineNo = lineNo;
        this.position = position;
        this.text = text;
        this.closedTag = closedTag;
        this.incomplete = incomplete;
    }

    public String getId() {
        return this.id;
    }

    public boolean isCloseTag() {
        if (this.position == this.text.length() - 1) {
            return false;
        }
        return this.text.charAt(this.position + 1) == '/';
    }

    public boolean isClosedTag() {
        return this.closedTag;
    }

    public boolean isIncompleteTag() {
        return this.incomplete;
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public int getPosition() {
        return this.position;
    }

    public String toString() {
        int startOfText = this.position;
        int endOfText = Math.min(startOfText + 60, this.text.length());
        return this.text.substring(startOfText, endOfText);
    }
}

