/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.sizes;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.api.ScopeUtils;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.EnumMap;
import java.util.Map;

public final class MethodCountCheck
extends Check {
    public static final String MSG_PRIVATE_METHODS = "too.many.privateMethods";
    public static final String MSG_PACKAGE_METHODS = "too.many.packageMethods";
    public static final String MSG_PROTECTED_METHODS = "too.many.protectedMethods";
    public static final String MSG_PUBLIC_METHODS = "too.many.publicMethods";
    public static final String MSG_MANY_METHODS = "too.many.methods";
    private static final int DEFAULT_MAX_METHODS = 100;
    private int maxPrivate = 100;
    private int maxPackage = 100;
    private int maxProtected = 100;
    private int maxPublic = 100;
    private int maxTotal = 100;
    private final Deque<MethodCounter> counters = new ArrayDeque<MethodCounter>();

    @Override
    public int[] getDefaultTokens() {
        return new int[]{14, 155, 154, 15, 9};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{14, 155, 154, 15, 9};
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (14 == ast.getType() || 15 == ast.getType() || 155 == ast.getType() || 154 == ast.getType()) {
            this.counters.push(new MethodCounter(15 == ast.getType()));
        } else if (9 == ast.getType()) {
            this.raiseCounter(ast);
        }
    }

    @Override
    public void leaveToken(DetailAST ast) {
        if (14 == ast.getType() || 15 == ast.getType() || 155 == ast.getType() || 154 == ast.getType()) {
            MethodCounter counter = this.counters.pop();
            this.checkCounters(counter, ast);
        }
    }

    private void raiseCounter(DetailAST method) {
        MethodCounter actualCounter = this.counters.peek();
        DetailAST temp = method.findFirstToken(5);
        Scope scope = ScopeUtils.getScopeFromMods(temp);
        actualCounter.increment(scope);
    }

    private void checkCounters(MethodCounter counter, DetailAST ast) {
        this.checkMax(this.maxPrivate, counter.value(Scope.PRIVATE), MSG_PRIVATE_METHODS, ast);
        this.checkMax(this.maxPackage, counter.value(Scope.PACKAGE), MSG_PACKAGE_METHODS, ast);
        this.checkMax(this.maxProtected, counter.value(Scope.PROTECTED), MSG_PROTECTED_METHODS, ast);
        this.checkMax(this.maxPublic, counter.value(Scope.PUBLIC), MSG_PUBLIC_METHODS, ast);
        this.checkMax(this.maxTotal, counter.getTotal(), MSG_MANY_METHODS, ast);
    }

    private void checkMax(int max, int value, String msg, DetailAST ast) {
        if (max < value) {
            this.log(ast.getLineNo(), msg, value, max);
        }
    }

    public void setMaxPrivate(int value) {
        this.maxPrivate = value;
    }

    public void setMaxPackage(int value) {
        this.maxPackage = value;
    }

    public void setMaxProtected(int value) {
        this.maxProtected = value;
    }

    public void setMaxPublic(int value) {
        this.maxPublic = value;
    }

    public void setMaxTotal(int value) {
        this.maxTotal = value;
    }

    private static class MethodCounter {
        private final Map<Scope, Integer> counts = new EnumMap<Scope, Integer>(Scope.class);
        private final boolean inInterface;
        private int total;

        MethodCounter(boolean inInterface) {
            this.inInterface = inInterface;
        }

        void increment(Scope scope) {
            ++this.total;
            if (this.inInterface) {
                this.counts.put(Scope.PUBLIC, 1 + this.value(Scope.PUBLIC));
            } else {
                this.counts.put(scope, 1 + this.value(scope));
            }
        }

        int value(Scope scope) {
            Integer value = this.counts.get((Object)scope);
            return null == value ? 0 : value;
        }

        int getTotal() {
            return this.total;
        }
    }
}

