/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@StatelessCheck
public class MissingJavadocTypeCheck
extends AbstractCheck {
    public static final String MSG_JAVADOC_MISSING = "javadoc.missing";
    private Scope scope = Scope.PUBLIC;
    private Scope excludeScope;
    private List<String> skipAnnotations = Collections.singletonList("Generated");

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public void setExcludeScope(Scope excludeScope) {
        this.excludeScope = excludeScope;
    }

    public void setSkipAnnotations(String ... userAnnotations) {
        this.skipAnnotations = Arrays.asList(userAnnotations);
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{15, 14, 154, 157, 199};
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        int lineNo;
        FileContents contents;
        TextBlock textBlock;
        if (this.shouldCheck(ast) && (textBlock = (contents = this.getFileContents()).getJavadocBefore(lineNo = ast.getLineNo())) == null) {
            this.log(ast, MSG_JAVADOC_MISSING, new Object[0]);
        }
    }

    private boolean shouldCheck(DetailAST ast) {
        Scope customScope = ScopeUtil.getScope(ast);
        Scope surroundingScope = ScopeUtil.getSurroundingScope(ast);
        return customScope.isIn(this.scope) && (surroundingScope == null || surroundingScope.isIn(this.scope)) && (this.excludeScope == null || !customScope.isIn(this.excludeScope) || surroundingScope != null && !surroundingScope.isIn(this.excludeScope)) && !AnnotationUtil.containsAnnotation(ast, this.skipAnnotations);
    }
}

