/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;

@StatelessCheck
public class NoWhitespaceBeforeCheck
extends AbstractCheck {
    public static final String MSG_KEY = "ws.preceded";
    private boolean allowLineBreaks;

    @Override
    public int[] getDefaultTokens() {
        return new int[]{74, 45, 25, 26, 171, 22};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{74, 45, 25, 26, 59, 172, 173, 171, 22, 180};
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        String line = this.getLine(ast.getLineNo() - 1);
        int before = ast.getColumnNo() - 1;
        int[] codePoints = line.codePoints().toArray();
        if ((before == -1 || NoWhitespaceBeforeCheck.isWhitespace(codePoints, before)) && !NoWhitespaceBeforeCheck.isInEmptyForInitializerOrCondition(ast)) {
            boolean flag = !this.allowLineBreaks;
            for (int i = 0; i <= before - 1; ++i) {
                if (NoWhitespaceBeforeCheck.isWhitespace(codePoints, i)) continue;
                flag = true;
                break;
            }
            if (flag) {
                this.log(ast, MSG_KEY, ast.getText());
            }
        }
    }

    private static boolean isWhitespace(int[] codePoints, int index) {
        char character = Character.toChars(codePoints[index])[0];
        return Character.isWhitespace(character);
    }

    private static boolean isInEmptyForInitializerOrCondition(DetailAST semicolonAst) {
        boolean result = false;
        DetailAST sibling = semicolonAst.getPreviousSibling();
        if (!(sibling == null || sibling.getType() != 35 && sibling.getType() != 36 || sibling.hasChildren())) {
            result = true;
        }
        return result;
    }

    public void setAllowLineBreaks(boolean allowLineBreaks) {
        this.allowLineBreaks = allowLineBreaks;
    }
}

