/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.http.client;

import com.rabbitmq.http.client.ClientCreationContext;
import com.rabbitmq.http.client.HttpClientBuilderConfigurator;
import com.rabbitmq.http.client.RestTemplateConfigurator;
import com.rabbitmq.http.client.Utils;
import java.net.URI;
import java.net.URL;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.util.Assert;
import org.springframework.web.client.RestTemplate;

public class HttpComponentsRestTemplateConfigurator
implements RestTemplateConfigurator {
    private static final HttpClientBuilderConfigurator NO_OP_HTTP_CLIENT_BUILDER_CONFIGURATOR = builder -> builder;
    private final HttpClientBuilderConfigurator configurator;
    private final SSLConnectionSocketFactory sslConnectionSocketFactory;
    private final SSLContext sslContext;

    public HttpComponentsRestTemplateConfigurator() {
        this(null, null, NO_OP_HTTP_CLIENT_BUILDER_CONFIGURATOR);
    }

    public HttpComponentsRestTemplateConfigurator(HttpClientBuilderConfigurator configurator) {
        this(null, null, configurator);
    }

    public HttpComponentsRestTemplateConfigurator(SSLConnectionSocketFactory sslConnectionSocketFactory, SSLContext sslContext) {
        this(sslConnectionSocketFactory, sslContext, NO_OP_HTTP_CLIENT_BUILDER_CONFIGURATOR);
    }

    public HttpComponentsRestTemplateConfigurator(SSLConnectionSocketFactory sslConnectionSocketFactory, SSLContext sslContext, HttpClientBuilderConfigurator configurator) {
        Assert.notNull((Object)configurator, (String)"configurator is required; it must not be null");
        this.sslConnectionSocketFactory = sslConnectionSocketFactory;
        this.sslContext = sslContext;
        this.configurator = configurator;
    }

    @Override
    public RestTemplate configure(ClientCreationContext context) {
        RestTemplate restTemplate = context.getRestTemplate();
        ClientHttpRequestFactory requestFactory = this.getRequestFactory(context.getClientParameters().getUrl(), context.getRootUri(), context.getClientParameters().getUsername(), context.getClientParameters().getPassword(), this.sslConnectionSocketFactory, this.sslContext, this.configurator);
        restTemplate.setRequestFactory(requestFactory);
        return restTemplate;
    }

    private ClientHttpRequestFactory getRequestFactory(URL url, URI rootUri, String username, String password, SSLConnectionSocketFactory sslConnectionSocketFactory, SSLContext sslContext, HttpClientBuilderConfigurator configurator) {
        String theUser = username;
        String thePassword = password;
        String userInfo = url.getUserInfo();
        if (userInfo != null && theUser == null) {
            String[] userParts = userInfo.split(":");
            if (userParts.length > 0) {
                theUser = Utils.decode(userParts[0]);
            }
            if (userParts.length > 1) {
                thePassword = Utils.decode(userParts[1]);
            }
        }
        HttpClientBuilder bldr = HttpClientBuilder.create().setDefaultCredentialsProvider(this.getCredentialsProvider(theUser, thePassword));
        if (sslConnectionSocketFactory != null) {
            bldr.setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory);
        }
        if (sslContext != null) {
            bldr.setSSLContext(sslContext);
        }
        HttpClientBuilder b = configurator.configure(bldr);
        CloseableHttpClient httpClient = b.build();
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicScheme = new BasicScheme();
        authCache.put(new HttpHost(rootUri.getHost(), rootUri.getPort(), rootUri.getScheme()), (AuthScheme)basicScheme);
        final HttpClientContext ctx = HttpClientContext.create();
        ctx.setAuthCache((AuthCache)authCache);
        return new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient){

            protected HttpContext createHttpContext(HttpMethod httpMethod, URI uri) {
                return ctx;
            }
        };
    }

    private CredentialsProvider getCredentialsProvider(String username, String password) {
        BasicCredentialsProvider cp = new BasicCredentialsProvider();
        cp.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)new UsernamePasswordCredentials(username, password));
        return cp;
    }
}

