/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.jprotoc;

import com.google.common.base.CaseFormat;
import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.DescriptorProtos;
import java.util.Collection;
import javax.annotation.Nonnull;

public final class ProtoTypeMap {
    private static final Joiner DOT_JOINER = Joiner.on((char)'.').skipNulls();
    private final ImmutableMap<String, String> types;

    private ProtoTypeMap(@Nonnull ImmutableMap<String, String> types) {
        Preconditions.checkNotNull(types, (Object)"types");
        this.types = types;
    }

    public static ProtoTypeMap of(@Nonnull Collection<DescriptorProtos.FileDescriptorProto> fileDescriptorProtos) {
        Preconditions.checkNotNull(fileDescriptorProtos, (Object)"fileDescriptorProtos");
        Preconditions.checkArgument((!fileDescriptorProtos.isEmpty() ? 1 : 0) != 0, (Object)"fileDescriptorProtos.isEmpty()");
        ImmutableMap.Builder types = ImmutableMap.builder();
        for (DescriptorProtos.FileDescriptorProto fileDescriptor : fileDescriptorProtos) {
            DescriptorProtos.FileOptions fileOptions = fileDescriptor.getOptions();
            String protoPackage = fileDescriptor.hasPackage() ? "." + fileDescriptor.getPackage() : "";
            String javaPackage = Strings.emptyToNull((String)(fileOptions.hasJavaPackage() ? fileOptions.getJavaPackage() : fileDescriptor.getPackage()));
            String enclosingClassName = fileOptions.getJavaMultipleFiles() ? null : ProtoTypeMap.getJavaOuterClassname(fileDescriptor, fileOptions);
            fileDescriptor.getEnumTypeList().forEach(e -> types.put((Object)(protoPackage + "." + e.getName()), (Object)DOT_JOINER.join((Object)javaPackage, (Object)enclosingClassName, new Object[]{e.getName()})));
            fileDescriptor.getMessageTypeList().forEach(m -> ProtoTypeMap.recursivelyAddTypes((ImmutableMap.Builder<String, String>)types, m, protoPackage, enclosingClassName, javaPackage));
        }
        return new ProtoTypeMap((ImmutableMap<String, String>)types.build());
    }

    private static void recursivelyAddTypes(ImmutableMap.Builder<String, String> types, DescriptorProtos.DescriptorProto m, String protoPackage, String enclosingClassName, String javaPackage) {
        String protoTypeName = protoPackage + "." + m.getName();
        types.put((Object)protoTypeName, (Object)DOT_JOINER.join((Object)javaPackage, (Object)enclosingClassName, new Object[]{m.getName()}));
        m.getEnumTypeList().forEach(e -> types.put((Object)(protoPackage + "." + m.getName() + "." + e.getName()), (Object)DOT_JOINER.join((Object)javaPackage, (Object)enclosingClassName, new Object[]{m.getName(), e.getName()})));
        m.getNestedTypeList().forEach(n -> ProtoTypeMap.recursivelyAddTypes(types, n, protoPackage + "." + m.getName(), DOT_JOINER.join((Object)enclosingClassName, (Object)m.getName(), new Object[0]), javaPackage));
    }

    public String toJavaTypeName(@Nonnull String protoTypeName) {
        Preconditions.checkNotNull((Object)protoTypeName, (Object)"protoTypeName");
        return (String)this.types.get((Object)protoTypeName);
    }

    private static String getJavaOuterClassname(DescriptorProtos.FileDescriptorProto fileDescriptor, DescriptorProtos.FileOptions fileOptions) {
        if (fileOptions.hasJavaOuterClassname()) {
            return fileOptions.getJavaOuterClassname();
        }
        String filename = fileDescriptor.getName().substring(0, fileDescriptor.getName().length() - ".proto".length());
        if (filename.contains("/")) {
            filename = filename.substring(filename.lastIndexOf(47) + 1);
        }
        filename = ProtoTypeMap.makeInvalidCharactersUnderscores(filename);
        filename = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, filename);
        filename = ProtoTypeMap.upcaseAfterNumber(filename);
        filename = ProtoTypeMap.appendOuterClassSuffix(filename, fileDescriptor);
        return filename;
    }

    private static String appendOuterClassSuffix(String enclosingClassName, DescriptorProtos.FileDescriptorProto fd) {
        if (fd.getEnumTypeList().stream().anyMatch(enumProto -> enumProto.getName().equals(enclosingClassName)) || fd.getMessageTypeList().stream().anyMatch(messageProto -> messageProto.getName().equals(enclosingClassName)) || fd.getServiceList().stream().anyMatch(serviceProto -> serviceProto.getName().equals(enclosingClassName))) {
            return enclosingClassName + "OuterClass";
        }
        return enclosingClassName;
    }

    private static String makeInvalidCharactersUnderscores(String filename) {
        char[] filechars = filename.toCharArray();
        for (int i = 0; i < filechars.length; ++i) {
            char c = filechars[i];
            if (CharMatcher.inRange((char)'0', (char)'9').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.inRange((char)'a', (char)'z')).matches(c)) continue;
            filechars[i] = 95;
        }
        return new String(filechars);
    }

    private static String upcaseAfterNumber(String filename) {
        char[] filechars = filename.toCharArray();
        for (int i = 1; i < filechars.length; ++i) {
            if (!CharMatcher.inRange((char)'0', (char)'9').matches(filechars[i - 1])) continue;
            filechars[i] = Character.toUpperCase(filechars[i]);
        }
        return new String(filechars);
    }
}

