/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker;

import com.spotify.docker.AbstractDockerMojo;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.DockerException;
import com.spotify.docker.client.DockerRequestException;
import com.spotify.docker.client.shaded.javax.ws.rs.NotFoundException;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="removeImage")
public class RemoveImageMojo
extends AbstractDockerMojo {
    @Parameter(property="imageName", required=true)
    private String imageName;

    @Override
    protected void execute(DockerClient docker) throws MojoExecutionException, DockerException, IOException, InterruptedException {
        this.getLog().info((CharSequence)("Removing -f " + this.imageName));
        try {
            docker.removeImage(this.imageName, true, false);
        }
        catch (DockerRequestException e) {
            if (e.getCause() != null && NotFoundException.class.equals(e.getCause().getClass())) {
                this.getLog().warn((CharSequence)("Image " + this.imageName + " does not exist and cannot be deleted - ignoring"));
            }
            throw e;
        }
    }
}

