/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.futures;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.common.base.Preconditions;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

class ApiFutureToCompletableFutureWrapper<V>
extends CompletableFuture<V>
implements ApiFutureCallback<V> {
    private final ApiFuture<V> future;

    ApiFutureToCompletableFutureWrapper(ApiFuture<V> future, Executor executor) {
        this.future = (ApiFuture)Preconditions.checkNotNull(future, (Object)"future");
        ApiFutures.addCallback(future, (ApiFutureCallback)this, (Executor)executor);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.future.cancel(mayInterruptIfRunning);
        return super.cancel(mayInterruptIfRunning);
    }

    ApiFuture<V> unwrap() {
        return this.future;
    }

    public void onSuccess(V result) {
        this.complete(result);
    }

    public void onFailure(Throwable t) {
        this.completeExceptionally(t);
    }
}

