/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.futures;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

class ListenableToCompletableFutureWrapper<V>
extends CompletableFuture<V>
implements FutureCallback<V> {
    private final ListenableFuture<V> future;

    ListenableToCompletableFutureWrapper(ListenableFuture<V> future) {
        this.future = (ListenableFuture)Preconditions.checkNotNull(future, (Object)"future");
        Futures.addCallback(future, (FutureCallback)this, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.future.cancel(mayInterruptIfRunning);
        return super.cancel(mayInterruptIfRunning);
    }

    public ListenableFuture<V> unwrap() {
        return this.future;
    }

    public void onSuccess(V result) {
        this.complete(result);
    }

    public void onFailure(Throwable t) {
        this.completeExceptionally(t);
    }
}

