/*
 * Decompiled with CFR 0.152.
 */
package leakcanary;

import android.app.Activity;
import android.app.Application;
import android.app.Instrumentation;
import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.RecentlyNonNull;
import androidx.test.platform.app.InstrumentationRegistry;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import leakcanary.AppWatcher;
import leakcanary.InstrumentationLeakDetector;
import leakcanary.internal.ObjectsKt;
import leakcanary.internal.TestResultPublisher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import shark.HeapAnalysis;
import shark.HeapAnalysisFailure;
import shark.HeapAnalysisSuccess;
import shark.SharkLog;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000bH\u0004J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0015\u001a\u00020\u0004H\u0014J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0004H\u0016J\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0004H\u0016J\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0004H\u0016J\u0010\u0010 \u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0004H\u0016J\b\u0010!\u001a\u00020\u000fH\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lleakcanary/FailTestOnLeakRunListener;", "Lorg/junit/runner/notification/RunListener;", "()V", "_currentTestDescription", "Lorg/junit/runner/Description;", "allActivitiesDestroyedLatch", "Ljava/util/concurrent/CountDownLatch;", "currentTestDescription", "getCurrentTestDescription", "()Lorg/junit/runner/Description;", "skipLeakDetectionReason", "", "testResultPublisher", "Lleakcanary/internal/TestResultPublisher;", "detectLeaks", "", "failTest", "trace", "onAnalysisPerformed", "heapAnalysis", "Lshark/HeapAnalysis;", "description", "testAssumptionFailure", "failure", "Lorg/junit/runner/notification/Failure;", "testFailure", "testFinished", "testIgnored", "testRunFinished", "result", "Lorg/junit/runner/Result;", "testRunStarted", "testStarted", "trackActivities", "leakcanary-android-instrumentation_release"})
public class FailTestOnLeakRunListener
extends RunListener {
    private Description _currentTestDescription;
    private String skipLeakDetectionReason;
    private TestResultPublisher testResultPublisher;
    private volatile CountDownLatch allActivitiesDestroyedLatch;

    private final Description getCurrentTestDescription() {
        Description description = this._currentTestDescription;
        if (description == null) {
            Intrinsics.throwNpe();
        }
        return description;
    }

    public void testRunStarted(@NotNull Description description) {
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        this.testResultPublisher = TestResultPublisher.Companion.install();
        this.trackActivities();
    }

    private final void trackActivities() {
        Instrumentation instrumentation = InstrumentationRegistry.getInstrumentation();
        if (instrumentation == null) {
            Intrinsics.throwNpe();
        }
        Instrumentation instrumentation2 = instrumentation;
        Context context = instrumentation2.getTargetContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"instrumentation.targetContext");
        Context context2 = context.getApplicationContext();
        if (context2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.Application");
        }
        Application application = (Application)context2;
        application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(this){
            private int activitiesWaitingForDestroyed;
            private final /* synthetic */ Application.ActivityLifecycleCallbacks $$delegate_0;
            final /* synthetic */ FailTestOnLeakRunListener this$0;

            public final int getActivitiesWaitingForDestroyed() {
                return this.activitiesWaitingForDestroyed;
            }

            public final void setActivitiesWaitingForDestroyed(int n) {
                this.activitiesWaitingForDestroyed = n;
            }

            public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
                Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
                if (this.activitiesWaitingForDestroyed == 0) {
                    FailTestOnLeakRunListener.access$setAllActivitiesDestroyedLatch$p(this.this$0, new CountDownLatch(1));
                }
                int n = this.activitiesWaitingForDestroyed;
                this.activitiesWaitingForDestroyed = n + 1;
            }

            public void onActivityDestroyed(@NotNull Activity activity) {
                Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
                int n = this.activitiesWaitingForDestroyed;
                this.activitiesWaitingForDestroyed = n + -1;
                if (this.activitiesWaitingForDestroyed == 0) {
                    CountDownLatch countDownLatch = FailTestOnLeakRunListener.access$getAllActivitiesDestroyedLatch$p(this.this$0);
                    if (countDownLatch == null) {
                        Intrinsics.throwNpe();
                    }
                    countDownLatch.countDown();
                }
            }
            {
                this.this$0 = this$0;
                boolean $i$f$noOpDelegate = false;
                boolean $i$f$noOpDelegate2 = false;
                Class<Application.ActivityLifecycleCallbacks> javaClass$iv$iv = Application.ActivityLifecycleCallbacks.class;
                Object object = Proxy.newProxyInstance(javaClass$iv$iv.getClassLoader(), new Class[]{javaClass$iv$iv}, ObjectsKt.access$getNO_OP_HANDLER$p());
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.app.Application.ActivityLifecycleCallbacks");
                }
                this.$$delegate_0 = (Application.ActivityLifecycleCallbacks)object;
            }

            public void onActivityPaused(@RecentlyNonNull Activity p0) {
                this.$$delegate_0.onActivityPaused(p0);
            }

            public void onActivityResumed(@RecentlyNonNull Activity p0) {
                this.$$delegate_0.onActivityResumed(p0);
            }

            public void onActivitySaveInstanceState(@RecentlyNonNull Activity p0, @RecentlyNonNull Bundle p1) {
                this.$$delegate_0.onActivitySaveInstanceState(p0, p1);
            }

            public void onActivityStarted(@RecentlyNonNull Activity p0) {
                this.$$delegate_0.onActivityStarted(p0);
            }

            public void onActivityStopped(@RecentlyNonNull Activity p0) {
                this.$$delegate_0.onActivityStopped(p0);
            }
        });
    }

    public void testRunFinished(@NotNull Result result) {
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
    }

    public void testStarted(@NotNull Description description) {
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        this._currentTestDescription = description;
        this.skipLeakDetectionReason = this.skipLeakDetectionReason(description);
        if (this.skipLeakDetectionReason != null) {
            return;
        }
    }

    @Nullable
    protected String skipLeakDetectionReason(@NotNull Description description) {
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        return null;
    }

    public void testFailure(@NotNull Failure failure) {
        Intrinsics.checkParameterIsNotNull((Object)failure, (String)"failure");
        this.skipLeakDetectionReason = "failed";
    }

    public void testIgnored(@NotNull Description description) {
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        this.skipLeakDetectionReason = "was ignored";
    }

    public void testAssumptionFailure(@NotNull Failure failure) {
        Intrinsics.checkParameterIsNotNull((Object)failure, (String)"failure");
        this.skipLeakDetectionReason = "had an assumption failure";
    }

    public void testFinished(@NotNull Description description) {
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        if (this.skipLeakDetectionReason == null) {
            this.detectLeaks();
        } else {
            SharkLog this_$iv = SharkLog.INSTANCE;
            boolean $i$f$d = false;
            SharkLog.Logger logger = this_$iv.getLogger();
            if (logger == null) {
            } else {
                SharkLog.Logger logger$iv;
                SharkLog.Logger logger2 = logger$iv = logger;
                boolean bl = false;
                String string = "Skipping leak detection because the test " + this.skipLeakDetectionReason;
                logger2.d(string);
            }
            this.skipLeakDetectionReason = null;
        }
        AppWatcher.INSTANCE.getObjectWatcher().clearWatchedObjects();
        this._currentTestDescription = null;
        TestResultPublisher testResultPublisher = this.testResultPublisher;
        if (testResultPublisher == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"testResultPublisher");
        }
        testResultPublisher.publishTestFinished();
    }

    private final void detectLeaks() {
        InstrumentationLeakDetector leakDetector;
        InstrumentationLeakDetector.Result result;
        String string;
        SharkLog.Logger logger;
        boolean allActivitiesDestroyed;
        CountDownLatch countDownLatch = this.allActivitiesDestroyedLatch;
        boolean bl = allActivitiesDestroyed = countDownLatch != null ? countDownLatch.await(2L, TimeUnit.SECONDS) : true;
        if (!allActivitiesDestroyed) {
            SharkLog this_$iv = SharkLog.INSTANCE;
            boolean $i$f$d = false;
            SharkLog.Logger logger2 = this_$iv.getLogger();
            if (logger2 == null) {
            } else {
                SharkLog.Logger logger$iv;
                logger = logger$iv = logger2;
                boolean bl2 = false;
                string = "Leak detection proceeding with some activities still not in destroyed state";
                logger.d(string);
            }
        }
        if ((result = (leakDetector = new InstrumentationLeakDetector()).detectLeaks()) instanceof InstrumentationLeakDetector.Result.AnalysisPerformed) {
            this.onAnalysisPerformed(((InstrumentationLeakDetector.Result.AnalysisPerformed)result).getHeapAnalysis());
        } else {
            SharkLog this_$iv = SharkLog.INSTANCE;
            boolean $i$f$d = false;
            SharkLog.Logger logger3 = this_$iv.getLogger();
            if (logger3 == null) {
            } else {
                SharkLog.Logger logger$iv;
                logger = logger$iv = logger3;
                boolean bl3 = false;
                string = "No heap analysis performed";
                logger.d(string);
            }
        }
    }

    protected void onAnalysisPerformed(@NotNull HeapAnalysis heapAnalysis) {
        block5: {
            HeapAnalysis heapAnalysis2;
            block4: {
                Intrinsics.checkParameterIsNotNull((Object)heapAnalysis, (String)"heapAnalysis");
                heapAnalysis2 = heapAnalysis;
                if (!(heapAnalysis2 instanceof HeapAnalysisFailure)) break block4;
                this.failTest(this.getCurrentTestDescription() + " failed because heap analysis failed:\n" + Log.getStackTraceString((Throwable)((Throwable)((HeapAnalysisFailure)heapAnalysis).getException())));
                break block5;
            }
            if (!(heapAnalysis2 instanceof HeapAnalysisSuccess)) break block5;
            List applicationLeaks = ((HeapAnalysisSuccess)heapAnalysis).getApplicationLeaks();
            Collection collection = applicationLeaks;
            boolean bl = false;
            if (!collection.isEmpty()) {
                this.failTest(this.getCurrentTestDescription() + " failed because application memory leaks were detected:\n" + heapAnalysis);
            } else {
                SharkLog this_$iv = SharkLog.INSTANCE;
                boolean $i$f$d = false;
                SharkLog.Logger logger = this_$iv.getLogger();
                if (logger == null) {
                } else {
                    SharkLog.Logger logger$iv;
                    SharkLog.Logger logger2 = logger$iv = logger;
                    boolean bl2 = false;
                    String string = "Heap analysis found 0 application leaks:\n" + heapAnalysis;
                    logger2.d(string);
                }
            }
        }
    }

    protected final void failTest(@NotNull String trace) {
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        SharkLog this_$iv = SharkLog.INSTANCE;
        boolean $i$f$d = false;
        SharkLog.Logger logger = this_$iv.getLogger();
        if (logger == null) {
        } else {
            SharkLog.Logger logger$iv;
            SharkLog.Logger logger2 = logger$iv = logger;
            boolean bl = false;
            String string = trace;
            logger2.d(string);
        }
        TestResultPublisher testResultPublisher = this.testResultPublisher;
        if (testResultPublisher == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"testResultPublisher");
        }
        testResultPublisher.publishTestFailure(this.getCurrentTestDescription(), trace);
    }

    public static final /* synthetic */ CountDownLatch access$getAllActivitiesDestroyedLatch$p(FailTestOnLeakRunListener $this) {
        return $this.allActivitiesDestroyedLatch;
    }

    public static final /* synthetic */ void access$setAllActivitiesDestroyedLatch$p(FailTestOnLeakRunListener $this, CountDownLatch countDownLatch) {
        $this.allActivitiesDestroyedLatch = countDownLatch;
    }
}

