/*
 * Decompiled with CFR 0.152.
 */
package leakcanary;

import android.app.Instrumentation;
import android.content.Context;
import android.os.Debug;
import android.os.SystemClock;
import androidx.test.platform.app.InstrumentationRegistry;
import java.io.File;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import leakcanary.AppWatcher;
import leakcanary.GcTrigger;
import leakcanary.KeyedWeakReference;
import leakcanary.LeakCanary;
import leakcanary.ObjectWatcher;
import org.jetbrains.annotations.NotNull;
import shark.HeapAnalysis;
import shark.HeapAnalysisException;
import shark.HeapAnalysisFailure;
import shark.HeapAnalysisSuccess;
import shark.HeapAnalyzer;
import shark.LeakingObjectFinder;
import shark.OnAnalysisProgressListener;
import shark.SharkLog;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00052\u00020\u0001:\u0002\u0005\u0006B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0007"}, d2={"Lleakcanary/InstrumentationLeakDetector;", "", "()V", "detectLeaks", "Lleakcanary/InstrumentationLeakDetector$Result;", "Companion", "Result", "leakcanary-android-instrumentation_release"})
public final class InstrumentationLeakDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Result detectLeaks() {
        HeapAnalysis heapAnalysis;
        Instrumentation instrumentation;
        long leakDetectionTime = SystemClock.uptimeMillis();
        long watchDurationMillis = AppWatcher.getConfig().getWatchDurationMillis();
        Instrumentation instrumentation2 = instrumentation = InstrumentationRegistry.getInstrumentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)instrumentation2, (String)"instrumentation");
        Context context = instrumentation2.getTargetContext();
        ObjectWatcher refWatcher = AppWatcher.INSTANCE.getObjectWatcher();
        if (!refWatcher.getHasWatchedObjects()) {
            return new Result.NoAnalysis("No watched objects.");
        }
        instrumentation.waitForIdleSync();
        if (!refWatcher.getHasWatchedObjects()) {
            return new Result.NoAnalysis("No watched objects after waiting for idle sync.");
        }
        GcTrigger.Default.INSTANCE.runGc();
        if (!refWatcher.getHasWatchedObjects()) {
            return new Result.NoAnalysis("No watched objects after triggering an explicit GC.");
        }
        SystemClock.sleep((long)2000L);
        if (!refWatcher.getHasWatchedObjects()) {
            return new Result.NoAnalysis("No watched objects after delayed UI post is cleared.");
        }
        SystemClock.sleep((long)2000L);
        long endOfWatchDelay = watchDurationMillis - (SystemClock.uptimeMillis() - leakDetectionTime);
        if (endOfWatchDelay > 0L) {
            SystemClock.sleep((long)endOfWatchDelay);
        }
        GcTrigger.Default.INSTANCE.runGc();
        if (!refWatcher.getHasRetainedObjects()) {
            return new Result.NoAnalysis("No watched objects after a second explicit GC.");
        }
        Context context2 = context;
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context");
        File heapDumpFile = new File(context2.getFilesDir(), "instrumentation_tests_heapdump.hprof");
        LeakCanary.Config config = LeakCanary.getConfig();
        long heapDumpUptimeMillis = SystemClock.uptimeMillis();
        KeyedWeakReference.Companion.setHeapDumpUptimeMillis(heapDumpUptimeMillis);
        long heapDumpDurationMillis = 0L;
        try {
            Debug.dumpHprofData((String)heapDumpFile.getAbsolutePath());
            heapDumpDurationMillis = SystemClock.uptimeMillis() - heapDumpUptimeMillis;
        }
        catch (Exception exception) {
            SharkLog this_$iv = SharkLog.INSTANCE;
            boolean $i$f$d = false;
            SharkLog.Logger logger = this_$iv.getLogger();
            if (logger == null) {
            } else {
                SharkLog.Logger logger$iv = logger;
                Throwable throwable = exception;
                SharkLog.Logger logger2 = logger$iv;
                boolean bl = false;
                String string = "Could not dump heap";
                logger2.d(throwable, string);
            }
            return new Result.AnalysisPerformed((HeapAnalysis)new HeapAnalysisFailure(heapDumpFile, System.currentTimeMillis(), SystemClock.uptimeMillis() - heapDumpUptimeMillis, 0L, new HeapAnalysisException((Throwable)exception)));
        }
        refWatcher.clearObjectsWatchedBefore(heapDumpUptimeMillis);
        OnAnalysisProgressListener listener = OnAnalysisProgressListener.Companion.getNO_OP();
        SystemClock.sleep((long)2000L);
        HeapAnalyzer heapAnalyzer = new HeapAnalyzer(listener);
        HeapAnalysis heapAnalysis2 = HeapAnalyzer.analyze$default((HeapAnalyzer)heapAnalyzer, (File)heapDumpFile, (LeakingObjectFinder)config.getLeakingObjectFinder(), (List)config.getReferenceMatchers(), (boolean)config.getComputeRetainedHeapSize(), (List)config.getObjectInspectors(), null, null, (int)96, null);
        if (heapAnalysis2 instanceof HeapAnalysisSuccess) {
            heapAnalysis = (HeapAnalysis)HeapAnalysisSuccess.copy$default((HeapAnalysisSuccess)((HeapAnalysisSuccess)heapAnalysis2), null, (long)0L, (long)heapDumpDurationMillis, (long)0L, null, null, null, null, (int)251, null);
        } else if (heapAnalysis2 instanceof HeapAnalysisFailure) {
            heapAnalysis = (HeapAnalysis)HeapAnalysisFailure.copy$default((HeapAnalysisFailure)((HeapAnalysisFailure)heapAnalysis2), null, (long)0L, (long)heapDumpDurationMillis, (long)0L, null, (int)27, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        HeapAnalysis fullHeapAnalysis = heapAnalysis;
        return new Result.AnalysisPerformed(fullHeapAnalysis);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lleakcanary/InstrumentationLeakDetector$Result;", "", "()V", "AnalysisPerformed", "NoAnalysis", "Lleakcanary/InstrumentationLeakDetector$Result$NoAnalysis;", "Lleakcanary/InstrumentationLeakDetector$Result$AnalysisPerformed;", "leakcanary-android-instrumentation_release"})
    public static abstract class Result {
        private Result() {
        }

        public /* synthetic */ Result(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lleakcanary/InstrumentationLeakDetector$Result$NoAnalysis;", "Lleakcanary/InstrumentationLeakDetector$Result;", "reason", "", "(Ljava/lang/String;)V", "getReason", "()Ljava/lang/String;", "leakcanary-android-instrumentation_release"})
        public static final class NoAnalysis
        extends Result {
            @NotNull
            private final String reason;

            @NotNull
            public final String getReason() {
                return this.reason;
            }

            public NoAnalysis(@NotNull String reason) {
                Intrinsics.checkParameterIsNotNull((Object)reason, (String)"reason");
                super(null);
                this.reason = reason;
            }
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lleakcanary/InstrumentationLeakDetector$Result$AnalysisPerformed;", "Lleakcanary/InstrumentationLeakDetector$Result;", "heapAnalysis", "Lshark/HeapAnalysis;", "(Lshark/HeapAnalysis;)V", "getHeapAnalysis", "()Lshark/HeapAnalysis;", "leakcanary-android-instrumentation_release"})
        public static final class AnalysisPerformed
        extends Result {
            @NotNull
            private final HeapAnalysis heapAnalysis;

            @NotNull
            public final HeapAnalysis getHeapAnalysis() {
                return this.heapAnalysis;
            }

            public AnalysisPerformed(@NotNull HeapAnalysis heapAnalysis) {
                Intrinsics.checkParameterIsNotNull((Object)heapAnalysis, (String)"heapAnalysis");
                super(null);
                this.heapAnalysis = heapAnalysis;
            }
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lleakcanary/InstrumentationLeakDetector$Companion;", "", "()V", "updateConfig", "", "leakcanary-android-instrumentation_release"})
    public static final class Companion {
        @Deprecated(message="This is a no-op as LeakCanary automatically detects tests", replaceWith=@ReplaceWith(imports={}, expression=""))
        public final void updateConfig() {
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

