/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot.logconfig;

import com.taobao.pandora.boot.logconfig.LogConfigurator;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;

public class LogConfigUtil {
    private static final String LOG_DEFAULT_CONFIGURATION = "logDefaultConfiguration";
    private static final String LOG_CONFIGURATION = "logConfiguration";
    private static final String LOG_SYSTEM = "logSystem";
    private static final String LOG_PREFIX = "log";
    private static final String LOG_PROPERTIES = "META-INF/logconfig.properties";
    private static LogConfigurator[] logConfigurators;
    private static final boolean EXIST_SPRINGBOOT;

    public static void initLoggingSystem(ClassLoader classLoader) {
        LogConfigUtil.loggerAction(classLoader, "init");
    }

    public static void destoryLoggingSystem(ClassLoader classLoader) {
        LogConfigUtil.loggerAction(classLoader, "destory");
    }

    private static void loggerAction(ClassLoader classLoader, String action) {
        try {
            CountDownLatch latch = new CountDownLatch(1);
            Class<?> clazz = classLoader.loadClass("com.taobao.pandora.boot.logconfig.LogConfigRunnable");
            Constructor<?> constructor = clazz.getConstructor(CountDownLatch.class, String.class);
            Object runnable = constructor.newInstance(latch, action);
            Thread thread = new Thread((Runnable)runnable);
            thread.setContextClassLoader(classLoader);
            thread.start();
            latch.await();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void initLoggingSystem() {
        Map<String, String> params = LogConfigUtil.getLogInitParams();
        String[] logSystems = LogConfigUtil.getLogSystems(params);
        boolean logDefaultConfiguration = LogConfigUtil.getLogDefaultConfiguration(params);
        for (LogConfigurator logConfigurator : logConfigurators = LogConfigurator.getConfigurators(logSystems)) {
            URL logConfigurationResource;
            String logSystem = logConfigurator.getLogSystem();
            String logConfiguration = LogConfigUtil.getLogConfiguration(params, logSystem);
            if (!EXIST_SPRINGBOOT) {
                System.out.println(String.format("[Pandora Boot] Try to find %s system config file.", logSystem));
            }
            try {
                logConfigurationResource = Thread.currentThread().getContextClassLoader().getResource(logConfiguration);
            }
            catch (Exception e) {
                logConfigurationResource = null;
            }
            if (logConfigurationResource == null) {
                if (logDefaultConfiguration) {
                    System.out.println(String.format("[Pandora Boot] Could not find %s configuration file \"%s\" in classpath.  Using default configurations.", logSystem, logConfiguration));
                    logConfigurator.configureDefault();
                    continue;
                }
                if (EXIST_SPRINGBOOT) continue;
                System.out.println(String.format("[Pandora Boot] Did not find %s system config file, skip.", logSystem));
                continue;
            }
            Map<String, String> props = logConfigurator.getDefaultProperties();
            props.putAll(params);
            logConfigurator.configure(logConfigurationResource, props);
        }
    }

    public static void destoryLoggingSystem() {
        if (logConfigurators != null && logConfigurators.length > 0) {
            System.out.println("[Pandora Boot] Shutting down log system");
            for (LogConfigurator logConfigurator : logConfigurators) {
                logConfigurator.shutdown();
            }
        }
    }

    private static boolean getLogDefaultConfiguration(Map<String, String> params) {
        String logConfiguration = params.remove(LOG_DEFAULT_CONFIGURATION);
        return "true".equalsIgnoreCase(logConfiguration);
    }

    private static String getLogConfiguration(Map<String, String> params, String logSystem) {
        String logConfiguration = params.remove(LOG_CONFIGURATION);
        if (logConfiguration == null) {
            logConfiguration = "META-INF/" + logSystem + ".xml";
        }
        return logConfiguration;
    }

    private static String[] getLogSystems(Map<String, String> params) {
        String logSystem = params.remove(LOG_SYSTEM);
        if (logSystem == null) {
            return new String[0];
        }
        return logSystem.split("(,|\\s)+");
    }

    private static Map<String, String> getLogInitParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(LOG_PROPERTIES);
        if (is == null) {
            return params;
        }
        Properties properties = new Properties();
        try {
            properties.load(is);
        }
        catch (IOException ioe) {
            return params;
        }
        Enumeration<?> i = properties.propertyNames();
        while (i.hasMoreElements()) {
            String value;
            String name = (String)i.nextElement();
            if (name == null || !name.startsWith(LOG_PREFIX) || (value = LogConfigUtil.trimToNull(properties.get(name))) == null) continue;
            params.put(name, value);
        }
        return params;
    }

    protected static String trimToNull(Object str) {
        if (!(str instanceof String)) {
            return null;
        }
        String result = ((String)str).trim();
        if (result == null || result.length() == 0) {
            return null;
        }
        return result;
    }

    static {
        EXIST_SPRINGBOOT = LogConfigUtil.class.getClassLoader().getResource("org/springframework/boot/autoconfigure/SpringBootApplication.class") != null;
    }
}

