/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot.loader.tools;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

abstract class JvmUtils {
    private static final String[] TOOLS_LOCATIONS = new String[]{"lib/tools.jar", "../lib/tools.jar", "../Classes/classes.jar"};

    JvmUtils() {
    }

    public static ClassLoader getToolsClassLoader() {
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        return new URLClassLoader(new URL[]{JvmUtils.getToolsJarUrl()}, systemClassLoader);
    }

    public static URL getToolsJarUrl() {
        String javaHome = JvmUtils.getJavaHome();
        for (String location : TOOLS_LOCATIONS) {
            try {
                URL url = new URL(javaHome + "/" + location);
                if (!new File(url.toURI()).exists()) continue;
                return url;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new IllegalStateException("Unable to locate tools.jar");
    }

    private static String getJavaHome() {
        try {
            return new File(System.getProperty("java.home")).toURI().toURL().toExternalForm();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Cannot locate java.home", e);
        }
    }
}

