/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.loader.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public abstract class UrlUtils {
    public static String appendSegmentToPath(String path, String segment) {
        if (path == null || path.isEmpty()) {
            return "/" + segment;
        }
        if (path.charAt(path.length() - 1) == '/') {
            return path + segment;
        }
        return path + "/" + segment;
    }

    public static URL getResource(URL baseUrl, String name) {
        try {
            return new URL(baseUrl.getProtocol(), baseUrl.getHost(), baseUrl.getPort(), UrlUtils.appendSegmentToPath(baseUrl.getFile(), name), null);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("can not get relative URL from baseUrl:" + baseUrl.toString() + ", name:" + name, e);
        }
    }

    public static String getSuffixFileName(URL url) {
        int indexOf;
        String path = url.getPath();
        if (path.endsWith("!/")) {
            path = path.substring(0, path.length() - "!/".length());
        }
        if ((indexOf = path.lastIndexOf(58)) != -1) {
            path = path.substring(indexOf + 1);
        }
        return new File(path).getName();
    }
}

