/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc;

import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.common.primitives.Shorts;
import com.taosdata.jdbc.AbstractResultSet;
import com.taosdata.jdbc.ColumnMetaData;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.TSDBJNIConnector;
import com.taosdata.jdbc.TSDBResultSetBlockData;
import com.taosdata.jdbc.TSDBResultSetMetaData;
import com.taosdata.jdbc.TSDBResultSetRowData;
import com.taosdata.jdbc.TSDBStatement;
import java.math.BigDecimal;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class TSDBResultSet
extends AbstractResultSet {
    private final TSDBJNIConnector jniConnector;
    private final TSDBStatement statement;
    private final long resultSetPointer;
    private List<ColumnMetaData> columnMetaDataList = new ArrayList<ColumnMetaData>();
    private final TSDBResultSetRowData rowData;
    private final int cacheSize = 5;
    BlockingQueue<TSDBResultSetBlockData> blockingQueueOut = new LinkedBlockingQueue<TSDBResultSetBlockData>(5);
    private TSDBResultSetBlockData blockData;
    private boolean batchFetch;
    private boolean lastWasNull;
    private volatile boolean isClosed;
    ThreadPoolExecutor backFetchExecutor;
    ForkJoinPool dataHandleExecutor = ForkJoinPool.commonPool();

    public void setBatchFetch(boolean batchFetch) {
        this.batchFetch = batchFetch;
    }

    public boolean getBatchFetch() {
        return this.batchFetch;
    }

    public void setColumnMetaDataList(List<ColumnMetaData> columnMetaDataList) {
        this.columnMetaDataList = columnMetaDataList;
    }

    public TSDBResultSetRowData getRowData() {
        return this.rowData;
    }

    public TSDBResultSet(TSDBStatement statement, TSDBJNIConnector connector, long resultSetPointer, int timestampPrecision, boolean batchFetch) throws SQLException {
        this.statement = statement;
        this.jniConnector = connector;
        this.resultSetPointer = resultSetPointer;
        int code = this.jniConnector.getSchemaMetaData(this.resultSetPointer, this.columnMetaDataList);
        if (code == -2) {
            throw TSDBError.createSQLException(9044);
        }
        if (code == -3) {
            throw TSDBError.createSQLException(9045);
        }
        if (code == -4) {
            throw TSDBError.createSQLException(9046);
        }
        this.rowData = new TSDBResultSetRowData(this.columnMetaDataList.size());
        this.timestampPrecision = timestampPrecision;
        this.blockData = new TSDBResultSetBlockData();
        this.batchFetch = batchFetch;
        if (batchFetch) {
            this.backFetchExecutor = (ThreadPoolExecutor)Executors.newFixedThreadPool(1);
            this.backFetchExecutor.submit(() -> {
                try {
                    while (!this.isClosed) {
                        TSDBResultSetBlockData tsdbResultSetBlockData = new TSDBResultSetBlockData(this.columnMetaDataList, this.columnMetaDataList.size(), timestampPrecision);
                        tsdbResultSetBlockData.returnCode = this.jniConnector.fetchBlock(this.resultSetPointer, tsdbResultSetBlockData);
                        while (!this.blockingQueueOut.offer(tsdbResultSetBlockData, 10L, TimeUnit.MILLISECONDS)) {
                            if (!this.isClosed) continue;
                            return;
                        }
                        if (tsdbResultSetBlockData.returnCode == 0) {
                            this.dataHandleExecutor.submit(tsdbResultSetBlockData::doSetByteArray);
                            continue;
                        }
                        tsdbResultSetBlockData.doneWithNoData();
                        break;
                    }
                }
                catch (InterruptedException ignored) {
                    Thread.currentThread().interrupt();
                }
            });
        }
    }

    @Override
    public boolean next() throws SQLException {
        int code;
        if (this.getBatchFetch()) {
            if (this.blockData.forward()) {
                return true;
            }
            try {
                this.blockData = this.blockingQueueOut.take();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.blockData.waitTillOK();
            int code2 = this.blockData.returnCode;
            if (code2 == -2) {
                throw TSDBError.createSQLException(9044);
            }
            if (code2 == -3) {
                throw TSDBError.createSQLException(9045);
            }
            if (code2 == -4) {
                throw TSDBError.createSQLException(9046);
            }
            return code2 != -6;
        }
        if (this.rowData != null) {
            this.rowData.clear();
        }
        if ((code = this.jniConnector.fetchRow(this.resultSetPointer, this.rowData)) == -2) {
            throw TSDBError.createSQLException(9044);
        }
        if (code == -3) {
            throw TSDBError.createSQLException(9045);
        }
        if (code == -4) {
            throw TSDBError.createSQLException(9046);
        }
        return code != -6;
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        if (this.batchFetch) {
            while (this.backFetchExecutor.getActiveCount() != 0) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException ignored) {
                    Thread.currentThread().interrupt();
                }
            }
            if (!this.backFetchExecutor.isShutdown()) {
                this.backFetchExecutor.shutdown();
            }
        }
        if (this.statement == null) {
            return;
        }
        if (this.jniConnector != null) {
            int code = this.jniConnector.freeResultSet(this.resultSetPointer);
            if (code == -2) {
                throw TSDBError.createSQLException(9044);
            }
            if (code == -3) {
                throw TSDBError.createSQLException(9045);
            }
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        if (this.getBatchFetch()) {
            return this.blockData.wasNull;
        }
        return this.lastWasNull;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.columnMetaDataList.size());
        String res = null;
        if (this.getBatchFetch()) {
            return this.blockData.getString(columnIndex - 1);
        }
        this.lastWasNull = this.rowData.wasNull(columnIndex);
        if (!this.lastWasNull) {
            int nativeType = this.columnMetaDataList.get(columnIndex - 1).getColType();
            res = this.rowData.getString(columnIndex, nativeType);
        }
        return res;
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.columnMetaDataList.size());
        boolean res = false;
        if (this.getBatchFetch()) {
            return this.blockData.getBoolean(columnIndex - 1);
        }
        this.lastWasNull = this.rowData.wasNull(columnIndex);
        if (!this.lastWasNull) {
            int nativeType = this.columnMetaDataList.get(columnIndex - 1).getColType();
            res = this.rowData.getBoolean(columnIndex, nativeType);
        }
        return res;
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.columnMetaDataList.size());
        byte res = 0;
        if (this.getBatchFetch()) {
            return (byte)this.blockData.getInt(columnIndex - 1);
        }
        this.lastWasNull = this.rowData.wasNull(columnIndex);
        if (!this.lastWasNull) {
            int nativeType = this.columnMetaDataList.get(columnIndex - 1).getColType();
            res = (byte)this.rowData.getInt(columnIndex, nativeType);
        }
        return res;
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.columnMetaDataList.size());
        short res = 0;
        if (this.getBatchFetch()) {
            return (short)this.blockData.getInt(columnIndex - 1);
        }
        this.lastWasNull = this.rowData.wasNull(columnIndex);
        if (!this.lastWasNull) {
            int nativeType = this.columnMetaDataList.get(columnIndex - 1).getColType();
            res = (short)this.rowData.getInt(columnIndex, nativeType);
        }
        return res;
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.columnMetaDataList.size());
        int res = 0;
        if (this.getBatchFetch()) {
            return this.blockData.getInt(columnIndex - 1);
        }
        this.lastWasNull = this.rowData.wasNull(columnIndex);
        if (!this.lastWasNull) {
            int nativeType = this.columnMetaDataList.get(columnIndex - 1).getColType();
            res = this.rowData.getInt(columnIndex, nativeType);
        }
        return res;
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.columnMetaDataList.size());
        long res = 0L;
        if (this.getBatchFetch()) {
            return this.blockData.getLong(columnIndex - 1);
        }
        this.lastWasNull = this.rowData.wasNull(columnIndex);
        if (!this.lastWasNull) {
            Object value = this.rowData.getObject(columnIndex);
            if (value instanceof Timestamp) {
                Timestamp ts = (Timestamp)value;
                long epochSec = ts.getTime() / 1000L;
                long nanoAdjustment = ts.getNanos();
                switch (this.timestampPrecision) {
                    default: {
                        return ts.getTime();
                    }
                    case 1: {
                        return epochSec * 1000000L + nanoAdjustment / 1000L;
                    }
                    case 2: 
                }
                return epochSec * 1000000000L + nanoAdjustment;
            }
            int nativeType = this.columnMetaDataList.get(columnIndex - 1).getColType();
            res = this.rowData.getLong(columnIndex, nativeType);
        }
        return res;
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.columnMetaDataList.size());
        float res = 0.0f;
        if (this.getBatchFetch()) {
            return (float)this.blockData.getDouble(columnIndex - 1);
        }
        this.lastWasNull = this.rowData.wasNull(columnIndex);
        if (!this.lastWasNull) {
            int nativeType = this.columnMetaDataList.get(columnIndex - 1).getColType();
            res = this.rowData.getFloat(columnIndex, nativeType);
        }
        return res;
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.columnMetaDataList.size());
        double res = 0.0;
        if (this.getBatchFetch()) {
            return this.blockData.getDouble(columnIndex - 1);
        }
        this.lastWasNull = this.rowData.wasNull(columnIndex);
        if (!this.lastWasNull) {
            int nativeType = this.columnMetaDataList.get(columnIndex - 1).getColType();
            res = this.rowData.getDouble(columnIndex, nativeType);
        }
        return res;
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.columnMetaDataList.size());
        if (this.getBatchFetch()) {
            return this.blockData.getBytes(columnIndex - 1);
        }
        Object value = this.rowData.getObject(columnIndex);
        boolean bl = this.lastWasNull = value == null;
        if (value == null) {
            return null;
        }
        int nativeType = this.columnMetaDataList.get(columnIndex - 1).getColType();
        switch (nativeType) {
            case 5: {
                return Longs.toByteArray((long)((Long)value));
            }
            case 4: {
                return Ints.toByteArray((int)((Integer)value));
            }
            case 3: {
                return Shorts.toByteArray((short)((Short)value));
            }
            case 2: {
                return new byte[]{(Byte)value};
            }
            case 8: {
                return (byte[])value;
            }
        }
        return value.toString().getBytes();
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.columnMetaDataList.size());
        Timestamp res = null;
        if (this.getBatchFetch()) {
            return this.blockData.getTimestamp(columnIndex - 1);
        }
        this.lastWasNull = this.rowData.wasNull(columnIndex);
        if (!this.lastWasNull) {
            int nativeType = this.columnMetaDataList.get(columnIndex - 1).getColType();
            res = this.rowData.getTimestamp(columnIndex, nativeType);
        }
        return res;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        return new TSDBResultSetMetaData(this.columnMetaDataList);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.columnMetaDataList.size());
        Object res = null;
        if (this.getBatchFetch()) {
            return this.blockData.get(columnIndex - 1);
        }
        this.lastWasNull = this.rowData.wasNull(columnIndex);
        if (!this.lastWasNull) {
            res = this.rowData.getObject(columnIndex);
        }
        return res;
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        for (ColumnMetaData colMetaData : this.columnMetaDataList) {
            if (colMetaData.getColName() == null || !colMetaData.getColName().equalsIgnoreCase(columnLabel)) continue;
            return colMetaData.getColIndex();
        }
        throw TSDBError.createSQLException(8963);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        BigDecimal res;
        if (this.getBatchFetch()) {
            return BigDecimal.valueOf(this.blockData.getDouble(columnIndex - 1));
        }
        this.lastWasNull = this.rowData.wasNull(columnIndex);
        if (this.lastWasNull) {
            return null;
        }
        int nativeType = this.columnMetaDataList.get(columnIndex - 1).getColType();
        switch (nativeType) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                res = new BigDecimal(Long.parseLong(this.rowData.getObject(columnIndex).toString()));
                break;
            }
            case 6: 
            case 7: {
                res = BigDecimal.valueOf(Double.parseDouble(this.rowData.getObject(columnIndex).toString()));
                break;
            }
            case 9: {
                return new BigDecimal(((Timestamp)this.rowData.getObject(columnIndex)).getTime());
            }
            default: {
                res = new BigDecimal(this.rowData.getObject(columnIndex).toString());
            }
        }
        return res;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean isFirst() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean isLast() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void beforeFirst() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void afterLast() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean first() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean last() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public int getRow() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean previous() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public Statement getStatement() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        return this.statement;
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.getTimestamp(columnIndex);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }
}

