/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.ws;

import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.common.SerializeBlock;
import com.taosdata.jdbc.enums.WSFunction;
import com.taosdata.jdbc.rs.ConnectionParam;
import com.taosdata.jdbc.utils.CompletableFutureTimeout;
import com.taosdata.jdbc.utils.ReqId;
import com.taosdata.jdbc.ws.FutureResponse;
import com.taosdata.jdbc.ws.InFlightRequest;
import com.taosdata.jdbc.ws.WSClient;
import com.taosdata.jdbc.ws.WSConnection;
import com.taosdata.jdbc.ws.entity.Action;
import com.taosdata.jdbc.ws.entity.Code;
import com.taosdata.jdbc.ws.entity.ConnectReq;
import com.taosdata.jdbc.ws.entity.ConnectResp;
import com.taosdata.jdbc.ws.entity.Request;
import com.taosdata.jdbc.ws.entity.Response;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.java_websocket.exceptions.WebsocketNotConnectedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Transport
implements AutoCloseable {
    private final Logger log = LoggerFactory.getLogger(Transport.class);
    public static final int DEFAULT_MESSAGE_WAIT_TIMEOUT = 60000;
    private final ArrayList<WSClient> clientArr = new ArrayList();
    private final InFlightRequest inFlightRequest;
    private long timeout;
    private volatile boolean closed = false;
    private final ConnectionParam connectionParam;
    private final WSFunction wsFunction;
    private int currentNodeIndex = 0;

    public Transport(WSFunction function, ConnectionParam param, InFlightRequest inFlightRequest) throws SQLException {
        WSClient master = WSClient.getInstance(param, function, this);
        WSClient slave = WSClient.getSlaveInstance(param, function, this);
        this.clientArr.add(master);
        if (slave != null) {
            this.clientArr.add(slave);
        }
        this.inFlightRequest = inFlightRequest;
        this.connectionParam = param;
        this.wsFunction = function;
        this.timeout = param.getRequestTimeout();
    }

    public void setTextMessageHandler(Consumer<String> textMessageHandler) {
        for (WSClient wsClient : this.clientArr) {
            wsClient.setTextMessageHandler(textMessageHandler);
        }
    }

    public void setBinaryMessageHandler(Consumer<ByteBuffer> binaryMessageHandler) {
        for (WSClient wsClient : this.clientArr) {
            wsClient.setBinaryMessageHandler(binaryMessageHandler);
        }
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    private void reconnect() throws SQLException {
        for (int i = 0; i < this.clientArr.size() && this.connectionParam.isEnableAutoConnect(); ++i) {
            boolean reconnected = this.reconnectCurNode();
            if (reconnected) {
                this.log.debug("reconnect success to {}", (Object)this.clientArr.get((int)this.currentNodeIndex).serverUri);
                return;
            }
            this.log.debug("reconnect failed to {}", (Object)this.clientArr.get((int)this.currentNodeIndex).serverUri);
            this.currentNodeIndex = (this.currentNodeIndex + 1) % this.clientArr.size();
        }
        this.close();
        throw TSDBError.createSQLException(8961, "Websocket Not Connected Exception");
    }

    private void tmqRethrowConnectionCloseException() throws SQLException {
        if (WSFunction.TMQ.equals((Object)this.wsFunction)) {
            throw TSDBError.createSQLException(8961, "Websocket Not Connected Exception");
        }
    }

    public Response send(Request request) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961, "Websocket Not Connected Exception");
        }
        Response response = null;
        CompletableFuture<Response> completableFuture = new CompletableFuture<Response>();
        String reqString = request.toString();
        try {
            this.inFlightRequest.put(new FutureResponse(request.getAction(), request.id(), completableFuture));
        }
        catch (InterruptedException | TimeoutException e) {
            throw new SQLException(e);
        }
        try {
            this.clientArr.get(this.currentNodeIndex).send(reqString);
        }
        catch (WebsocketNotConnectedException e) {
            this.tmqRethrowConnectionCloseException();
            this.reconnect();
            try {
                this.clientArr.get(this.currentNodeIndex).send(reqString);
            }
            catch (Exception ex) {
                this.inFlightRequest.remove(request.getAction(), request.id());
                throw TSDBError.createSQLException(8984, e.getMessage());
            }
        }
        CompletableFuture<Response> responseFuture = CompletableFutureTimeout.orTimeout(completableFuture, this.timeout, TimeUnit.MILLISECONDS, reqString);
        try {
            response = responseFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            this.inFlightRequest.remove(request.getAction(), request.id());
            throw TSDBError.createSQLException(8990, e.getMessage());
        }
        return response;
    }

    public Response send(String action, long reqId, long stmtId, long type, byte[] rawData) throws SQLException {
        Response response;
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961, "Websocket Not Connected Exception");
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            buffer.write(SerializeBlock.longToBytes(reqId));
            buffer.write(SerializeBlock.longToBytes(stmtId));
            buffer.write(SerializeBlock.longToBytes(type));
            buffer.write(rawData);
        }
        catch (IOException e) {
            throw new SQLException("data serialize error!", e);
        }
        CompletableFuture<Response> completableFuture = new CompletableFuture<Response>();
        try {
            this.inFlightRequest.put(new FutureResponse(action, reqId, completableFuture));
        }
        catch (InterruptedException | TimeoutException e) {
            throw new SQLException(e);
        }
        try {
            this.clientArr.get(this.currentNodeIndex).send(buffer.toByteArray());
        }
        catch (WebsocketNotConnectedException e) {
            this.tmqRethrowConnectionCloseException();
            this.reconnect();
            try {
                this.clientArr.get(this.currentNodeIndex).send(buffer.toByteArray());
            }
            catch (Exception ex) {
                this.inFlightRequest.remove(action, reqId);
                throw TSDBError.createSQLException(8984, e.getMessage());
            }
        }
        String reqString = "action:" + action + ", reqId:" + reqId + ", stmtId:" + stmtId + ", bindType" + type;
        CompletableFuture<Response> responseFuture = CompletableFutureTimeout.orTimeout(completableFuture, this.timeout, TimeUnit.MILLISECONDS, reqString);
        try {
            response = responseFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            this.inFlightRequest.remove(action, reqId);
            throw TSDBError.createSQLException(8990, e.getMessage());
        }
        return response;
    }

    public Response sendWithoutRetry(Request request) throws SQLException {
        Response response;
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961, "Websocket Not Connected Exception");
        }
        CompletableFuture<Response> completableFuture = new CompletableFuture<Response>();
        String reqString = request.toString();
        try {
            this.inFlightRequest.put(new FutureResponse(request.getAction(), request.id(), completableFuture));
        }
        catch (InterruptedException | TimeoutException e) {
            throw new SQLException(e);
        }
        try {
            this.clientArr.get(this.currentNodeIndex).send(reqString);
        }
        catch (Exception e) {
            this.inFlightRequest.remove(request.getAction(), request.id());
            throw TSDBError.createSQLException(8984, e.getMessage());
        }
        CompletableFuture<Response> responseFuture = CompletableFutureTimeout.orTimeout(completableFuture, this.timeout, TimeUnit.MILLISECONDS, reqString);
        try {
            response = responseFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            this.inFlightRequest.remove(request.getAction(), request.id());
            throw TSDBError.createSQLException(8990, e.getMessage());
        }
        return response;
    }

    public void sendWithoutRep(Request request) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961, "Websocket Not Connected Exception");
        }
        try {
            this.clientArr.get(this.currentNodeIndex).send(request.toString());
        }
        catch (WebsocketNotConnectedException e) {
            this.tmqRethrowConnectionCloseException();
            this.reconnect();
            try {
                this.clientArr.get(this.currentNodeIndex).send(request.toString());
            }
            catch (Exception ex) {
                throw TSDBError.createSQLException(8984, e.getMessage());
            }
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isConnectionLost() {
        return this.clientArr.get(this.currentNodeIndex).isClosed();
    }

    public void disconnectAndReconnect() throws SQLException {
        try {
            this.clientArr.get(this.currentNodeIndex).closeBlocking();
            if (!this.clientArr.get(this.currentNodeIndex).reconnectBlockingWithoutRetry()) {
                throw TSDBError.createSQLException(8984, "websocket reconnect failed!");
            }
        }
        catch (Exception e) {
            throw TSDBError.createSQLException(8984, e.getMessage());
        }
    }

    @Override
    public synchronized void close() {
        if (this.isClosed()) {
            return;
        }
        this.closed = true;
        this.inFlightRequest.close();
        for (WSClient wsClient : this.clientArr) {
            wsClient.shutdown();
        }
    }

    public void checkConnection(int connectTimeout) throws SQLException {
        try {
            if (WSConnection.g_FirstConnection && this.clientArr.size() > 1) {
                for (WSClient wsClient : this.clientArr) {
                    if (!wsClient.connectBlocking(connectTimeout, TimeUnit.MILLISECONDS)) {
                        this.close();
                        throw TSDBError.createSQLException(8989, "can't create connection with server " + wsClient.serverUri.toString() + " within: " + connectTimeout + " milliseconds");
                    }
                    this.log.debug("connect success to {}", (Object)wsClient.serverUri);
                }
                for (int i = 0; i < this.clientArr.size(); ++i) {
                    if (i == this.currentNodeIndex) continue;
                    this.clientArr.get(i).closeBlocking();
                    this.log.debug("disconnect success to {}", (Object)this.clientArr.get((int)i).serverUri);
                }
            } else {
                if (!this.clientArr.get(this.currentNodeIndex).connectBlocking(connectTimeout, TimeUnit.MILLISECONDS)) {
                    this.close();
                    throw TSDBError.createSQLException(8989, "can't create connection with server within: " + connectTimeout + " milliseconds");
                }
                this.log.debug("connect success to {}", (Object)this.clientArr.get((int)this.currentNodeIndex).serverUri);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.close();
            throw new SQLException("create websocket connection has been Interrupted ", e);
        }
    }

    public void shutdown() {
        this.closed = true;
        if (this.inFlightRequest.hasInFlightRequest()) {
            CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
                try {
                    TimeUnit.MILLISECONDS.sleep(this.timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            });
            future.thenRun(this::close);
        } else {
            this.close();
        }
    }

    public boolean doReconnectCurNode() throws SQLException {
        boolean reconnected = false;
        for (int retryTimes = 0; retryTimes < this.connectionParam.getReconnectRetryCount(); ++retryTimes) {
            try {
                reconnected = this.clientArr.get(this.currentNodeIndex).reconnectBlocking();
                if (reconnected) break;
                Thread.sleep(this.connectionParam.getReconnectIntervalMs());
                continue;
            }
            catch (Exception e) {
                this.log.error("try connect remote server failed!", (Throwable)e);
            }
        }
        return reconnected;
    }

    public boolean reconnectCurNode() throws SQLException {
        boolean reconnected = this.doReconnectCurNode();
        if (!reconnected) {
            return false;
        }
        ConnectReq connectReq = new ConnectReq();
        connectReq.setReqId(ReqId.getReqID());
        connectReq.setUser(this.connectionParam.getUser());
        connectReq.setPassword(this.connectionParam.getPassword());
        connectReq.setDb(this.connectionParam.getDatabase());
        if (this.connectionParam.getConnectMode() != 0) {
            connectReq.setMode(this.connectionParam.getConnectMode());
        }
        ConnectResp auth = (ConnectResp)this.sendWithoutRetry(new Request(Action.CONN.getAction(), connectReq));
        return Code.SUCCESS.getCode() == auth.getCode();
    }
}

