/*
 * Decompiled with CFR 0.152.
 */
package org.redline_rpm;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.redline_rpm.SimpleNamespaceContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlEditor
implements Serializable {
    static final long serialVersionUID = 1L;
    private transient Stack<Node> context = new Stack();
    private transient boolean modified;
    private transient XPath xpath;
    private static final SimpleNamespaceContext NAMESPACE_CONTEXT = new SimpleNamespaceContext();

    public XmlEditor() {
    }

    public XmlEditor(Document document) {
        this.setDocument(document);
    }

    public void setDocument(Document document) {
        this.context.push(document.getDocumentElement());
        this.modified = false;
    }

    public Document getDocument() {
        return this.context.peek().getOwnerDocument();
    }

    public void pushContext(Node node) {
        this.context.push(node);
    }

    public Node popContext() {
        return this.context.pop();
    }

    public void clearContext() {
        while (this.context.size() > 1) {
            this.context.pop();
        }
    }

    public void startPrefixMapping(String uri, String prefix) {
        NAMESPACE_CONTEXT.addNamespace(uri, prefix);
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public void read(File file) throws SAXException, IOException {
        this.setDocument(XmlEditor.readDocument(file));
    }

    public void read(InputStream in) throws SAXException, IOException {
        this.setDocument(XmlEditor.readDocument(in));
    }

    public void write(File file) throws IOException {
        this.modified = false;
        XmlEditor.write(this.context.peek().getOwnerDocument(), file);
    }

    public void write(OutputStream out) throws IOException {
        this.modified = false;
        XmlEditor.write(this.context.peek().getOwnerDocument(), out);
    }

    public void write(ContentHandler handler) throws IOException {
        try {
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(this.context.peek().getOwnerDocument()), new SAXResult(handler));
            this.modified = false;
        }
        catch (TransformerConfigurationException e) {
            assert (false);
            throw new RuntimeException("no transformer", e);
        }
        catch (TransformerException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            assert (false);
            throw new RuntimeException("transformer failed", e);
        }
    }

    public Node createNode(String path) {
        this.modified = true;
        return this.findNode(path, true);
    }

    public Node findNode(String path) {
        return this.findNode(path, false);
    }

    private Node findNode(String path, boolean create) {
        try {
            String name;
            Element parent;
            Node result = (Node)this.xpath(path).evaluate(this.context.peek(), XPathConstants.NODE);
            if (!create || result != null) {
                return result;
            }
            int pos = path.lastIndexOf(47);
            if (pos >= 0) {
                parent = (Element)this.findNode(path.substring(0, pos), true);
                name = path.substring(pos + 1);
            } else {
                parent = (Element)this.context.peek();
                name = path;
            }
            return XmlEditor.newNode(parent, name);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(path, e);
        }
    }

    public Iterable<Node> findNodes(String path) {
        try {
            final NodeList list = (NodeList)this.xpath(path).evaluate(this.context.peek(), XPathConstants.NODESET);
            return new Iterable<Node>(){

                @Override
                public Iterator<Node> iterator() {
                    return new Iterator<Node>(){
                        int count;

                        @Override
                        public boolean hasNext() {
                            return this.count != list.getLength();
                        }

                        @Override
                        public Node next() {
                            return list.item(this.count++);
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            };
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(path, e);
        }
    }

    public void setValue(String path, String value) {
        this.modified = true;
        XmlEditor.setValue(this.createNode(path), value);
    }

    public String getValue(String path) {
        Node n = this.findNode(path);
        if (n == null) {
            return null;
        }
        return n.getNodeValue();
    }

    public Number getValueAsNumber(String path) {
        try {
            return (Number)this.xpath(path).evaluate(this.context.peek(), XPathConstants.NUMBER);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(path, e);
        }
    }

    public String getValue(String path, String def) {
        String value = this.getValue(path);
        return value == null ? def : value;
    }

    public boolean getBoolean(String path) {
        return this.getBoolean(path, false);
    }

    public boolean getBoolean(String path, boolean def) {
        String value = this.getValue(path);
        return value == null ? def : Boolean.valueOf(value);
    }

    public int getInteger(String path) {
        return this.getInteger(path, 0);
    }

    public int getInteger(String path, int def) {
        String value = this.getValue(path);
        return value == null ? def : Integer.parseInt(value);
    }

    private URI getBaseURIFor(Node node) {
        try {
            return new URI(this.xpath("ancestor-or-self::*/@xml:base").evaluate(node));
        }
        catch (XPathExpressionException e) {
            assert (false);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return null;
    }

    public URI getBaseURI() {
        return this.getBaseURIFor(this.context.peek());
    }

    public URI getValueAsURI(String path) {
        try {
            String result = this.getValue(path);
            if (result == null || "".equals(result)) {
                return null;
            }
            return new URI(result);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public URI getValueAsFullURI(String path) {
        URI base = this.getBaseURIFor(this.findNode(path));
        URI result = this.getValueAsURI(path);
        if (result != null && base != null) {
            result = base.resolve(result);
        }
        return result;
    }

    public void deleteNodes(String path) {
        this.modified = true;
        try {
            NodeList list = (NodeList)this.xpath(path).evaluate(this.context.peek(), XPathConstants.NODESET);
            int n = list.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = list.item(i);
                if (node instanceof Attr) {
                    Attr attr = (Attr)node;
                    attr.getOwnerElement().removeAttributeNode(attr);
                    continue;
                }
                node.getParentNode().removeChild(node);
            }
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(path, e);
        }
    }

    public Node appendNode(String path) {
        this.modified = true;
        int pos = path.lastIndexOf(47);
        if (pos >= 0) {
            return XmlEditor.newNode(this.appendNode(path.substring(0, pos)), path.substring(pos + 1));
        }
        return this.newNode(path);
    }

    public void appendCollection(String nodePath, Collection<?> values) {
        this.modified = true;
        for (Object value : values) {
            XmlEditor.setValue(this.appendNode(nodePath), value.toString());
        }
    }

    public void replaceCollection(String nodePath, Collection<?> values) {
        this.modified = true;
        this.deleteNodes(nodePath);
        this.appendCollection(nodePath, values);
    }

    public Collection<String> nodesToText(String path, Collection<String> result) {
        Iterable<Node> nodes = this.findNodes(path);
        for (Node node : nodes) {
            String string = XmlEditor.normalizeString(node.getNodeValue());
            if (string == null) continue;
            result.add(string);
        }
        return result;
    }

    public ContentHandler contentHandler() {
        return new ContentHandler(){
            private Node current;
            private Document doc;
            {
                this.current = (Node)XmlEditor.this.context.peek();
                this.doc = ((Node)XmlEditor.this.context.peek()).getOwnerDocument();
            }

            public void characters(char[] ch, int start, int length) {
                String s = new String(ch, start, length);
                if (this.current instanceof Text) {
                    ((Text)this.current).appendData(s);
                } else {
                    Text text = this.doc.createTextNode(s);
                    this.current.appendChild(text);
                    this.current = text;
                }
            }

            public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
                Element element = this.doc.createElementNS(namespaceURI, qName);
                int n = atts.getLength();
                for (int i = 0; i < n; ++i) {
                    element.setAttribute(atts.getQName(i), atts.getValue(i));
                }
                if (this.current instanceof Text) {
                    this.current.getParentNode().appendChild(element);
                } else {
                    this.current.appendChild(element);
                }
                this.current = element;
            }

            public void endElement(String namespaceURI, String localName, String qName) {
                if (this.current instanceof Text) {
                    this.current = this.current.getParentNode();
                }
                this.current = this.current.getParentNode();
            }

            public void processingInstruction(String target, String data) {
                ProcessingInstruction pi = this.doc.createProcessingInstruction(target, data);
                this.current.getParentNode().appendChild(pi);
                this.current = pi;
            }

            public void startDocument() {
            }

            public void endDocument() {
            }

            public void startPrefixMapping(String prefix, String uri) {
            }

            public void endPrefixMapping(String prefix) {
            }

            public void ignorableWhitespace(char[] ch, int start, int length) {
            }

            public void setDocumentLocator(Locator locator) {
            }

            public void skippedEntity(String name) {
            }
        };
    }

    public Node newNode(String name) {
        return XmlEditor.newNode(this.context.peek(), name);
    }

    public static Document readDocument(File file) throws SAXException, IOException {
        FileInputStream in = new FileInputStream(file);
        Document result = XmlEditor.readDocument(in);
        ((InputStream)in).close();
        return result;
    }

    public static Document readDocument(InputStream in) throws SAXException, IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            return factory.newDocumentBuilder().parse(in);
        }
        catch (ParserConfigurationException e) {
            assert (false);
            throw new RuntimeException("usable DOM parser", e);
        }
    }

    public static void write(Document doc, File file) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        XmlEditor.write(doc, out);
        ((OutputStream)out).close();
    }

    public static void write(Document doc, OutputStream out) throws IOException {
        try {
            doc.normalize();
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(out);
            Transformer xslt = TransformerFactory.newInstance().newTransformer();
            xslt.setOutputProperty("encoding", "iso-8859-1");
            xslt.setOutputProperty("indent", "yes");
            xslt.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            assert (false);
            throw new RuntimeException("no transformer", e);
        }
        catch (TransformerException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            assert (false);
            throw new RuntimeException("transformer failed", e);
        }
    }

    private static void setValue(Node node, String value) {
        if (node instanceof Text) {
            node.setNodeValue(value);
        } else if (node instanceof Attr) {
            if (value == null) {
                Attr attr = (Attr)node;
                attr.getOwnerElement().removeAttributeNode(attr);
            } else {
                node.setNodeValue(value);
            }
        } else {
            XmlEditor.deleteNodeAndFollowingSiblings(node.getFirstChild());
            if (value != null) {
                node.appendChild(node.getOwnerDocument().createTextNode(value));
            }
        }
    }

    private static void deleteNodeAndFollowingSiblings(Node node) {
        Node sib;
        if (node == null) {
            return;
        }
        Node parent = node.getParentNode();
        while ((sib = node.getNextSibling()) != null) {
            parent.removeChild(sib);
        }
        parent.removeChild(node);
    }

    private static Node newNode(Node parent, String name) {
        Document doc = parent.getOwnerDocument();
        if ("text()".equals(name)) {
            Text child = doc.createTextNode("");
            parent.appendChild(child);
            return child;
        }
        if (name.charAt(0) == '@') {
            name = name.substring(1);
            Attr attr = doc.createAttributeNS(XmlEditor.mapNamespacePrefix(name), name);
            ((Element)parent).setAttributeNode(attr);
            return attr;
        }
        Element child = doc.createElementNS(XmlEditor.mapNamespacePrefix(name), name);
        parent.appendChild(child);
        return child;
    }

    private static String mapNamespacePrefix(String name) {
        int pos = name.indexOf(58);
        if (pos < 0) {
            return null;
        }
        String prefix = name.substring(0, pos);
        return NAMESPACE_CONTEXT.getNamespaceURI(prefix);
    }

    public static String normalizeString(String string) {
        if (string == null) {
            return null;
        }
        if ("".equals(string = string.trim())) {
            return null;
        }
        return string;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        CountingOutputStream buf = new CountingOutputStream();
        this.write(buf);
        long length = buf.size();
        out.writeLong(length);
        this.write(out);
    }

    private void readObject(final ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            in.defaultReadObject();
            this.read(new InputStream(){
                private long length;
                {
                    this.length = in.readLong();
                }

                public int read() throws IOException {
                    if (this.length <= 0L) {
                        return -1;
                    }
                    --this.length;
                    return in.read();
                }

                public int read(byte[] b) throws IOException {
                    return this.read(b, 0, b.length);
                }

                public int read(byte[] b, int off, int len) throws IOException {
                    if (this.length <= 0L) {
                        return -1;
                    }
                    if ((long)len > this.length) {
                        len = (int)this.length;
                    }
                    int result = in.read(b, off, len);
                    this.length -= (long)result;
                    return result;
                }

                public long skip(long n) throws IOException {
                    if (this.length <= 0L) {
                        return 0L;
                    }
                    if (n > this.length) {
                        n = this.length;
                    }
                    long result = in.skip(n);
                    this.length -= result;
                    return result;
                }
            });
        }
        catch (SAXException e) {
            IOException x = new IOException();
            x.initCause(e);
            throw x;
        }
    }

    private XPathExpression xpath(String path) throws XPathExpressionException {
        if (this.xpath == null) {
            this.xpath = XPathFactory.newInstance().newXPath();
        }
        this.xpath.setNamespaceContext(NAMESPACE_CONTEXT);
        return this.xpath.compile(path);
    }

    static {
        NAMESPACE_CONTEXT.addNamespace("http://www.w3.org/XML/1998/namespace", "xml");
    }

    private static class CountingOutputStream
    extends FilterOutputStream {
        private long count;

        public CountingOutputStream() {
            super(null);
        }

        public CountingOutputStream(OutputStream out) {
            super(out);
        }

        public void write(int b) throws IOException {
            ++this.count;
            if (this.out != null) {
                this.out.write(b);
            }
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.count += (long)len;
            if (this.out != null) {
                this.out.write(b, off, len);
            }
        }

        public void flush() throws IOException {
            if (this.out != null) {
                this.out.flush();
            }
        }

        public long size() {
            return this.count;
        }
    }
}

