/*
 * Decompiled with CFR 0.152.
 */
package com.vip.vjtools.vjkit.base;

import com.vip.vjtools.vjkit.base.BooleanUtil;
import com.vip.vjtools.vjkit.io.URLResourceUtil;
import com.vip.vjtools.vjkit.number.NumberUtil;
import com.vip.vjtools.vjkit.text.Charsets;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesUtil {
    private static Logger logger = LoggerFactory.getLogger(PropertiesUtil.class);

    public static Boolean getBoolean(Properties p, String name, Boolean defaultValue) {
        return BooleanUtil.toBooleanObject(p.getProperty(name), defaultValue);
    }

    public static Integer getInt(Properties p, String name, Integer defaultValue) {
        return NumberUtil.toIntObject(p.getProperty(name), defaultValue);
    }

    public static Long getLong(Properties p, String name, Long defaultValue) {
        return NumberUtil.toLongObject(p.getProperty(name), defaultValue);
    }

    public static Double getDouble(Properties p, String name, Double defaultValue) {
        return NumberUtil.toDoubleObject(p.getProperty(name), defaultValue);
    }

    public static String getString(Properties p, String name, String defaultValue) {
        return p.getProperty(name, defaultValue);
    }

    public static Properties loadFromFile(String generalPath) {
        Properties p = new Properties();
        try (InputStreamReader reader = new InputStreamReader(URLResourceUtil.asStream(generalPath), Charsets.UTF_8);){
            p.load(reader);
        }
        catch (IOException e) {
            logger.warn("Load property from " + generalPath + " failed", (Throwable)e);
        }
        return p;
    }

    public static Properties loadFromString(String content) {
        Properties p = new Properties();
        try (StringReader reader = new StringReader(content);){
            p.load(reader);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return p;
    }
}

