/*
 * Decompiled with CFR 0.152.
 */
package com.vip.vjtools.vjkit.logging;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

public class PerformanceUtil {
    private static ThreadLocal<Timer> localTimer = new ThreadLocal<Timer>(){

        @Override
        protected Timer initialValue() {
            return new Timer();
        }
    };
    private static ThreadLocal<Map<String, Timer>> localTimerMap = new ThreadLocal<Map<String, Timer>>(){

        @Override
        protected Map<String, Timer> initialValue() {
            return new HashMap<String, Timer>();
        }
    };

    private PerformanceUtil() {
    }

    public static void start() {
        localTimer.get().start();
    }

    public static long duration() {
        return localTimer.get().duration();
    }

    public static long end() {
        long duration = localTimer.get().duration();
        localTimer.remove();
        return duration;
    }

    public static void start(String key) {
        PerformanceUtil.getTimer(key).start();
    }

    public static long duration(String key) {
        return PerformanceUtil.getTimer(key).duration();
    }

    public static long end(String key) {
        long duration = PerformanceUtil.getTimer(key).duration();
        localTimerMap.get().remove(key);
        return duration;
    }

    public static void removeAll() {
        localTimer.remove();
        localTimerMap.remove();
    }

    public static void slowLog(Logger logger, long duration, long threshold) {
        if (duration > threshold) {
            logger.warn("[Performance Warning]  use {}ms, slow than {}ms", (Object)duration, (Object)threshold);
        }
    }

    public static void slowLog(Logger logger, String key, long duration, long threshold) {
        if (duration > threshold) {
            logger.warn("[Performance Warning] task {} use {}ms, slow than {}ms", new Object[]{key, duration, threshold});
        }
    }

    public static void slowLog(Logger logger, long duration, long threshold, String context) {
        if (duration > threshold) {
            logger.warn("[Performance Warning] use {}ms, slow than {}ms, context={}", new Object[]{duration, threshold, context});
        }
    }

    public static void slowLog(Logger logger, String key, long duration, long threshold, String context) {
        if (duration > threshold) {
            logger.warn("[Performance Warning] task {} use {}ms, slow than {}ms, contxt={}", new Object[]{key, duration, threshold, context});
        }
    }

    public static void endWithSlowLog(Logger logger, long threshold) {
        PerformanceUtil.slowLog(logger, PerformanceUtil.end(), threshold);
    }

    public static void endWithSlowLog(Logger logger, String key, long threshold) {
        PerformanceUtil.slowLog(logger, key, PerformanceUtil.end(key), threshold);
    }

    public static void endWithSlowLog(Logger logger, long threshold, String context) {
        PerformanceUtil.slowLog(logger, PerformanceUtil.end(), threshold, context);
    }

    public static void endWithSlowLog(Logger logger, String key, long threshold, String context) {
        PerformanceUtil.slowLog(logger, key, PerformanceUtil.end(key), threshold, context);
    }

    private static Timer getTimer(String key) {
        Map<String, Timer> map = localTimerMap.get();
        Timer timer = map.get(key);
        if (timer == null) {
            timer = new Timer();
            map.put(key, timer);
        }
        return timer;
    }

    static class Timer {
        private long start;

        Timer() {
        }

        public void start() {
            this.start = System.currentTimeMillis();
        }

        public long duration() {
            return System.currentTimeMillis() - this.start;
        }
    }
}

