/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.misc;

import java.util.BitSet;
import java.util.Objects;
import java.util.function.IntPredicate;
import org.jetbrains.annotations.NotNull;

public interface CharPredicate
extends IntPredicate {
    public static final CharPredicate NONE;
    public static final CharPredicate ALL;
    public static final CharPredicate SPACE;
    public static final CharPredicate TAB;
    public static final CharPredicate EOL;
    public static final CharPredicate ANY_EOL;
    public static final CharPredicate ANY_EOL_NUL;
    public static final CharPredicate BACKSLASH;
    public static final CharPredicate SLASH;
    public static final CharPredicate LINE_SEP;
    public static final CharPredicate HASH;
    public static final CharPredicate SPACE_TAB;
    public static final CharPredicate SPACE_TAB_NUL;
    public static final CharPredicate SPACE_TAB_LINE_SEP;
    public static final CharPredicate SPACE_TAB_NBSP_LINE_SEP;
    public static final CharPredicate SPACE_EOL;
    public static final CharPredicate SPACE_ANY_EOL;
    public static final CharPredicate SPACE_TAB_NBSP;
    public static final CharPredicate SPACE_TAB_EOL;
    public static final CharPredicate SPACE_TAB_NBSP_EOL;
    public static final CharPredicate WHITESPACE;
    public static final CharPredicate WHITESPACE_OR_NUL;
    public static final CharPredicate WHITESPACE_NBSP;
    public static final CharPredicate WHITESPACE_NBSP_OR_NUL;
    public static final CharPredicate HEXADECIMAL_DIGITS;
    public static final CharPredicate DECIMAL_DIGITS;
    public static final CharPredicate OCTAL_DIGITS;
    public static final CharPredicate BINARY_DIGITS;
    @Deprecated
    public static final CharPredicate FALSE;
    @Deprecated
    public static final CharPredicate TRUE;
    @Deprecated
    public static final CharPredicate SPACE_TAB_OR_NUL;

    @Override
    public boolean test(int var1);

    default public boolean test(char value) {
        return this.test((int)value);
    }

    @NotNull
    default public CharPredicate and(@NotNull CharPredicate other) {
        Objects.requireNonNull(other);
        return this == NONE || other == NONE ? NONE : (this == ALL ? other : (other == ALL ? this : value -> this.test(value) && other.test(value)));
    }

    @Override
    @NotNull
    default public CharPredicate negate() {
        return this == NONE ? ALL : (this == ALL ? NONE : value -> !this.test(value));
    }

    @NotNull
    default public CharPredicate or(@NotNull CharPredicate other) {
        Objects.requireNonNull(other);
        return this == ALL || other == ALL ? ALL : (this == NONE ? other : (other == NONE ? this : value -> this.test(value) || other.test(value)));
    }

    @NotNull
    public static CharPredicate standardOrAnyOf(char c1) {
        return SPACE.test(c1) ? SPACE : (EOL.test(c1) ? EOL : (TAB.test(c1) ? TAB : value1 -> value1 == c1));
    }

    @NotNull
    public static CharPredicate standardOrAnyOf(char c1, char c2) {
        return c1 == c2 ? CharPredicate.standardOrAnyOf(c1) : (SPACE_TAB.test(c1) && SPACE_TAB.test(c2) ? SPACE_TAB : (ANY_EOL.test(c1) && ANY_EOL.test(c2) ? ANY_EOL : value -> value == c1 || value == c2));
    }

    @NotNull
    public static CharPredicate standardOrAnyOf(char c1, char c2, char c3) {
        return c1 == c2 && c2 == c3 ? CharPredicate.standardOrAnyOf(c1) : (c1 == c2 || c1 == c3 ? CharPredicate.standardOrAnyOf(c2, c3) : (c2 == c3 ? CharPredicate.standardOrAnyOf(c1, c3) : value -> value == c1 || value == c2 || value == c3));
    }

    @NotNull
    public static CharPredicate standardOrAnyOf(char c1, char c2, char c3, char c4) {
        return c1 == c2 && c2 == c3 && c3 == c4 ? CharPredicate.standardOrAnyOf(c1) : (c1 == c2 || c1 == c3 || c1 == c4 ? CharPredicate.standardOrAnyOf(c2, c3, c4) : (c2 == c3 || c2 == c4 ? CharPredicate.standardOrAnyOf(c1, c3, c4) : (c3 == c4 ? CharPredicate.standardOrAnyOf(c1, c2, c3) : (WHITESPACE.test(c1) && WHITESPACE.test(c2) && WHITESPACE.test(c3) && WHITESPACE.test(c4) ? WHITESPACE : value -> value == c1 || value == c2 || value == c3 || value == c4))));
    }

    @NotNull
    public static CharPredicate anyOf(char ... chars) {
        switch (chars.length) {
            case 0: {
                return NONE;
            }
            case 1: {
                return CharPredicate.standardOrAnyOf(chars[0]);
            }
            case 2: {
                return CharPredicate.standardOrAnyOf(chars[0], chars[1]);
            }
            case 3: {
                return CharPredicate.standardOrAnyOf(chars[0], chars[1], chars[2]);
            }
            case 4: {
                return CharPredicate.standardOrAnyOf(chars[0], chars[1], chars[2], chars[3]);
            }
        }
        return CharPredicate.anyOf(String.valueOf(chars));
    }

    public static int indexOf(@NotNull CharSequence thizz, char c) {
        return CharPredicate.indexOf(thizz, c, 0, thizz.length());
    }

    public static int indexOf(@NotNull CharSequence thizz, char c, int fromIndex, int endIndex) {
        fromIndex = Math.max(fromIndex, 0);
        endIndex = Math.min(thizz.length(), endIndex);
        for (int i = fromIndex; i < endIndex; ++i) {
            if (c != thizz.charAt(i)) continue;
            return i;
        }
        return -1;
    }

    @NotNull
    public static CharPredicate anyOf(@NotNull CharSequence chars) {
        CharPredicate testAscii;
        String finalOthers;
        int maxFixed = 4;
        switch (chars.length()) {
            case 0: {
                return NONE;
            }
            case 1: {
                return CharPredicate.standardOrAnyOf(chars.charAt(0));
            }
            case 2: {
                return CharPredicate.standardOrAnyOf(chars.charAt(0), chars.charAt(1));
            }
            case 3: {
                return CharPredicate.standardOrAnyOf(chars.charAt(0), chars.charAt(1), chars.charAt(2));
            }
            case 4: {
                return CharPredicate.standardOrAnyOf(chars.charAt(0), chars.charAt(1), chars.charAt(2), chars.charAt(3));
            }
        }
        BitSet ascii = null;
        StringBuilder others = null;
        int iMax = chars.length();
        for (int i = 0; i < iMax; ++i) {
            char c = chars.charAt(i);
            if (c <= '\u007f') {
                if (ascii == null) {
                    ascii = new BitSet();
                }
                ascii.set(c);
                continue;
            }
            if (others == null) {
                others = new StringBuilder();
            }
            if (CharPredicate.indexOf(others, c) != -1) continue;
            others.append(c);
        }
        String string = finalOthers = others == null ? null : others.toString();
        CharPredicate testOthers = finalOthers == null || finalOthers.isEmpty() ? null : (finalOthers.length() <= maxFixed ? CharPredicate.anyOf(others) : value -> CharPredicate.indexOf(finalOthers, (char)value) != -1);
        CharPredicate charPredicate = testAscii = ascii == null || ascii.cardinality() == 0 ? null : ascii::get;
        if (!1.$assertionsDisabled && testAscii == null && testOthers == null) {
            throw new AssertionError();
        }
        if (testAscii != null && testOthers != null) {
            return testAscii.or(testOthers);
        }
        if (testAscii != null) {
            return testAscii;
        }
        return testOthers;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        NONE = value -> false;
        ALL = value -> true;
        SPACE = value -> value == 32;
        TAB = value -> value == 9;
        EOL = value -> value == 10;
        ANY_EOL = value -> value == 10 || value == 13;
        ANY_EOL_NUL = value -> value == 10 || value == 13 || value == 0;
        BACKSLASH = value -> value == 92;
        SLASH = value -> value == 47;
        LINE_SEP = value -> value == 8232;
        HASH = value -> value == 35;
        SPACE_TAB = value -> value == 32 || value == 9;
        SPACE_TAB_NUL = value -> value == 32 || value == 9 || value == 0;
        SPACE_TAB_LINE_SEP = value -> value == 32 || value == 9 || value == 8232;
        SPACE_TAB_NBSP_LINE_SEP = value -> value == 32 || value == 9 || value == 160 || value == 8232;
        SPACE_EOL = value -> value == 32 || value == 10;
        SPACE_ANY_EOL = value -> value == 32 || value == 13 || value == 10;
        SPACE_TAB_NBSP = value -> value == 32 || value == 9 || value == 160;
        SPACE_TAB_EOL = value -> value == 32 || value == 9 || value == 10;
        SPACE_TAB_NBSP_EOL = value -> value == 32 || value == 9 || value == 10 || value == 160;
        WHITESPACE = value -> value == 32 || value == 9 || value == 10 || value == 13;
        WHITESPACE_OR_NUL = value -> value == 32 || value == 9 || value == 10 || value == 13 || value == 0;
        WHITESPACE_NBSP = value -> value == 32 || value == 9 || value == 10 || value == 13 || value == 160;
        WHITESPACE_NBSP_OR_NUL = value -> value == 32 || value == 9 || value == 10 || value == 13 || value == 160 || value == 0;
        HEXADECIMAL_DIGITS = value -> value >= 48 && value <= 57 || value >= 97 && value <= 102 || value >= 65 && value <= 70;
        DECIMAL_DIGITS = value -> value >= 48 && value <= 57;
        OCTAL_DIGITS = value -> value >= 48 && value <= 55;
        BINARY_DIGITS = value -> value >= 48 && value <= 49;
        FALSE = NONE;
        TRUE = ALL;
        SPACE_TAB_OR_NUL = SPACE_TAB_NUL;
    }
}

