/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3;

import com.xnx3.Lang;
import com.xnx3.net.HttpsUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtil {
    public static final String UTF8 = "UTF-8";
    public static final String GBK = "GBK";
    static final String ENCODE = "UTF-8";

    public static String read(String path) {
        return FileUtil.read(path, "UTF-8");
    }

    public static String read(String path, String encode) {
        StringBuffer xnx3_content = new StringBuffer();
        try {
            File file = new File(path);
            BufferedReader xnx3_reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encode));
            String date = null;
            while ((date = xnx3_reader.readLine()) != null) {
                xnx3_content.append(date + "\n");
            }
            xnx3_reader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return xnx3_content.toString();
    }

    public static String read(File file, String encode) {
        StringBuffer xnx3_content = new StringBuffer();
        try {
            BufferedReader xnx3_reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encode));
            String date = null;
            while ((date = xnx3_reader.readLine()) != null) {
                xnx3_content.append(date);
            }
            xnx3_reader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return xnx3_content.toString();
    }

    public static boolean write(String path, String xnx3_content) {
        try {
            FileWriter fw = new FileWriter(path);
            PrintWriter pw = new PrintWriter(fw);
            pw.print(xnx3_content);
            pw.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void write(String path, String xnx3_content, String encode) throws IOException {
        FileOutputStream fos = new FileOutputStream(path);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, encode);
        osw.write(xnx3_content);
        osw.flush();
    }

    public static boolean write(File file, String xnx3_content) {
        try {
            PrintWriter pw = new PrintWriter(file);
            pw.print(xnx3_content);
            pw.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void inputStreamToFile(InputStream inputStream, String targetFilePath) {
        File file = new File(targetFilePath);
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            int bytesRead = 0;
            byte[] buffer = new byte[8192];
            while ((bytesRead = inputStream.read(buffer, 0, 8192)) != -1) {
                ((OutputStream)os).write(buffer, 0, bytesRead);
            }
            os.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                ((OutputStream)os).close();
                inputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(String sourceFile, String targetFile) {
        BufferedInputStream inBuff = null;
        FilterOutputStream outBuff = null;
        try {
            int len;
            inBuff = new BufferedInputStream(new FileInputStream(sourceFile));
            outBuff = new BufferedOutputStream(new FileOutputStream(targetFile));
            byte[] b = new byte[5120];
            while ((len = inBuff.read(b)) != -1) {
                ((BufferedOutputStream)outBuff).write(b, 0, len);
            }
            ((BufferedOutputStream)outBuff).flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (inBuff != null) {
                try {
                    inBuff.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (outBuff != null) {
                try {
                    outBuff.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static boolean deleteFile(String fileName) {
        boolean xnx3_result = false;
        File f = new File(fileName);
        if (f.isFile() && f.exists()) {
            f.delete();
            xnx3_result = true;
        }
        return xnx3_result;
    }

    public static boolean exists(String filePath) {
        File f = new File(filePath);
        return f.exists();
    }

    public static long getFileSize(String url) {
        int nFileLength = -1;
        try {
            String sHeader;
            URL xnx3_url = new URL(url);
            HttpURLConnection httpConnection = (HttpURLConnection)xnx3_url.openConnection();
            httpConnection.setRequestProperty("User-Agent", "Internet Explorer");
            int responseCode = httpConnection.getResponseCode();
            if (responseCode >= 400) {
                System.err.println("Error Code : " + responseCode);
                return -2L;
            }
            int i = 1;
            while ((sHeader = httpConnection.getHeaderFieldKey(i)) != null) {
                if (sHeader.equals("Content-Length")) {
                    nFileLength = Integer.parseInt(httpConnection.getHeaderField(sHeader));
                    break;
                }
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nFileLength;
    }

    public static void downFile(String downUrl, String savePath) throws IOException {
        FileUtil.downFile(downUrl, savePath, null);
    }

    public static void downFile(String downUrl, String savePath, Map<String, String> param) throws IOException {
        FileUtil.downFile(downUrl, savePath, param, 30000);
    }

    public static void downFile(String downUrl, String savePath, Map<String, String> param, int timeout) throws IOException {
        if (FileUtil.exists(savePath)) {
            FileUtil.deleteFile(savePath);
        }
        int nStartPos = 0;
        int nRead = 0;
        URL url = new URL(downUrl);
        if (downUrl.indexOf("http://") > -1) {
            HttpURLConnection httpConnection = (HttpURLConnection)url.openConnection();
            httpConnection.setConnectTimeout(timeout);
            httpConnection.setReadTimeout(timeout);
            long nEndPos = FileUtil.getFileSize(downUrl);
            RandomAccessFile oSavedFile = new RandomAccessFile(savePath, "rw");
            if (param != null) {
                for (Map.Entry<String, String> entry : param.entrySet()) {
                    httpConnection.setRequestProperty(entry.getKey(), entry.getValue());
                }
            } else {
                httpConnection.setRequestProperty("User-Agent", "Internet Explorer");
            }
            String sProperty = "bytes=" + nStartPos + "-";
            httpConnection.setRequestProperty("RANGE", sProperty);
            InputStream input = httpConnection.getInputStream();
            if (nEndPos == -1L) {
                oSavedFile.write(FileUtil.inputstreamToByte(input));
            } else {
                byte[] b = new byte[1024];
                while ((nRead = input.read(b, 0, 1024)) > 0 && (long)nStartPos < nEndPos) {
                    oSavedFile.write(b, 0, nRead);
                    nStartPos += nRead;
                }
            }
            httpConnection.disconnect();
            oSavedFile.close();
        } else if (downUrl.indexOf("https://") > -1) {
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            conn.setConnectTimeout(timeout);
            conn.setReadTimeout(timeout);
            SSLContext sc = null;
            try {
                sc = SSLContext.getInstance("SSL");
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            try {
                sc.init(null, new TrustManager[]{new HttpsUtil.TrustAnyTrustManager()}, new SecureRandom());
            }
            catch (KeyManagementException e) {
                e.printStackTrace();
            }
            conn.setSSLSocketFactory(sc.getSocketFactory());
            conn.setHostnameVerifier(new HttpsUtil.TrustAnyHostnameVerifier());
            int nEndPos = Lang.stringToInt(conn.getHeaderField("Content-Length"), -1);
            RandomAccessFile oSavedFile = new RandomAccessFile(savePath, "rw");
            if (param != null) {
                for (Map.Entry<String, String> entry : param.entrySet()) {
                    conn.setRequestProperty(entry.getKey(), entry.getValue());
                }
            } else {
                conn.setRequestProperty("User-Agent", "Internet Explorer");
            }
            String sProperty = "bytes=" + nStartPos + "-";
            InputStream input = conn.getInputStream();
            if (nEndPos == -1) {
                oSavedFile.write(FileUtil.inputstreamToByte(input));
            } else {
                byte[] b = new byte[1024];
                while ((nRead = input.read(b, 0, 1024)) > 0 && nStartPos < nEndPos) {
                    oSavedFile.write(b, 0, nRead);
                    nStartPos += nRead;
                }
            }
            conn.disconnect();
            oSavedFile.close();
        }
    }

    public static String bufferedReaderToString(BufferedReader br) {
        String str = "";
        try {
            String inputLine;
            while ((inputLine = br.readLine()) != null) {
                str = str + inputLine;
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return str;
    }

    public static byte[] inputstreamToByte(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        return output.toByteArray();
    }

    public static Date getCreateTime(String filePath) {
        Path path = Paths.get(filePath, new String[0]);
        BasicFileAttributeView basicview = Files.getFileAttributeView(path, BasicFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
        try {
            BasicFileAttributes attr = basicview.readAttributes();
            Date createDate = new Date(attr.creationTime().toMillis());
            return createDate;
        }
        catch (Exception e) {
            e.printStackTrace();
            Calendar cal = Calendar.getInstance();
            cal.set(1970, 0, 1, 0, 0, 0);
            return cal.getTime();
        }
    }
}

