/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3;

import com.xnx3.Lang;
import java.awt.Desktop;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

public class SystemUtil {
    public static void openUrl(String url) {
        URI uri = null;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        try {
            Desktop.getDesktop().browse(uri);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static float getJavaSpecificationVersion() {
        String v = System.getProperty("java.specification.version");
        float xnx3_result = 0.0f;
        xnx3_result = v == null || v.equals("") ? 0.0f : Lang.stringToFloat(v, 0.0f);
        return xnx3_result;
    }

    public static String getCurrentDir() {
        return System.getProperty("user.dir");
    }

    public static String getJrePath() {
        return System.getProperty("java.home");
    }

    public static void setClipboardText(String content) {
        String vc = content.trim();
        StringSelection ss = new StringSelection(vc);
        Clipboard sysClb = null;
        sysClb = Toolkit.getDefaultToolkit().getSystemClipboard();
        sysClb.setContents(ss, null);
    }

    public static void setClipboardImage(String filePath) {
        Image img = Toolkit.getDefaultToolkit().getImage(filePath);
        SystemUtil.setClipboardImage(img);
    }

    public static void setClipboardImage(Image image) {
        ImageSelection imgSel = new ImageSelection(image);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(imgSel, null);
    }

    public static void openLocalFolder(String filePath) {
        try {
            Desktop.getDesktop().open(new File(filePath));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static class ImageSelection
    implements Transferable {
        private Image image;

        public ImageSelection(Image image) {
            this.image = image;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.imageFlavor};
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return DataFlavor.imageFlavor.equals(flavor);
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!DataFlavor.imageFlavor.equals(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.image;
        }
    }
}

