/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ScanClassUtil {
    public static void main(String[] args) throws ClassNotFoundException, NoSuchMethodException, SecurityException {
        List<Class<?>> classList = ScanClassUtil.getClasses("com.xnx3");
        for (int i = 0; i < classList.size(); ++i) {
            System.out.println(classList.get(i).getName());
        }
        List<Class<?>> c = ScanClassUtil.getClassSearchAnnotationsName(classList, "PluginRegister");
        System.out.println(c.get(0).getCanonicalName());
    }

    public static List<Class<?>> searchByInterfaceName(List<Class<?>> classList, String interfaceName) {
        Iterator<Class<?>> iterator = classList.iterator();
        ArrayList list = new ArrayList();
        while (iterator.hasNext()) {
            Class<?> cls = iterator.next();
            Class<?>[] ic = cls.getInterfaces();
            for (int i = 0; i < ic.length; ++i) {
                Class<?> c = ic[i];
                if (!c.getName().equals(interfaceName)) continue;
                list.add(cls);
            }
        }
        return list;
    }

    public static List<Class<?>> getSuperClass(List<Class<?>> classList, String superClassName) {
        ArrayList list = new ArrayList();
        for (Class<?> clazz : classList) {
            Class<?> superClass = clazz.getSuperclass();
            if (!superClassName.equalsIgnoreCase(superClass.getName())) continue;
            list.add(clazz);
        }
        return list;
    }

    public static List<Class<?>> getClassSearchAnnotationsName(List<Class<?>> classList, String annotationClassSimpleName) {
        ArrayList list = new ArrayList();
        for (Class<?> clazz : classList) {
            Annotation[] annos = clazz.getAnnotations();
            for (int j = 0; j < annos.length; ++j) {
                if (!annos[j].annotationType().getSimpleName().equals(annotationClassSimpleName)) continue;
                list.add(clazz);
            }
        }
        return list;
    }

    public static List<Class<?>> getClasses(String pack) {
        ArrayList classList = new ArrayList();
        boolean recursive = true;
        String packageName = pack;
        String packageDirName = packageName.replace('.', '/');
        ClassLoader loader = ScanClassUtil.class.getClassLoader();
        try {
            Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(packageDirName);
            while (dirs.hasMoreElements()) {
                URL url = dirs.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                    ScanClassUtil.findAndAddClassesInPackageByFile(packageName, filePath, recursive, classList);
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                try {
                    JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        String name = entry.getName();
                        if (name.charAt(0) == '/') {
                            name = name.substring(1);
                        }
                        if (!name.startsWith(packageDirName)) continue;
                        int idx = name.lastIndexOf(47);
                        if (idx != -1) {
                            packageName = name.substring(0, idx).replace('/', '.');
                        }
                        if (idx == -1 && !recursive || !name.endsWith(".class") || entry.isDirectory()) continue;
                        String className = name.substring(packageName.length() + 1, name.length() - 6);
                        try {
                            classList.add(loader.loadClass(packageName + "." + className));
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                        }
                        catch (NoClassDefFoundError noClassDefFoundError) {}
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return classList;
    }

    public static void findAndAddClassesInPackageByFile(String packageName, String packagePath, final boolean recursive, List<Class<?>> classes) {
        File[] dirfiles;
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        for (File file : dirfiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return recursive && file.isDirectory() || file.getName().endsWith(".class");
            }
        })) {
            if (file.isDirectory()) {
                ScanClassUtil.findAndAddClassesInPackageByFile(packageName + "." + file.getName(), file.getAbsolutePath(), recursive, classes);
                continue;
            }
            String className = file.getName().substring(0, file.getName().length() - 6);
            try {
                classes.add(Thread.currentThread().getContextClassLoader().loadClass(packageName + '.' + className));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean classExist(String packageName) {
        try {
            Class.forName(packageName);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

