/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3;

import com.xnx3.Lang;
import java.awt.Desktop;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Scanner;

public class SystemUtil {
    private static String osname = null;

    public static void openUrl(String url) {
        URI uri = null;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        try {
            Desktop.getDesktop().browse(uri);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static float getJavaSpecificationVersion() {
        String v = System.getProperty("java.specification.version");
        float xnx3_result = 0.0f;
        xnx3_result = v == null || v.equals("") ? 0.0f : Lang.stringToFloat(v, 0.0f);
        return xnx3_result;
    }

    public static String getCurrentDir() {
        return System.getProperty("user.dir");
    }

    public static String getJrePath() {
        return System.getProperty("java.home");
    }

    public static void setClipboardText(String content) {
        String vc = content.trim();
        StringSelection ss = new StringSelection(vc);
        Clipboard sysClb = null;
        sysClb = Toolkit.getDefaultToolkit().getSystemClipboard();
        sysClb.setContents(ss, null);
    }

    public static void setClipboardImage(String filePath) {
        Image img = Toolkit.getDefaultToolkit().getImage(filePath);
        SystemUtil.setClipboardImage(img);
    }

    public static void setClipboardImage(Image image) {
        ImageSelection imgSel = new ImageSelection(image);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(imgSel, null);
    }

    public static void openLocalFolder(String filePath) {
        try {
            Desktop.getDesktop().open(new File(filePath));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getOSName() {
        if (osname == null) {
            osname = System.getProperty("os.name").toLowerCase();
        }
        return osname;
    }

    public static boolean isWindowsOS() {
        return SystemUtil.getOSName().indexOf("window") > -1;
    }

    public static boolean isMacOS() {
        return SystemUtil.getOSName().indexOf("mac") > -1;
    }

    public static String getCpuId() throws Exception {
        String os = System.getProperty("os.name");
        String cpuId = "LINUX".equals(os = os.toUpperCase()) ? SystemUtil.getLinuxCpuId("dmidecode -t processor | grep 'ID'", "ID", ":") : SystemUtil.getWindowsCpuId();
        return cpuId.toUpperCase().replace(" ", "");
    }

    public static String getLinuxCpuId(String cmd, String record, String symbol) throws Exception {
        String[] infos;
        String execResult = SystemUtil.executeLinuxCmd(cmd);
        for (String info : infos = execResult.split("\n")) {
            if ((info = info.trim()).indexOf(record) == -1) continue;
            info.replace(" ", "");
            String[] sn = info.split(symbol);
            return sn[1];
        }
        return null;
    }

    public static String executeLinuxCmd(String cmd) throws Exception {
        int n;
        Runtime run = Runtime.getRuntime();
        Process process = run.exec(cmd);
        InputStream in = process.getInputStream();
        BufferedReader bs = new BufferedReader(new InputStreamReader(in));
        StringBuffer out = new StringBuffer();
        byte[] b = new byte[8192];
        while ((n = in.read(b)) != -1) {
            out.append(new String(b, 0, n));
        }
        in.close();
        process.destroy();
        return out.toString();
    }

    public static String getWindowsCpuId() throws Exception {
        Process process = Runtime.getRuntime().exec(new String[]{"wmic", "cpu", "get", "ProcessorId"});
        process.getOutputStream().close();
        Scanner sc = new Scanner(process.getInputStream());
        sc.next();
        String serial = sc.next();
        return serial;
    }

    public static void main(String[] args) {
        try {
            System.out.println(SystemUtil.getCpuId());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class ImageSelection
    implements Transferable {
        private Image image;

        public ImageSelection(Image image) {
            this.image = image;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.imageFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return DataFlavor.imageFlavor.equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!DataFlavor.imageFlavor.equals(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.image;
        }
    }
}

