/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3;

import com.xnx3.Lang;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UrlUtil {
    public static final Set<String> STATIC_EXTENSIONS = new HashSet<String>(Arrays.asList("jpg", "jpeg", "png", "gif", "bmp", "webp", "svg", "ico", "css", "less", "sass", "scss", "js", "jsx", "ts", "tsx", "eot", "woff", "woff2", "ttf", "otf", "pdf", "doc", "docx", "xls", "xlsx", "ppt", "pptx", "txt", "mp3", "wav", "ogg", "flac", "mp4", "webm", "ogv", "avi", "mov", "zip", "rar", "7z", "tar", "gz", "csv", "md", "obj", "fbx", "gltf", "glb", "swf", "htaccess", "yaml", "yml", "geojson", "kml", "kmz"));

    public static boolean isStaticResource(String extension) {
        for (String ext : STATIC_EXTENSIONS) {
            if (!ext.equalsIgnoreCase(extension)) continue;
            return true;
        }
        return false;
    }

    public static boolean isStaticFile(String url) {
        String requestUri = new String(url);
        String suffix = Lang.findFileSuffix(requestUri);
        if (suffix == null || suffix.length() == 0) {
            return false;
        }
        return UrlUtil.isStaticResource(suffix);
    }

    public static String hierarchyReplace(String path, String originalUrl) {
        if (UrlUtil.isAbsoluteUrl(originalUrl)) {
            return originalUrl;
        }
        String domain = "";
        String s = path.substring(9, path.length());
        int domianInt = s.indexOf("/");
        if (domianInt > 0) {
            domain = path.substring(0, domianInt + 9);
        }
        if (path.lastIndexOf("/") != path.length()) {
            path = path + "/";
        }
        if (originalUrl.indexOf("/") == 0) {
            return domain + originalUrl;
        }
        while (originalUrl.indexOf("./") == 0 || originalUrl.indexOf("../") == 0) {
            if (originalUrl.indexOf("./") == 0) {
                originalUrl = originalUrl.substring(2, originalUrl.length());
                continue;
            }
            if (originalUrl.indexOf("../") != 0) continue;
            originalUrl = originalUrl.substring(3, originalUrl.length());
            path = path.substring(0, path.substring(0, path.length() - 1).lastIndexOf("/") + 1);
        }
        return path + originalUrl;
    }

    public static boolean isAbsoluteUrl(String url) {
        return url.indexOf("http://") > -1 || url.indexOf("https://") > -1 || url.indexOf("//") > -1;
    }

    public static String getPath(String url) {
        int last;
        int jinghao;
        int wenhao = url.lastIndexOf("?");
        if (wenhao > -1) {
            url = url.substring(0, wenhao);
        }
        if ((jinghao = url.lastIndexOf("#")) > -1) {
            url = url.substring(0, jinghao);
        }
        if ((last = url.lastIndexOf("/")) > 8) {
            url = url.substring(0, last + 1);
        }
        return url;
    }

    public static String getFileName(String url) {
        int last;
        int jinghao;
        int wenhao = url.lastIndexOf("?");
        if (wenhao > -1) {
            url = url.substring(0, wenhao);
        }
        if ((jinghao = url.lastIndexOf("#")) > -1) {
            url = url.substring(0, jinghao);
        }
        if ((last = url.lastIndexOf("/")) > 8) {
            url = url.substring(last + 1, url.length());
            return url;
        }
        return "";
    }

    public static String getDomain(String url) {
        if (url == null || url.length() == 0) {
            return url;
        }
        int start = url.indexOf("//");
        if (start > 0) {
            int end = (url = url.substring(start + 2, url.length())).indexOf("/");
            if (end > 0) {
                url = url.substring(0, end);
            }
            return url;
        }
        String DOMAIN_REGEX = "^(?!-)(?!.*--)(?!.*-\\.)[A-Za-z0-9-]{1,63}(?<!-)(?:\\.[A-Za-z0-9-]{2,})+$";
        Pattern pattern = Pattern.compile(DOMAIN_REGEX);
        Matcher matcher = pattern.matcher(url);
        if (matcher.matches()) {
            return url;
        }
        return "";
    }

    public static String getFileBeforeName(String fileName) {
        if (fileName == null) {
            return "";
        }
        String htmlFile = "";
        if (fileName.indexOf(".") > 0) {
            String[] s = fileName.split("\\.");
            htmlFile = s[0];
        } else {
            htmlFile = fileName;
        }
        return htmlFile;
    }

    public static String getProtocols(String url) {
        if (url == null) {
            return null;
        }
        if (url.indexOf("//") > 1) {
            return url.substring(0, url.indexOf("//") - 1);
        }
        return null;
    }

    public static String getRequestPath(String url) {
        String domain = UrlUtil.getDomain(url);
        String protocolsDomain = url.substring(0, url.indexOf(domain) + domain.length());
        if (url.length() <= protocolsDomain.length() + 1) {
            return "/";
        }
        return url.substring(protocolsDomain.length(), url.length());
    }

    public static String getFileSuffix(String fileName) {
        if (fileName == null) {
            return null;
        }
        String suffix = Lang.findFileSuffix(fileName);
        return suffix;
    }

    public static String getProtocolsAndDomain(String url) {
        String pro = UrlUtil.getProtocols(url);
        String domain = UrlUtil.getDomain(url);
        return pro + "://" + domain;
    }

    public static Map<String, String> getQueryParams(String urlString) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        try {
            URL url = new URL(urlString);
            String query = url.getQuery();
            if (query != null) {
                String[] pairs;
                for (String pair : pairs = query.split("&")) {
                    int idx = pair.indexOf(61);
                    String key = URLDecoder.decode(pair.substring(0, idx), "UTF-8");
                    String value = URLDecoder.decode(pair.substring(idx + 1), "UTF-8");
                    queryParams.put(key, value);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return queryParams;
    }

    public static void main(String[] args) {
        String s = "http://2408035008.p.make.dcloud.portal1.portal.thefastmake.com";
        System.out.println(UrlUtil.getDomain(s));
    }
}

