/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.rpc.remoting.net.impl.jetty.client;

import com.xxl.rpc.remoting.invoker.XxlRpcInvokerFactory;
import com.xxl.rpc.remoting.net.Client;
import com.xxl.rpc.remoting.net.params.BaseCallback;
import com.xxl.rpc.remoting.net.params.XxlRpcRequest;
import com.xxl.rpc.remoting.net.params.XxlRpcResponse;
import com.xxl.rpc.util.ThrowableUtil;
import com.xxl.rpc.util.XxlRpcException;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.util.BufferingResponseListener;
import org.eclipse.jetty.client.util.BytesContentProvider;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.util.thread.QueuedThreadPool;

public class JettyClient
extends Client {
    private static HttpClient jettyHttpClient;

    @Override
    public void asyncSend(String address, XxlRpcRequest xxlRpcRequest) throws Exception {
        this.postRequestAsync(address, xxlRpcRequest);
    }

    private void postRequestAsync(String address, XxlRpcRequest xxlRpcRequest) throws Exception {
        String reqURL = address;
        if (!address.toLowerCase().startsWith("http")) {
            reqURL = "http://" + address;
        }
        byte[] requestBytes = this.xxlRpcReferenceBean.getSerializer().serialize(xxlRpcRequest);
        HttpClient httpClient = JettyClient.getJettyHttpClient(this.xxlRpcReferenceBean.getInvokerFactory());
        Request request = httpClient.newRequest(reqURL);
        request.method(HttpMethod.POST);
        request.timeout(this.xxlRpcReferenceBean.getTimeout() + 500L, TimeUnit.MILLISECONDS);
        request.content((ContentProvider)new BytesContentProvider((byte[][])new byte[][]{requestBytes}));
        request.send((Response.CompleteListener)new BufferingResponseListener(){

            public void onComplete(Result result) {
                try {
                    if (result.isFailed()) {
                        throw new XxlRpcException(result.getResponseFailure());
                    }
                    if (result.getResponse().getStatus() != 200) {
                        throw new XxlRpcException("xxl-rpc remoting request fail, http HttpStatus[" + result.getResponse().getStatus() + "] invalid.");
                    }
                    byte[] responseBytes = this.getContent();
                    if (responseBytes == null || responseBytes.length == 0) {
                        throw new XxlRpcException("xxl-rpc remoting request fail, response bytes is empty.");
                    }
                    XxlRpcResponse xxlRpcResponse = (XxlRpcResponse)JettyClient.this.xxlRpcReferenceBean.getSerializer().deserialize(responseBytes, XxlRpcResponse.class);
                    JettyClient.this.xxlRpcReferenceBean.getInvokerFactory().notifyInvokerFuture(xxlRpcResponse.getRequestId(), xxlRpcResponse);
                }
                catch (Exception e) {
                    if (result.getRequest().getContent() instanceof BytesContentProvider) {
                        try {
                            XxlRpcException rpcException;
                            BytesContentProvider requestCp = (BytesContentProvider)result.getRequest().getContent();
                            XxlRpcRequest requestTmp = (XxlRpcRequest)JettyClient.this.xxlRpcReferenceBean.getSerializer().deserialize(((ByteBuffer)requestCp.iterator().next()).array(), XxlRpcRequest.class);
                            String errorMsg = null;
                            errorMsg = e instanceof XxlRpcException ? ((rpcException = (XxlRpcException)e).getCause() != null ? ThrowableUtil.toString(rpcException.getCause()) : rpcException.getMessage()) : ThrowableUtil.toString(e);
                            XxlRpcResponse xxlRpcResponse = new XxlRpcResponse();
                            xxlRpcResponse.setRequestId(requestTmp.getRequestId());
                            xxlRpcResponse.setErrorMsg(errorMsg);
                            JettyClient.this.xxlRpcReferenceBean.getInvokerFactory().notifyInvokerFuture(xxlRpcResponse.getRequestId(), xxlRpcResponse);
                        }
                        catch (Exception e2) {
                            logger.info(">>>>>>>>>>> xxl-rpc, remoting request error, and callback error: " + e2.getMessage());
                            logger.info(e.getMessage(), (Throwable)e);
                        }
                    }
                    logger.info(">>>>>>>>>>> xxl-rpc, remoting request error.", (Throwable)e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpClient getJettyHttpClient(XxlRpcInvokerFactory xxlRpcInvokerFactory) throws Exception {
        if (jettyHttpClient != null) {
            return jettyHttpClient;
        }
        Class<JettyClient> clazz = JettyClient.class;
        synchronized (JettyClient.class) {
            if (jettyHttpClient != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return jettyHttpClient;
            }
            jettyHttpClient = new HttpClient();
            jettyHttpClient.setFollowRedirects(false);
            jettyHttpClient.setExecutor((Executor)new QueuedThreadPool());
            jettyHttpClient.setMaxConnectionsPerDestination(10000);
            jettyHttpClient.start();
            xxlRpcInvokerFactory.addStopCallBack(new BaseCallback(){

                @Override
                public void run() throws Exception {
                    if (jettyHttpClient != null) {
                        jettyHttpClient.stop();
                        jettyHttpClient = null;
                    }
                }
            });
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return jettyHttpClient;
        }
    }
}

