/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.rpc.remoting.net.impl.servlet.server;

import com.xxl.rpc.remoting.net.params.XxlRpcRequest;
import com.xxl.rpc.remoting.net.params.XxlRpcResponse;
import com.xxl.rpc.remoting.provider.XxlRpcProviderFactory;
import com.xxl.rpc.util.ThrowableUtil;
import com.xxl.rpc.util.XxlRpcException;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletServerHandler {
    private static Logger logger = LoggerFactory.getLogger(ServletServerHandler.class);
    private XxlRpcProviderFactory xxlRpcProviderFactory;

    public ServletServerHandler(XxlRpcProviderFactory xxlRpcProviderFactory) {
        this.xxlRpcProviderFactory = xxlRpcProviderFactory;
    }

    public void handle(String target, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if ("/services".equals(target)) {
            StringBuffer stringBuffer = new StringBuffer("<ui>");
            for (String serviceKey : this.xxlRpcProviderFactory.getServiceData().keySet()) {
                stringBuffer.append("<li>").append(serviceKey).append(": ").append(this.xxlRpcProviderFactory.getServiceData().get(serviceKey)).append("</li>");
            }
            stringBuffer.append("</ui>");
            this.writeResponse(response, stringBuffer.toString().getBytes());
            return;
        }
        XxlRpcRequest xxlRpcRequest = null;
        try {
            xxlRpcRequest = this.parseRequest(request);
        }
        catch (Exception e) {
            this.writeResponse(response, ThrowableUtil.toString(e).getBytes());
            return;
        }
        XxlRpcResponse xxlRpcResponse = this.xxlRpcProviderFactory.invokeService(xxlRpcRequest);
        byte[] responseBytes = this.xxlRpcProviderFactory.getSerializer().serialize(xxlRpcResponse);
        this.writeResponse(response, responseBytes);
    }

    private void writeResponse(HttpServletResponse response, byte[] responseBytes) throws IOException {
        response.setContentType("text/html;charset=UTF-8");
        response.setStatus(200);
        ServletOutputStream out = response.getOutputStream();
        out.write(responseBytes);
        out.flush();
    }

    private XxlRpcRequest parseRequest(HttpServletRequest request) throws Exception {
        byte[] requestBytes = ServletServerHandler.readBytes(request);
        if (requestBytes == null || requestBytes.length == 0) {
            throw new XxlRpcException("xxl-rpc request data is empty.");
        }
        XxlRpcRequest rpcXxlRpcRequest = (XxlRpcRequest)this.xxlRpcProviderFactory.getSerializer().deserialize(requestBytes, XxlRpcRequest.class);
        return rpcXxlRpcRequest;
    }

    public static final byte[] readBytes(HttpServletRequest request) throws IOException {
        request.setCharacterEncoding("UTF-8");
        int contentLen = request.getContentLength();
        ServletInputStream is = request.getInputStream();
        if (contentLen > 0) {
            int readLengthThisTime = 0;
            byte[] message = new byte[contentLen];
            try {
                for (int readLen = 0; readLen != contentLen && (readLengthThisTime = is.read(message, readLen, contentLen - readLen)) != -1; readLen += readLengthThisTime) {
                }
                return message;
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return new byte[0];
    }
}

