/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.sso.core.auth.interceptor;

import com.xxl.sso.core.annotation.XxlSso;
import com.xxl.sso.core.exception.XxlSsoException;
import com.xxl.sso.core.helper.XxlSsoHelper;
import com.xxl.sso.core.model.LoginInfo;
import com.xxl.sso.core.path.impl.AntPathMatcher;
import com.xxl.tool.core.CollectionTool;
import com.xxl.tool.core.StringTool;
import com.xxl.tool.response.Response;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class XxlSsoCasInterceptor
implements HandlerInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(XxlSsoCasInterceptor.class);
    private final AntPathMatcher antPathMatcher = new AntPathMatcher();
    private String serverAddress;
    private String loginPath;
    private String excludedPaths;

    public XxlSsoCasInterceptor(String serverAddress, String loginPath, String excludedPaths) {
        this.serverAddress = serverAddress;
        this.loginPath = loginPath;
        this.excludedPaths = excludedPaths;
        if (StringTool.isBlank((String)loginPath)) {
            this.loginPath = "/login";
        }
        if (StringTool.isBlank((String)serverAddress)) {
            throw new XxlSsoException("xxl-sso serverAddress can not be blank.");
        }
        logger.info("XxlSsoCasInterceptor init.");
    }

    private boolean isMatchExcludedPaths(HttpServletRequest request) {
        String servletPath = request.getServletPath();
        if (StringTool.isNotBlank((String)this.excludedPaths)) {
            for (String excludedPath : this.excludedPaths.split(",")) {
                String uriPattern = excludedPath.trim();
                if (StringTool.isBlank((String)uriPattern) || !this.antPathMatcher.match(uriPattern, servletPath)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String role;
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        HandlerMethod method = (HandlerMethod)handler;
        XxlSso xxlSso = (XxlSso)method.getMethodAnnotation(XxlSso.class);
        boolean needLogin = xxlSso != null ? xxlSso.login() : true;
        String permission = xxlSso != null ? xxlSso.permission() : null;
        String string = role = xxlSso != null ? xxlSso.role() : null;
        if (this.isMatchExcludedPaths(request)) {
            return true;
        }
        if (!needLogin) {
            return true;
        }
        Response<LoginInfo> loginCheckResult = XxlSsoHelper.loginCheckWithCookie(request, response);
        if (loginCheckResult == null || !loginCheckResult.isSuccess()) {
            loginCheckResult = XxlSsoHelper.validTicket(request, response);
        }
        LoginInfo loginInfo = null;
        if (loginCheckResult != null && loginCheckResult.isSuccess()) {
            loginInfo = (LoginInfo)loginCheckResult.getData();
        }
        if (loginInfo == null) {
            boolean isJson;
            boolean bl = isJson = method.getMethodAnnotation(ResponseBody.class) != null;
            if (isJson) {
                throw new XxlSsoException(501, "not login for path:" + request.getServletPath());
            }
            String originUrl = request.getRequestURL().toString();
            String finalLoginPath = this.serverAddress.concat(this.loginPath).concat("?").concat("redirect_url").concat("=").concat(originUrl);
            response.sendRedirect(finalLoginPath);
            return false;
        }
        request.setAttribute("xxl_sso_user", loginInfo);
        if (StringTool.isNotBlank((String)permission) && !CollectionTool.contains(loginInfo.getPermissionList(), (Object)permission)) {
            throw new XxlSsoException("permission limit, current login-user does not have permission:" + permission);
        }
        if (StringTool.isNotBlank((String)role) && !CollectionTool.contains(loginInfo.getRoleList(), (Object)role)) {
            throw new XxlSsoException("permission limit, current login-user does not have role:" + role);
        }
        return true;
    }
}

