/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.web;

import de.codecentric.boot.admin.server.domain.entities.Application;
import de.codecentric.boot.admin.server.services.ApplicationRegistry;
import de.codecentric.boot.admin.server.web.AdminController;
import de.codecentric.boot.admin.server.web.client.RefreshInstancesEvent;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.ResponseEntity;
import org.springframework.http.codec.ServerSentEvent;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@AdminController
@ResponseBody
public class ApplicationsController {
    private static final Logger log = LoggerFactory.getLogger(ApplicationsController.class);
    private static final ServerSentEvent<?> PING = ServerSentEvent.builder().comment("ping").build();
    private static final Flux<ServerSentEvent<?>> PING_FLUX = Flux.interval((Duration)Duration.ZERO, (Duration)Duration.ofSeconds(10L)).map(tick -> PING);
    private final ApplicationRegistry registry;
    private final ApplicationEventPublisher publisher;

    public ApplicationsController(ApplicationRegistry registry, ApplicationEventPublisher publisher) {
        this.registry = registry;
        this.publisher = publisher;
    }

    @GetMapping(path={"/applications"}, produces={"application/json"})
    public Flux<Application> applications() {
        return this.registry.getApplications();
    }

    @PostMapping(path={"/applications"}, produces={"application/json"})
    public void refreshApplications() {
        this.publisher.publishEvent((ApplicationEvent)new RefreshInstancesEvent(this));
    }

    @GetMapping(path={"/applications/{name}"}, produces={"application/json"})
    public Mono<ResponseEntity<Application>> application(@PathVariable(value="name") String name) {
        return this.registry.getApplication(name).map(ResponseEntity::ok).defaultIfEmpty((Object)ResponseEntity.notFound().build());
    }

    @GetMapping(path={"/applications"}, produces={"text/event-stream"})
    public Flux<ServerSentEvent<Application>> applicationsStream() {
        return this.registry.getApplicationStream().map(application -> ServerSentEvent.builder((Object)application).build()).mergeWith(ApplicationsController.ping());
    }

    @DeleteMapping(path={"/applications/{name}"})
    public Mono<ResponseEntity<Void>> unregister(@PathVariable(value="name") String name) {
        log.debug("Unregister application with name '{}'", (Object)name);
        return this.registry.deregister(name).collectList().map(deregistered -> !deregistered.isEmpty() ? ResponseEntity.noContent().build() : ResponseEntity.notFound().build());
    }

    private static <T> Flux<ServerSentEvent<T>> ping() {
        return PING_FLUX;
    }
}

