/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.jtb.misc;

import EDU.purdue.jtb.misc.Errors;
import EDU.purdue.jtb.misc.Globals;
import java.util.Hashtable;

public class FieldNameGenerator {
    private int fieldNum = 0;
    private Hashtable nameTable;

    public FieldNameGenerator() {
        if (Globals.descriptiveFieldNames) {
            this.nameTable = new Hashtable();
        }
    }

    public void resetFieldNum() {
        this.fieldNum = 0;
        if (Globals.descriptiveFieldNames) {
            this.nameTable.clear();
        }
    }

    public String curFieldName(String fieldName) {
        if (!Globals.descriptiveFieldNames) {
            return "f" + String.valueOf(this.fieldNum++);
        }
        String prefix = this.varNameForClass(fieldName);
        Integer suffix = (Integer)this.nameTable.get(prefix);
        if (suffix == null) {
            suffix = new Integer(0);
            this.nameTable.put(prefix, suffix);
            return prefix;
        }
        suffix = new Integer(suffix + 1);
        this.nameTable.put(prefix, suffix);
        return prefix + suffix.toString();
    }

    public String varNameForClass(String className) {
        StringBuffer buf = new StringBuffer(String.valueOf(Character.toLowerCase(className.charAt(0))));
        buf.append(className.substring(1, className.length()));
        return buf.toString();
    }

    public String getNameForMod(String mod) {
        if (mod.equals("+")) {
            return "NodeList";
        }
        if (mod.equals("*")) {
            return "NodeListOptional";
        }
        if (mod.equals("?")) {
            return "NodeOptional";
        }
        Errors.hardErr("Illegal EBNF modifier in ExpansionUnit: mod = " + mod);
        return "";
    }
}

