/*
 * Decompiled with CFR 0.152.
 */
package io.apimatic.core.types.pagination;

import io.apimatic.core.HttpRequest;
import io.apimatic.core.types.pagination.PageWrapper;
import io.apimatic.core.types.pagination.PaginatedData;
import io.apimatic.core.types.pagination.PaginationStrategy;
import io.apimatic.coreinterfaces.http.response.Response;
import java.util.concurrent.atomic.AtomicBoolean;

public class PagePagination
implements PaginationStrategy {
    private final String input;
    private int currentRequestPageNumber;

    public PagePagination(String input) {
        this.input = input;
    }

    @Override
    public HttpRequest.Builder apply(PaginatedData<?, ?, ?, ?> paginatedData) {
        Response response = paginatedData.getResponse();
        HttpRequest.Builder reqBuilder = paginatedData.getRequestBuilder();
        AtomicBoolean isUpdated = new AtomicBoolean(false);
        this.currentRequestPageNumber = 0;
        reqBuilder.updateParameterByJsonPointer(this.input, old -> {
            int newValue;
            int oldValue;
            int n = oldValue = old == null ? 1 : Integer.parseInt("" + old);
            if (response == null) {
                this.currentRequestPageNumber = oldValue;
                isUpdated.set(true);
                return old;
            }
            this.currentRequestPageNumber = newValue = oldValue + 1;
            isUpdated.set(true);
            return newValue;
        });
        if (!isUpdated.get() && response == null) {
            return reqBuilder;
        }
        return isUpdated.get() ? reqBuilder : null;
    }

    @Override
    public void addMetaData(PageWrapper<?, ?> page) {
        page.setPageInput(this.currentRequestPageNumber);
    }
}

