/*
 * Decompiled with CFR 0.152.
 */
package io.apimatic.okhttpclient.adapter;

import io.apimatic.coreinterfaces.compatibility.CompatibilityFactory;
import io.apimatic.coreinterfaces.http.ClientConfiguration;
import io.apimatic.coreinterfaces.http.HttpClient;
import io.apimatic.coreinterfaces.http.HttpHeaders;
import io.apimatic.coreinterfaces.http.Method;
import io.apimatic.coreinterfaces.http.proxy.ProxyConfiguration;
import io.apimatic.coreinterfaces.http.request.Multipart;
import io.apimatic.coreinterfaces.http.request.MultipartFile;
import io.apimatic.coreinterfaces.http.request.configuration.CoreEndpointConfiguration;
import io.apimatic.coreinterfaces.http.response.Response;
import io.apimatic.coreinterfaces.type.CoreFileWrapper;
import io.apimatic.okhttpclient.adapter.interceptors.HttpRedirectInterceptor;
import io.apimatic.okhttpclient.adapter.interceptors.RetryInterceptor;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Authenticator;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Credentials;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;

public class OkClient
implements HttpClient {
    private static final Object SYNC_OBJECT = new Object();
    private static volatile OkHttpClient defaultOkHttpClient;
    private static OkHttpClient insecureOkHttpClient;
    private OkHttpClient client;
    private static CompatibilityFactory compatibilityFactory;

    public OkClient(ClientConfiguration httpClientConfig, CompatibilityFactory compatibilityFactory) {
        OkClient.compatibilityFactory = compatibilityFactory;
        OkHttpClient httpClientInstance = httpClientConfig.getHttpClientInstance();
        if (httpClientInstance != null) {
            if (httpClientConfig.shouldOverrideHttpClientConfigurations()) {
                this.applyHttpClientConfigurations(httpClientInstance, httpClientConfig);
            } else {
                this.client = httpClientInstance;
            }
        } else if (httpClientConfig.skipSslCertVerification()) {
            this.applyHttpClientConfigurations(this.getInsecureOkHttpClient(httpClientConfig), httpClientConfig);
        } else {
            this.applyHttpClientConfigurations(this.getDefaultOkHttpClient(), httpClientConfig);
        }
    }

    private void applyHttpClientConfigurations(OkHttpClient okHttpClient, ClientConfiguration httpClientConfig) {
        OkHttpClient.Builder clientBuilder = okHttpClient.newBuilder();
        clientBuilder.readTimeout(httpClientConfig.getTimeout(), TimeUnit.SECONDS).writeTimeout(httpClientConfig.getTimeout(), TimeUnit.SECONDS).connectTimeout(httpClientConfig.getTimeout(), TimeUnit.SECONDS);
        clientBuilder.addInterceptor((Interceptor)new HttpRedirectInterceptor(true));
        if (httpClientConfig.getNumberOfRetries() > 0) {
            clientBuilder.callTimeout(httpClientConfig.getMaximumRetryWaitTime(), TimeUnit.SECONDS).addInterceptor((Interceptor)new RetryInterceptor(httpClientConfig));
        } else {
            clientBuilder.callTimeout(httpClientConfig.getTimeout(), TimeUnit.SECONDS);
        }
        ProxyConfiguration proxy = httpClientConfig.getProxyConfiguration();
        if (proxy != null) {
            clientBuilder.proxy(OkClient.buildProxy(proxy));
            if (proxy.getUsername() != null || proxy.getPassword() != null) {
                clientBuilder.proxyAuthenticator(OkClient.buildProxyAuthenticator(proxy.getUsername(), proxy.getPassword()));
            }
        }
        this.client = clientBuilder.build();
    }

    private static Proxy buildProxy(ProxyConfiguration proxyConfiguration) {
        return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyConfiguration.getAddress(), proxyConfiguration.getPort()));
    }

    public static Authenticator buildProxyAuthenticator(String username, String password) {
        return (route, response) -> {
            if (response.request().header("Proxy-Authorization") != null) {
                return null;
            }
            String credential = Credentials.basic((String)username, (String)password);
            return response.request().newBuilder().header("Proxy-Authorization", credential).build();
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OkHttpClient getInsecureOkHttpClient(ClientConfiguration httpClientConfiguration) {
        if (insecureOkHttpClient == null) {
            Object object = SYNC_OBJECT;
            synchronized (object) {
                if (insecureOkHttpClient == null) {
                    insecureOkHttpClient = OkClient.createInsecureOkHttpClient(httpClientConfiguration);
                }
            }
        }
        return insecureOkHttpClient;
    }

    private static OkHttpClient createInsecureOkHttpClient(ClientConfiguration httpClientConfiguration) {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }};
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            return new OkHttpClient().newBuilder().sslSocketFactory(sslSocketFactory, (X509TrustManager)trustAllCerts[0]).hostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            }).retryOnConnectionFailure(true).callTimeout(httpClientConfiguration.getTimeout(), TimeUnit.SECONDS).build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OkHttpClient getDefaultOkHttpClient() {
        if (defaultOkHttpClient == null) {
            Object object = SYNC_OBJECT;
            synchronized (object) {
                if (defaultOkHttpClient == null) {
                    defaultOkHttpClient = new OkHttpClient.Builder().retryOnConnectionFailure(true).callTimeout(0L, TimeUnit.SECONDS).build();
                }
            }
        }
        return defaultOkHttpClient;
    }

    public static void shutdown() {
        if (defaultOkHttpClient != null) {
            defaultOkHttpClient.dispatcher().executorService().shutdown();
            defaultOkHttpClient.connectionPool().evictAll();
        }
        if (insecureOkHttpClient != null) {
            insecureOkHttpClient.dispatcher().executorService().shutdown();
            insecureOkHttpClient.connectionPool().evictAll();
        }
    }

    public CompletableFuture<Response> executeAsync(final io.apimatic.coreinterfaces.http.request.Request httpRequest, final CoreEndpointConfiguration endpointConfiguration) {
        Request okHttpRequest = this.convertRequest(httpRequest);
        RetryInterceptor retryInterceptor = this.getRetryInterceptor();
        if (retryInterceptor != null) {
            retryInterceptor.addRequestEntry(okHttpRequest, endpointConfiguration, httpRequest);
        }
        final CompletableFuture<Response> callBack = new CompletableFuture<Response>();
        this.client.newCall(okHttpRequest).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                OkClient.this.publishResponse(null, httpRequest, callBack, e, endpointConfiguration.hasBinaryResponse());
            }

            public void onResponse(Call call, okhttp3.Response okHttpResponse) {
                OkClient.this.publishResponse(okHttpResponse, httpRequest, callBack, null, endpointConfiguration.hasBinaryResponse());
            }
        });
        return callBack;
    }

    public Response execute(io.apimatic.coreinterfaces.http.request.Request httpRequest, CoreEndpointConfiguration endpointConfiguration) throws IOException {
        Request okHttpRequest = this.convertRequest(httpRequest);
        RetryInterceptor retryInterceptor = this.getRetryInterceptor();
        if (retryInterceptor != null) {
            retryInterceptor.addRequestEntry(okHttpRequest, endpointConfiguration, httpRequest);
        }
        okhttp3.Response okHttpResponse = this.client.newCall(okHttpRequest).execute();
        return OkClient.convertResponse(httpRequest, okHttpResponse, endpointConfiguration.hasBinaryResponse());
    }

    private RetryInterceptor getRetryInterceptor() {
        return this.client.interceptors().stream().filter(interceptor -> interceptor instanceof RetryInterceptor).findFirst().orElse(null);
    }

    private Response publishResponse(okhttp3.Response okHttpResponse, io.apimatic.coreinterfaces.http.request.Request httpRequest, CompletableFuture<Response> completionBlock, Throwable error, boolean hasBinaryResponse) {
        Response httpResponse = null;
        try {
            httpResponse = OkClient.convertResponse(httpRequest, okHttpResponse, hasBinaryResponse);
            if (error == null && httpResponse != null) {
                completionBlock.complete(httpResponse);
            } else {
                completionBlock.completeExceptionally(error);
            }
        }
        catch (IOException e) {
            completionBlock.completeExceptionally(e);
        }
        return httpResponse;
    }

    public static Response convertResponse(io.apimatic.coreinterfaces.http.request.Request request, okhttp3.Response response, boolean hasBinaryResponse) throws IOException {
        Response httpResponse = null;
        if (response != null) {
            ResponseBody responseBody = response.body();
            HttpHeaders headers = compatibilityFactory.createHttpHeaders(response.headers().toMultimap());
            if (hasBinaryResponse) {
                InputStream responseStream = responseBody.byteStream();
                httpResponse = compatibilityFactory.createHttpResponse(response.code(), headers, responseStream);
            } else {
                String responseString = responseBody.string();
                ByteArrayInputStream responseStream = new ByteArrayInputStream(responseString.getBytes());
                httpResponse = compatibilityFactory.createHttpResponse(response.code(), headers, (InputStream)responseStream, responseString);
                responseBody.close();
                response.close();
            }
        }
        return httpResponse;
    }

    private Request convertRequest(io.apimatic.coreinterfaces.http.request.Request httpRequest) {
        RequestBody requestBody;
        if (httpRequest.getBody() != null) {
            String contentType;
            Object body = httpRequest.getBody();
            if (body instanceof CoreFileWrapper) {
                CoreFileWrapper file = (CoreFileWrapper)body;
                if (file.getContentType() != null && !file.getContentType().isEmpty()) {
                    contentType = file.getContentType();
                    httpRequest.getHeaders().add("content-type", contentType);
                } else if (httpRequest.getHeaders().has("content-type")) {
                    contentType = httpRequest.getHeaders().value("content-type");
                } else {
                    contentType = "application/octet-stream";
                    httpRequest.getHeaders().add("content-type", contentType);
                }
                requestBody = RequestBody.create((File)file.getFile(), (MediaType)MediaType.parse((String)contentType));
            } else {
                if (!httpRequest.getHeaders().has("content-type")) {
                    httpRequest.getHeaders().add("content-type", "application/json; charset=UTF-8");
                }
                contentType = httpRequest.getHeaders().value("content-type");
                requestBody = RequestBody.create((byte[])((String)body).getBytes(), (MediaType)MediaType.parse((String)contentType));
            }
        } else {
            List parameters = httpRequest.getParameters();
            boolean multipartRequest = false;
            if (parameters != null && parameters.size() > 0) {
                for (AbstractMap.SimpleEntry param : parameters) {
                    if (!(param.getValue() instanceof MultipartFile) && !(param.getValue() instanceof Multipart)) continue;
                    multipartRequest = true;
                    break;
                }
                if (multipartRequest) {
                    requestBody = this.createMultipartRequestBody(httpRequest);
                } else {
                    FormBody.Builder formBuilder = new FormBody.Builder();
                    for (AbstractMap.SimpleEntry param : parameters) {
                        formBuilder.add((String)param.getKey(), param.getValue() == null ? "" : param.getValue().toString());
                    }
                    requestBody = formBuilder.build();
                }
            } else {
                requestBody = httpRequest.getHttpMethod().toString().equals(Method.GET.toString()) ? null : RequestBody.create((byte[])new byte[0], null);
            }
        }
        Headers.Builder requestHeaders = new Headers.Builder();
        if (httpRequest.getHeaders() != null) {
            requestHeaders = OkClient.createRequestHeaders(httpRequest.getHeaders());
        }
        Request okHttpRequest = new Request.Builder().method(httpRequest.getHttpMethod().toString(), requestBody).headers(requestHeaders.build()).url(httpRequest.getQueryUrl()).build();
        return okHttpRequest;
    }

    private RequestBody createMultipartRequestBody(io.apimatic.coreinterfaces.http.request.Request httpRequest) {
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        for (AbstractMap.SimpleEntry param : httpRequest.getParameters()) {
            if (param.getValue() instanceof MultipartFile) {
                MultipartFile wrapperObj = (MultipartFile)param.getValue();
                MediaType mediaType = wrapperObj.getFileWrapper().getContentType() != null && !wrapperObj.getFileWrapper().getContentType().isEmpty() ? MediaType.parse((String)wrapperObj.getFileWrapper().getContentType()) : MediaType.parse((String)wrapperObj.getHeaders().value("content-type"));
                RequestBody body = RequestBody.create((File)wrapperObj.getFileWrapper().getFile(), (MediaType)mediaType);
                HttpHeaders fileWrapperHeaders = compatibilityFactory.createHttpHeaders(wrapperObj.getHeaders());
                fileWrapperHeaders.remove("content-type");
                Headers.Builder fileWrapperHeadersBuilder = OkClient.createRequestHeaders(fileWrapperHeaders);
                fileWrapperHeadersBuilder.add("Content-Disposition", "form-data; name=" + OkClient.appendQuotedStringAndEncodeEscapeCharacters((String)param.getKey()) + "; filename=" + OkClient.appendQuotedStringAndEncodeEscapeCharacters(wrapperObj.getFileWrapper().getFile().getName()));
                multipartBuilder.addPart(fileWrapperHeadersBuilder.build(), body);
                continue;
            }
            if (param.getValue() instanceof Multipart) {
                Multipart wrapperObject = (Multipart)param.getValue();
                RequestBody body = RequestBody.create((byte[])wrapperObject.getByteArray(), (MediaType)MediaType.parse((String)wrapperObject.getHeaders().value("content-type")));
                HttpHeaders wrapperHeaders = compatibilityFactory.createHttpHeaders(wrapperObject.getHeaders());
                wrapperHeaders.remove("content-type");
                Headers.Builder wrapperHeadersBuilder = OkClient.createRequestHeaders(wrapperHeaders);
                wrapperHeadersBuilder.add("Content-Disposition", "form-data; name=" + OkClient.appendQuotedStringAndEncodeEscapeCharacters((String)param.getKey()));
                multipartBuilder.addPart(wrapperHeadersBuilder.build(), body);
                continue;
            }
            multipartBuilder.addFormDataPart((String)param.getKey(), param.getValue() == null ? "" : param.getValue().toString());
        }
        return multipartBuilder.build();
    }

    private static Headers.Builder createRequestHeaders(HttpHeaders headers) {
        Headers.Builder requestHeaders = new Headers.Builder();
        for (Map.Entry kv : headers.asMultimap().entrySet()) {
            for (String value : (List)kv.getValue()) {
                requestHeaders.add((String)kv.getKey(), value);
            }
        }
        return requestHeaders;
    }

    private static String appendQuotedStringAndEncodeEscapeCharacters(String key) {
        String target = "\"";
        int len = key.length();
        block5: for (int i = 0; i < len; ++i) {
            char ch = key.charAt(i);
            switch (ch) {
                case '\n': {
                    target = target + "%0A";
                    continue block5;
                }
                case '\r': {
                    target = target + "%0D";
                    continue block5;
                }
                case '\"': {
                    target = target + "%22";
                    continue block5;
                }
                default: {
                    target = target + ch;
                }
            }
        }
        target = target + '\"';
        return target;
    }
}

