/*
 * Decompiled with CFR 0.152.
 */
package com.benjaminwan.ocrlibrary;

import com.benjaminwan.ocrlibrary.OcrResult;
import io.github.mymonstercat.Model;
import io.github.mymonstercat.ocr.config.HardwareConfig;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OcrEngine {
    private static final Logger log = LoggerFactory.getLogger(OcrEngine.class);
    private volatile boolean isInit = false;
    private String inferType;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initEngine(Model model, HardwareConfig hardwareConfig) {
        if (!this.isInit) {
            OcrEngine ocrEngine = this;
            synchronized (ocrEngine) {
                if (!this.isInit) {
                    this.initLogger(false, false, false);
                    this.setNumThread(hardwareConfig.getNumThread());
                    if (hardwareConfig.getGpuIndex() != -1) {
                        this.setGpuIndex(hardwareConfig.getGpuIndex());
                    }
                    if (!this.initModels(model.getTempDirPath(), model.getDetName(), model.getClsName(), model.getRecName(), model.getKeysName())) {
                        throw new IllegalArgumentException("\u6a21\u578b\u521d\u59cb\u5316\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5models/keys\u8def\u5f84\uff01");
                    }
                    this.inferType = model.getModelType();
                    log.info("\u63a8\u7406\u5f15\u64ce\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u5f53\u524d\u4f7f\u7528\u7684\u63a8\u7406\u5f15\u64ce\u4e3a\uff1a{}-v{}", (Object)this.inferType, (Object)this.getVersion());
                    log.info("\u521d\u59cb\u5316\u65f6\u6a21\u578b\u914d\u7f6e\u4e3a\uff1a{}\uff0c \u786c\u4ef6\u914d\u7f6e\u4e3a\uff1a{}", (Object)model, (Object)hardwareConfig);
                    this.isInit = true;
                }
            }
        } else if (!Objects.equals(model.getModelType(), this.inferType)) {
            log.warn("\u5f15\u64ce\u5df2\u521d\u59cb\u5316\uff0c\u521d\u59cb\u5316\u540e\u4e0d\u53ef\u66f4\u6362\u4e3a\u5176\u4ed6\u5f15\u64ce\uff0c\u5c06\u7ee7\u7eed\u4f7f\u7528{}\u63a8\u7406\u5f15\u64ce\u5de5\u4f5c", (Object)this.inferType);
        } else {
            log.info("\u5f53\u524d\u4f7f\u7528\u7684\u63a8\u7406\u5f15\u64ce\u4e3a\uff1a{}-v{}", (Object)this.inferType, (Object)this.getVersion());
        }
    }

    public native boolean setNumThread(int var1);

    public native void initLogger(boolean var1, boolean var2, boolean var3);

    public native void enableResultText(String var1);

    public native boolean initModels(String var1, String var2, String var3, String var4, String var5);

    public native void setGpuIndex(int var1);

    public native String getVersion();

    public native OcrResult detect(String var1, int var2, int var3, float var4, float var5, float var6, boolean var7, boolean var8);
}

