/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.connector.internal;

import io.gravitee.plugin.connector.ConnectorPlugin;
import io.gravitee.plugin.connector.internal.ConnectorConfigurationClassFinder;
import io.gravitee.plugin.connector.internal.ConnectorPluginImpl;
import io.gravitee.plugin.core.api.AbstractSimplePluginHandler;
import io.gravitee.plugin.core.api.ConfigurablePluginManager;
import io.gravitee.plugin.core.api.Plugin;
import java.io.IOException;
import java.net.URLClassLoader;
import org.springframework.beans.factory.annotation.Autowired;

public class ConnectorPluginHandler
extends AbstractSimplePluginHandler<ConnectorPlugin> {
    @Autowired
    private ConfigurablePluginManager<ConnectorPlugin> connectorPluginManager;

    public boolean canHandle(Plugin plugin) {
        return "connector".equalsIgnoreCase(plugin.type());
    }

    protected String type() {
        return "connectors";
    }

    protected ConnectorPlugin create(Plugin plugin, Class<?> pluginClass) {
        ConnectorPluginImpl policyPlugin = new ConnectorPluginImpl(plugin, pluginClass);
        policyPlugin.setConfiguration(new ConnectorConfigurationClassFinder().lookupFirst(pluginClass));
        return policyPlugin;
    }

    protected void register(ConnectorPlugin policyPlugin) {
        this.connectorPluginManager.register((Plugin)policyPlugin);
        URLClassLoader classLoader = (URLClassLoader)policyPlugin.connector().getClassLoader();
        try {
            classLoader.close();
        }
        catch (IOException e) {
            this.logger.error("Unexpected exception while trying to release the policy classloader");
        }
    }

    protected ClassLoader getClassLoader(Plugin plugin) {
        return new URLClassLoader(plugin.dependencies(), ((Object)((Object)this)).getClass().getClassLoader());
    }
}

