/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.collection;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import lombok.NonNull;

public class RenameCollectionParam {
    private final String oldDatabaseName;
    private final String newDatabaseName;
    private final String oldCollectionName;
    private final String newCollectionName;

    public RenameCollectionParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.oldDatabaseName = builder.oldDatabaseName;
        this.newDatabaseName = builder.newDatabaseName;
        this.oldCollectionName = builder.oldCollectionName;
        this.newCollectionName = builder.newCollectionName;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getOldDatabaseName() {
        return this.oldDatabaseName;
    }

    public String getNewDatabaseName() {
        return this.newDatabaseName;
    }

    public String getOldCollectionName() {
        return this.oldCollectionName;
    }

    public String getNewCollectionName() {
        return this.newCollectionName;
    }

    public String toString() {
        return "RenameCollectionParam(oldDatabaseName=" + this.getOldDatabaseName() + ", newDatabaseName=" + this.getNewDatabaseName() + ", oldCollectionName=" + this.getOldCollectionName() + ", newCollectionName=" + this.getNewCollectionName() + ")";
    }

    public static final class Builder {
        private String oldDatabaseName;
        private String newDatabaseName;
        private String oldCollectionName;
        private String newCollectionName;

        private Builder() {
        }

        public Builder withOldDatabaseName(String databaseName) {
            this.oldDatabaseName = databaseName;
            return this;
        }

        public Builder withNewDatabaseName(String databaseName) {
            this.newDatabaseName = databaseName;
            return this;
        }

        public Builder withOldCollectionName(@NonNull String oldCollectionName) {
            if (oldCollectionName == null) {
                throw new NullPointerException("oldCollectionName is marked non-null but is null");
            }
            this.oldCollectionName = oldCollectionName;
            return this;
        }

        public Builder withNewCollectionName(@NonNull String newCollectionName) {
            if (newCollectionName == null) {
                throw new NullPointerException("newCollectionName is marked non-null but is null");
            }
            this.newCollectionName = newCollectionName;
            return this;
        }

        public RenameCollectionParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.oldCollectionName, "Old collection name");
            ParamUtils.CheckNullEmptyString(this.newCollectionName, "New collection name");
            return new RenameCollectionParam(this);
        }
    }
}

