/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.role;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import lombok.NonNull;

public class AddUserToRoleParam {
    private final String userName;
    private final String roleName;

    private AddUserToRoleParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.userName = builder.userName;
        this.roleName = builder.roleName;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getUserName() {
        return this.userName;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public String toString() {
        return "AddUserToRoleParam(userName=" + this.getUserName() + ", roleName=" + this.getRoleName() + ")";
    }

    public static final class Builder {
        private String userName;
        private String roleName;

        private Builder() {
        }

        public Builder withUserName(@NonNull String userName) {
            if (userName == null) {
                throw new NullPointerException("userName is marked non-null but is null");
            }
            this.userName = userName;
            return this;
        }

        public Builder withRoleName(@NonNull String roleName) {
            if (roleName == null) {
                throw new NullPointerException("roleName is marked non-null but is null");
            }
            this.roleName = roleName;
            return this;
        }

        public AddUserToRoleParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.userName, "UserName");
            ParamUtils.CheckNullEmptyString(this.roleName, "RoleName");
            return new AddUserToRoleParam(this);
        }
    }
}

