/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.cloud.hystrix;

import com.netflix.hystrix.HystrixCommand;
import feign.opentracing.hystrix.TracingConcurrencyStrategy;
import io.opentracing.Tracer;
import io.opentracing.contrib.spring.tracer.configuration.TracerAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={HystrixCommand.class})
@ConditionalOnBean(value={Tracer.class})
@AutoConfigureAfter(value={TracerAutoConfiguration.class})
@ConditionalOnProperty(name={"opentracing.spring.cloud.hystrix.strategy.enabled"}, matchIfMissing=true)
public class HystrixTracingAutoConfiguration {
    @Bean
    TracingConcurrencyStrategy hystrixTracingConcurrencyStrategy(Tracer tracer) {
        return TracingConcurrencyStrategy.register((Tracer)tracer);
    }
}

