/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.captcha;

import java.util.concurrent.ThreadLocalRandom;
import net.dreamlu.mica.captcha.Captcha;
import net.dreamlu.mica.captcha.CaptchaUtils;
import net.dreamlu.mica.core.utils.Base64Util;
import net.dreamlu.mica.core.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;

public abstract class BaseCaptcha {
    private static final Logger log = LoggerFactory.getLogger(BaseCaptcha.class);
    protected static final String DEFAULT_COOKIE_NAME = "mica-captcha";
    protected static final String DEFAULT_CHACHE_NAME = "micaCaptchaCache";
    protected static final int DEFAULT_MAX_AGE = -1;
    private String cacheName = "micaCaptchaCache";
    private String cookieName = "mica-captcha";
    protected Cache captchaCache;

    public BaseCaptcha(Cache captchaCache) {
        this.captchaCache = captchaCache;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public void setCookieName(String cookieName) {
        this.cookieName = cookieName;
    }

    protected HttpHeaders getResponseHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setPragma("no-cache");
        headers.setCacheControl("no-cache");
        headers.setExpires(0L);
        headers.setContentType(MediaType.IMAGE_JPEG);
        return headers;
    }

    public Captcha generateBase64() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        String captchaCode = CaptchaUtils.generateCode(random).toUpperCase();
        byte[] imgBytes = CaptchaUtils.generate(random, captchaCode);
        String base64 = Base64Util.encodeToString((byte[])imgBytes);
        String uuid = StringUtil.getUUID();
        this.captchaCache.put((Object)uuid, (Object)captchaCode);
        return new Captcha(uuid, base64);
    }

    public boolean validateBase64(String uuid, String userInputCaptcha) {
        String captchaCode;
        if (log.isInfoEnabled()) {
            log.info("validate captcha userInputCaptcha is {}", (Object)userInputCaptcha);
        }
        if (StringUtil.isBlank((CharSequence)(captchaCode = (String)this.captchaCache.get((Object)uuid, String.class)))) {
            return false;
        }
        boolean result = (userInputCaptcha = userInputCaptcha.toUpperCase()).equals(captchaCode);
        if (result) {
            this.captchaCache.evict((Object)uuid);
        }
        return result;
    }
}

