/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.captcha;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.QuadCurve2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.OutputStream;
import java.util.Random;
import javax.imageio.ImageIO;
import org.springframework.util.FastByteArrayOutputStream;

public class CaptchaUtils {
    protected static final int WIDTH = 108;
    protected static final int HEIGHT = 40;
    protected static final int CODE_SIZE = 4;
    protected static final char[] CHAR_ARRAY = "3456789ABCDEFGHJKMNPQRSTUVWXY".toCharArray();
    protected static final Font[] RANDOM_FONT = new Font[]{new Font("Dialog", 1, 33), new Font("DialogInput", 1, 34), new Font("Serif", 1, 33), new Font("SansSerif", 1, 34), new Font("Monospaced", 1, 34)};

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] generate(Random random, String vCode) {
        BufferedImage image = new BufferedImage(108, 40, 1);
        try (FastByteArrayOutputStream baos = new FastByteArrayOutputStream();){
            CaptchaUtils.drawGraphic(image, random, vCode);
            ImageIO.write((RenderedImage)image, "JPEG", (OutputStream)baos);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String generateCode(Random random) {
        int count = 4;
        char[] buffer = new char[count];
        for (int i = 0; i < count; ++i) {
            buffer[i] = CHAR_ARRAY[random.nextInt(CHAR_ARRAY.length)];
        }
        return new String(buffer);
    }

    protected static void drawGraphic(BufferedImage image, Random random, String code) {
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setColor(CaptchaUtils.getRandColor(random, 210, 250));
        g.fillRect(0, 0, 108, 40);
        int charCount = 20;
        Color color = null;
        for (int i = 0; i < charCount; ++i) {
            color = CaptchaUtils.getRandColor(random, 120, 200);
            g.setColor(color);
            String rand = String.valueOf(CHAR_ARRAY[random.nextInt(CHAR_ARRAY.length)]);
            g.drawString(rand, random.nextInt(108), random.nextInt(40));
            color = null;
        }
        char[] buffer = code.toCharArray();
        for (int i = 0; i < buffer.length; ++i) {
            char xcode = buffer[i];
            int degree = random.nextInt(28);
            if (i % 2 == 0) {
                degree *= -1;
            }
            int x = 22 * i;
            int y = 21;
            g.rotate(Math.toRadians(degree), x, y);
            color = CaptchaUtils.getRandColor(random, 20, 130);
            g.setColor(color);
            g.setFont(RANDOM_FONT[random.nextInt(RANDOM_FONT.length)]);
            g.drawString("" + xcode, x + 8, y + 10);
            g.rotate(-Math.toRadians(degree), x, y);
        }
        g.setColor(color);
        BasicStroke bs = new BasicStroke(3.0f);
        g.setStroke(bs);
        QuadCurve2D.Double curve = new QuadCurve2D.Double(0.0, random.nextInt(32) + 4, 54.0, 20.0, 108.0, random.nextInt(32) + 4);
        g.draw(curve);
        g.dispose();
    }

    private static Color getRandColor(Random random, int fc, int bc) {
        int colorMax = 255;
        if (fc > colorMax) {
            fc = 255;
        }
        if (bc > colorMax) {
            bc = 255;
        }
        int r = fc + random.nextInt(bc - fc);
        int g = fc + random.nextInt(bc - fc);
        int b = fc + random.nextInt(bc - fc);
        return new Color(r, g, b);
    }
}

