/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.captcha.reactive;

import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import net.dreamlu.mica.captcha.BaseCaptcha;
import net.dreamlu.mica.captcha.CaptchaUtils;
import net.dreamlu.mica.core.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseCookie;
import org.springframework.http.ResponseEntity;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;

public class MicaCaptchaReactive
extends BaseCaptcha {
    private static final Logger log = LoggerFactory.getLogger(MicaCaptchaReactive.class);

    public MicaCaptchaReactive(Cache captchaCache) {
        super(captchaCache);
    }

    public ResponseEntity<Resource> generate(ServerWebExchange exchange) {
        byte[] bytes = this.generateByteArray(exchange);
        ByteArrayResource resource = new ByteArrayResource(bytes);
        return new ResponseEntity((Object)resource, (MultiValueMap)this.getResponseHeaders(), HttpStatus.OK);
    }

    public byte[] generateByteArray(ServerWebExchange exchange) {
        ServerHttpRequest request = exchange.getRequest();
        ServerHttpResponse response = exchange.getResponse();
        String cookieName = this.getCookieName();
        String cookieValue = Optional.of(request.getCookies()).map(x -> (HttpCookie)x.getFirst((Object)cookieName)).map(HttpCookie::getValue).orElseGet(() -> {
            String cookieValueUUID = StringUtil.getUUID();
            ResponseCookie cookie = ResponseCookie.from((String)cookieName, (String)cookieValueUUID).maxAge(-1L).path("/").build();
            response.addCookie(cookie);
            return cookieValueUUID;
        });
        ThreadLocalRandom random = ThreadLocalRandom.current();
        String captchaCode = CaptchaUtils.generateCode(random).toUpperCase();
        this.captchaCache.put((Object)cookieValue, (Object)captchaCode);
        return CaptchaUtils.generate(random, captchaCode);
    }

    public boolean validate(ServerWebExchange exchange, String userInputCaptcha) {
        if (log.isInfoEnabled()) {
            log.info("validate captcha userInputCaptcha is {}", (Object)userInputCaptcha);
        }
        ServerHttpRequest request = exchange.getRequest();
        ServerHttpResponse response = exchange.getResponse();
        String cookieName = this.getCookieName();
        String cookieValue = Optional.of(request.getCookies()).map(x -> (HttpCookie)x.getFirst((Object)cookieName)).map(HttpCookie::getValue).orElse(null);
        if (StringUtil.isBlank((CharSequence)cookieValue)) {
            return false;
        }
        String captchaCode = (String)this.captchaCache.get((Object)cookieValue, String.class);
        if (StringUtil.isBlank((CharSequence)captchaCode)) {
            return false;
        }
        boolean result = (userInputCaptcha = userInputCaptcha.toUpperCase()).equals(captchaCode);
        if (result) {
            this.captchaCache.evict((Object)cookieValue);
            ResponseCookie cookie = ResponseCookie.from((String)cookieName, (String)"").maxAge(0L).path("/").build();
            response.addCookie(cookie);
        }
        return result;
    }
}

