/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.captcha.servlet;

import java.util.concurrent.ThreadLocalRandom;
import javax.servlet.http.HttpServletResponse;
import net.dreamlu.mica.captcha.BaseCaptcha;
import net.dreamlu.mica.captcha.CaptchaUtils;
import net.dreamlu.mica.core.utils.StringUtil;
import net.dreamlu.mica.core.utils.WebUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;

public class MicaCaptchaServlet
extends BaseCaptcha {
    private static final Logger log = LoggerFactory.getLogger(MicaCaptchaServlet.class);

    public MicaCaptchaServlet(Cache captchaCache) {
        super(captchaCache);
    }

    public ResponseEntity<Resource> generate(HttpServletResponse response) {
        byte[] bytes = this.generateByteArray(response);
        ByteArrayResource resource = new ByteArrayResource(bytes);
        return new ResponseEntity((Object)resource, (MultiValueMap)this.getResponseHeaders(), HttpStatus.OK);
    }

    public byte[] generateByteArray(HttpServletResponse response) {
        String cookieName = this.getCookieName();
        String cookieValue = WebUtil.getCookieVal((String)cookieName);
        boolean hasCookie = true;
        if (StringUtil.isBlank((CharSequence)cookieValue)) {
            hasCookie = false;
            cookieValue = StringUtil.getUUID();
        }
        ThreadLocalRandom random = ThreadLocalRandom.current();
        String captchaCode = CaptchaUtils.generateCode(random).toUpperCase();
        if (!hasCookie) {
            WebUtil.setCookie((HttpServletResponse)response, (String)cookieName, (String)cookieValue, (int)-1);
        }
        this.captchaCache.put((Object)cookieValue, (Object)captchaCode);
        return CaptchaUtils.generate(random, captchaCode);
    }

    public boolean validate(HttpServletResponse response, String userInputCaptcha) {
        String cookieName;
        String cookieValue;
        if (log.isInfoEnabled()) {
            log.info("validate captcha userInputCaptcha is {}", (Object)userInputCaptcha);
        }
        if (StringUtil.isBlank((CharSequence)(cookieValue = WebUtil.getCookieVal((String)(cookieName = this.getCookieName()))))) {
            return false;
        }
        String captchaCode = (String)this.captchaCache.get((Object)cookieValue, String.class);
        if (StringUtil.isBlank((CharSequence)captchaCode)) {
            return false;
        }
        boolean result = (userInputCaptcha = userInputCaptcha.toUpperCase()).equals(captchaCode);
        if (result) {
            this.captchaCache.evict((Object)cookieValue);
            WebUtil.removeCookie((HttpServletResponse)response, (String)cookieName);
        }
        return result;
    }
}

