/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.captcha.servlet;

import net.dreamlu.mica.captcha.MicaCaptchaProperties;
import net.dreamlu.mica.captcha.servlet.MicaCaptchaServlet;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnProperty(value={"mica.captcha.enabled"}, havingValue="true", matchIfMissing=true)
public class ServletCaptchaConfiguration {
    private MicaCaptchaProperties captchaProperties;

    @Bean
    @ConditionalOnMissingBean
    public MicaCaptchaServlet dreamCaptcha(CacheManager cacheManager) {
        String cacheName = this.captchaProperties.getCacheName();
        Cache captchaCache = cacheManager.getCache(cacheName);
        MicaCaptchaServlet captcha = new MicaCaptchaServlet(captchaCache);
        String cookieName = this.captchaProperties.getCookieName();
        captcha.setCookieName(cookieName);
        return captcha;
    }

    public ServletCaptchaConfiguration(MicaCaptchaProperties captchaProperties) {
        this.captchaProperties = captchaProperties;
    }
}

