/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.BrokerServiceAware;
import org.apache.activemq.broker.Connection;
import org.apache.activemq.broker.Connector;
import org.apache.activemq.broker.TransportConnection;
import org.apache.activemq.broker.TransportStatusDetector;
import org.apache.activemq.broker.jmx.ManagedTransportConnector;
import org.apache.activemq.broker.region.ConnectorStatistics;
import org.apache.activemq.command.BrokerInfo;
import org.apache.activemq.security.MessageAuthorizationPolicy;
import org.apache.activemq.thread.TaskRunnerFactory;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportAcceptListener;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.transport.TransportServer;
import org.apache.activemq.transport.discovery.DiscoveryAgent;
import org.apache.activemq.transport.discovery.DiscoveryAgentFactory;
import org.apache.activemq.util.ServiceStopper;
import org.apache.activemq.util.ServiceSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransportConnector
implements Connector,
BrokerServiceAware {
    private static final Log LOG = LogFactory.getLog(TransportConnector.class);
    protected CopyOnWriteArrayList<TransportConnection> connections = new CopyOnWriteArrayList();
    protected TransportStatusDetector statusDector;
    private BrokerService brokerService;
    private TransportServer server;
    private URI uri;
    private BrokerInfo brokerInfo = new BrokerInfo();
    private TaskRunnerFactory taskRunnerFactory;
    private MessageAuthorizationPolicy messageAuthorizationPolicy;
    private DiscoveryAgent discoveryAgent;
    private ConnectorStatistics statistics = new ConnectorStatistics();
    private URI discoveryUri;
    private URI connectUri;
    private String name;
    private boolean disableAsyncDispatch;
    private boolean enableStatusMonitor = false;
    private Broker broker;

    public TransportConnector() {
    }

    public TransportConnector(TransportServer server) {
        this();
        URI uri;
        this.setServer(server);
        if (server != null && server.getConnectURI() != null && (uri = server.getConnectURI()) != null && uri.getScheme().equals("vm")) {
            this.setEnableStatusMonitor(false);
        }
    }

    public CopyOnWriteArrayList<TransportConnection> getConnections() {
        return this.connections;
    }

    public ManagedTransportConnector asManagedConnector(MBeanServer mbeanServer, ObjectName connectorName) throws IOException, URISyntaxException {
        ManagedTransportConnector rc = new ManagedTransportConnector(mbeanServer, connectorName, this.getServer());
        rc.setBrokerInfo(this.getBrokerInfo());
        rc.setConnectUri(this.getConnectUri());
        rc.setDisableAsyncDispatch(this.isDisableAsyncDispatch());
        rc.setDiscoveryAgent(this.getDiscoveryAgent());
        rc.setDiscoveryUri(this.getDiscoveryUri());
        rc.setEnableStatusMonitor(this.isEnableStatusMonitor());
        rc.setMessageAuthorizationPolicy(this.getMessageAuthorizationPolicy());
        rc.setName(this.getName());
        rc.setTaskRunnerFactory(this.getTaskRunnerFactory());
        rc.setUri(this.getUri());
        rc.setBrokerService(this.brokerService);
        return rc;
    }

    @Override
    public BrokerInfo getBrokerInfo() {
        return this.brokerInfo;
    }

    public void setBrokerInfo(BrokerInfo brokerInfo) {
        this.brokerInfo = brokerInfo;
    }

    @Deprecated
    public void setBrokerName(String name) {
        if (this.brokerInfo == null) {
            this.brokerInfo = new BrokerInfo();
        }
        this.brokerInfo.setBrokerName(name);
    }

    public TransportServer getServer() throws IOException, URISyntaxException {
        if (this.server == null) {
            this.setServer(this.createTransportServer());
        }
        return this.server;
    }

    public void setServer(TransportServer server) {
        this.server = server;
    }

    public URI getUri() {
        if (this.uri == null) {
            try {
                this.uri = this.getConnectUri();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public TaskRunnerFactory getTaskRunnerFactory() {
        return this.taskRunnerFactory;
    }

    public void setTaskRunnerFactory(TaskRunnerFactory taskRunnerFactory) {
        this.taskRunnerFactory = taskRunnerFactory;
    }

    @Override
    public ConnectorStatistics getStatistics() {
        return this.statistics;
    }

    public MessageAuthorizationPolicy getMessageAuthorizationPolicy() {
        return this.messageAuthorizationPolicy;
    }

    public void setMessageAuthorizationPolicy(MessageAuthorizationPolicy messageAuthorizationPolicy) {
        this.messageAuthorizationPolicy = messageAuthorizationPolicy;
    }

    @Override
    public void start() throws Exception {
        TransportServer server = this.getServer();
        this.broker = this.brokerService.getBroker();
        this.brokerInfo.setBrokerName(this.broker.getBrokerName());
        this.brokerInfo.setBrokerId(this.broker.getBrokerId());
        this.brokerInfo.setPeerBrokerInfos(this.broker.getPeerBrokerInfos());
        this.brokerInfo.setFaultTolerantConfiguration(this.broker.isFaultTolerantConfiguration());
        this.brokerInfo.setBrokerURL(server.getConnectURI().toString());
        server.setAcceptListener(new TransportAcceptListener(){

            public void onAccept(final Transport transport) {
                try {
                    Thread startThread = new Thread("ActiveMQ Transport Initiator: " + transport.getRemoteAddress()){

                        public void run() {
                            try {
                                Connection connection = TransportConnector.this.createConnection(transport);
                                connection.start();
                            }
                            catch (Exception e) {
                                ServiceSupport.dispose(transport);
                                this.onAcceptError(e);
                            }
                        }
                    };
                    startThread.setPriority(4);
                    startThread.start();
                }
                catch (Exception e) {
                    String remoteHost = transport.getRemoteAddress();
                    ServiceSupport.dispose(transport);
                    this.onAcceptError(e, remoteHost);
                }
            }

            public void onAcceptError(Exception error) {
                this.onAcceptError(error, null);
            }

            private void onAcceptError(Exception error, String remoteHost) {
                LOG.error("Could not accept connection " + (remoteHost == null ? "" : "from " + remoteHost) + ": " + error.getMessage());
                LOG.debug("Reason: " + error.getMessage(), error);
            }
        });
        server.setBrokerInfo(this.brokerInfo);
        server.start();
        DiscoveryAgent da = this.getDiscoveryAgent();
        if (da != null) {
            da.registerService(this.getConnectUri().toString());
            da.start();
        }
        if (this.enableStatusMonitor) {
            this.statusDector = new TransportStatusDetector(this);
            this.statusDector.start();
        }
        LOG.info("Connector " + this.getName() + " Started");
    }

    @Override
    public void stop() throws Exception {
        ServiceStopper ss = new ServiceStopper();
        if (this.discoveryAgent != null) {
            ss.stop(this.discoveryAgent);
        }
        if (this.server != null) {
            ss.stop(this.server);
            this.server = null;
        }
        if (this.statusDector != null) {
            this.statusDector.stop();
        }
        for (TransportConnection c : this.connections) {
            ss.stop(c);
        }
        ss.throwFirstException();
        LOG.info("Connector " + this.getName() + " Stopped");
    }

    protected Connection createConnection(Transport transport) throws IOException {
        TransportConnection answer = new TransportConnection(this, transport, this.broker, this.disableAsyncDispatch ? null : this.taskRunnerFactory);
        boolean statEnabled = this.getStatistics().isEnabled();
        answer.getStatistics().setEnabled(statEnabled);
        answer.setMessageAuthorizationPolicy(this.messageAuthorizationPolicy);
        return answer;
    }

    protected TransportServer createTransportServer() throws IOException, URISyntaxException {
        if (this.uri == null) {
            throw new IllegalArgumentException("You must specify either a server or uri property");
        }
        if (this.brokerService == null) {
            throw new IllegalArgumentException("You must specify the brokerService property. Maybe this connector should be added to a broker?");
        }
        return TransportFactory.bind(this.brokerService, this.uri);
    }

    public DiscoveryAgent getDiscoveryAgent() throws IOException {
        if (this.discoveryAgent == null) {
            this.discoveryAgent = this.createDiscoveryAgent();
        }
        return this.discoveryAgent;
    }

    protected DiscoveryAgent createDiscoveryAgent() throws IOException {
        if (this.discoveryUri != null) {
            return DiscoveryAgentFactory.createDiscoveryAgent(this.discoveryUri);
        }
        return null;
    }

    public void setDiscoveryAgent(DiscoveryAgent discoveryAgent) {
        this.discoveryAgent = discoveryAgent;
    }

    public URI getDiscoveryUri() {
        return this.discoveryUri;
    }

    public void setDiscoveryUri(URI discoveryUri) {
        this.discoveryUri = discoveryUri;
    }

    public URI getConnectUri() throws IOException, URISyntaxException {
        if (this.connectUri == null && this.server != null) {
            this.connectUri = this.server.getConnectURI();
        }
        return this.connectUri;
    }

    public void setConnectUri(URI transportUri) {
        this.connectUri = transportUri;
    }

    public void onStarted(TransportConnection connection) {
        this.connections.add(connection);
    }

    public void onStopped(TransportConnection connection) {
        this.connections.remove(connection);
    }

    public String getName() {
        if (this.name == null) {
            this.uri = this.getUri();
            if (this.uri != null) {
                this.name = this.uri.toString();
            }
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        String rc = this.getName();
        if (rc == null) {
            rc = super.toString();
        }
        return rc;
    }

    public boolean isDisableAsyncDispatch() {
        return this.disableAsyncDispatch;
    }

    public void setDisableAsyncDispatch(boolean disableAsyncDispatch) {
        this.disableAsyncDispatch = disableAsyncDispatch;
    }

    public boolean isEnableStatusMonitor() {
        return this.enableStatusMonitor;
    }

    public void setEnableStatusMonitor(boolean enableStatusMonitor) {
        this.enableStatusMonitor = enableStatusMonitor;
    }

    @Override
    public void setBrokerService(BrokerService brokerService) {
        this.brokerService = brokerService;
    }

    public Broker getBroker() {
        return this.broker;
    }

    public BrokerService getBrokerService() {
        return this.brokerService;
    }
}

